/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.pipe;

import com.tom.logisticsbridge.GuiHandler;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.network.SetIDPacket;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IItemSpaceControl;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class ResultPipe
extends CoreRoutedPipe
implements SetIDPacket.IIdPipe,
IProvideItems,
IChangeListener {
    public static Textures.TextureType TEXTURE = Textures.empty;
    public static Set<ResultPipe> AllResults = Collections.newSetFromMap(new WeakHashMap());
    public String id;
    private boolean cachedAreAllOrderesToBuffer;
    private WeakReference<TileEntity> lastAccessedCrafter;
    private List<NeighborTileEntity<TileEntity>> cachedCrafters = null;

    public ResultPipe(Item item) {
        super(item);
        this._orderItemManager = new LogisticsItemOrderManager((IChangeListener)this, (ILPPositionProvider)this);
    }

    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    public Textures.TextureType getCenterTexture() {
        return TEXTURE;
    }

    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public static void cleanup() {
        AllResults.clear();
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.id = nbttagcompound.func_74779_i("resultname");
        if (nbttagcompound.func_74764_b("resultid")) {
            this.id = Integer.toString(nbttagcompound.func_74762_e("resultid"));
        }
        this.ensureAllSatelliteStatus();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.id != null) {
            nbttagcompound.func_74778_a("resultname", this.id);
        }
        super.writeToNBT(nbttagcompound);
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.id.isEmpty() && AllResults.contains(this)) {
            AllResults.remove(this);
        }
        if (!this.id.isEmpty() || !AllResults.contains(this)) {
            AllResults.add(this);
        }
    }

    public void onAllowedRemoval() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        if (AllResults.contains(this)) {
            AllResults.remove(this);
        }
        while (this._orderItemManager.hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            this._orderItemManager.sendFailed();
        }
    }

    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.id).setId(0).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)entityplayer);
        entityplayer.openGui((Object)LogisticsBridge.modInstance, GuiHandler.GuiIDs.ResultPipe.ordinal(), this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void setPipeID(int fid, String integer, EntityPlayer player) {
        if (player == null) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(integer).setId(fid).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(integer).setId(fid).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
        }
        this.id = integer;
        this.ensureAllSatelliteStatus();
    }

    @Override
    public String getPipeID(int fid) {
        return this.id;
    }

    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filter) {
        System.out.println("ResultPipe.canProvide()");
    }

    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (promise instanceof LogisticsExtraDictPromise) {
            this.getItemOrderManager().removeExtras(((LogisticsExtraDictPromise)promise).getResource());
        }
        if (promise instanceof LogisticsExtraPromise) {
            this.getItemOrderManager().removeExtras(new DictResource(new ItemIdentifierStack(promise.item, promise.numberOfItems), null));
        }
        if (promise instanceof LogisticsDictPromise) {
            this.spawnParticle(Particles.WhiteParticle, 2);
            return this.getItemOrderManager().addOrder(((LogisticsDictPromise)promise).getResource(), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        this.spawnParticle(Particles.WhiteParticle, 2);
        return this.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
    }

    public void enabledUpdateEntity() {
        if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            if (this.isNthTick(6)) {
                this.cacheAreAllOrderesToBuffer();
            }
            if (this.getItemOrderManager().isFirstOrderWatched()) {
                if (this.lastAccessedCrafter == null) {
                    this.getItemOrderManager().setMachineProgress((byte)0);
                } else {
                    TileEntity tile = (TileEntity)this.lastAccessedCrafter.get();
                    if (tile != null) {
                        this.getItemOrderManager().setMachineProgress(SimpleServiceLocator.machineProgressProvider.getProgressForTile(tile));
                    } else {
                        this.getItemOrderManager().setMachineProgress((byte)0);
                    }
                }
            }
        } else {
            this.cachedAreAllOrderesToBuffer = false;
        }
        if (!this.isNthTick(6)) {
            return;
        }
        if (!this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            return;
        }
        List<NeighborTileEntity<TileEntity>> adjacentCrafters = this.locateCrafters();
        if (adjacentCrafters.size() < 1) {
            if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
                this.getItemOrderManager().sendFailed();
            }
            return;
        }
        this.spawnParticle(Particles.VioletParticle, 2);
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        block0: while (itemsleft > 0 && stacksleft > 0 && this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            NeighborTileEntity<TileEntity> adjacentCrafter;
            LogisticsItemOrder nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA});
            int maxtosend = Math.min(itemsleft, nextOrder.getResource().stack.getStackSize());
            maxtosend = Math.min(nextOrder.getResource().getItem().getMaxStackSize(), maxtosend);
            ItemStack extracted = null;
            NeighborTileEntity<TileEntity> adjacent = null;
            Iterator<NeighborTileEntity<TileEntity>> iterator = adjacentCrafters.iterator();
            while (iterator.hasNext() && ((extracted = this.extract(adjacent = (adjacentCrafter = iterator.next()), (IResource)nextOrder.getResource(), maxtosend)) == null || extracted.func_190916_E() <= 0)) {
            }
            if (extracted == null || extracted.func_190916_E() == 0) {
                this.getItemOrderManager().deferSend();
                break;
            }
            this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            this.lastAccessedCrafter = new WeakReference<TileEntity>(adjacent.getTileEntity());
            ItemIdentifier extractedID = ItemIdentifier.get((ItemStack)extracted);
            while (extracted.func_190916_E() > 0) {
                if (!this.doesExtractionMatch(nextOrder, extractedID)) {
                    LogisticsItemOrder startOrder = nextOrder;
                    if (this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
                        do {
                            this.getItemOrderManager().deferSend();
                        } while (!this.doesExtractionMatch(nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA}), extractedID) && startOrder != nextOrder);
                    }
                    if (startOrder == nextOrder) {
                        int numtosend = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                        if (numtosend == 0) continue block0;
                        --stacksleft;
                        itemsleft -= numtosend;
                        ItemStack stackToSend = extracted.func_77979_a(numtosend);
                        this.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, null);
                        continue;
                    }
                }
                int numtosend = Math.min(extracted.func_190916_E(), extractedID.getMaxStackSize());
                if ((numtosend = Math.min(numtosend, nextOrder.getResource().stack.getStackSize())) == 0) continue block0;
                --stacksleft;
                itemsleft -= numtosend;
                ItemStack stackToSend = extracted.func_77979_a(numtosend);
                if (nextOrder.getDestination() != null) {
                    SinkReply reply = LogisticsManager.canSink((ItemStack)stackToSend, (IRouter)nextOrder.getDestination().getRouter(), null, (boolean)true, (ItemIdentifier)ItemIdentifier.get((ItemStack)stackToSend), null, (boolean)true, (boolean)false);
                    boolean defersend = false;
                    if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) {
                        defersend = true;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend);
                    item.setDestination(nextOrder.getDestination().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.setAdditionalTargetInformation(nextOrder.getInformation());
                    this.queueRoutedItem((IRoutedItem)item, adjacent.getDirection());
                    this.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), defersend, (IRoutedItem)item);
                } else {
                    this.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, nextOrder.getInformation());
                    this.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), false, null);
                }
                if (!this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) continue;
                nextOrder = (LogisticsItemOrder)this.getItemOrderManager().peekAtTopRequest(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA});
            }
        }
    }

    private boolean doesExtractionMatch(LogisticsItemOrder nextOrder, ItemIdentifier extractedID) {
        return nextOrder.getResource().getItem().equals(extractedID) || this.getUpgradeManager().isFuzzyUpgrade() && nextOrder.getResource().getBitSet().nextSetBit(0) != -1 && nextOrder.getResource().matches(extractedID, IResource.MatchSettings.NORMAL);
    }

    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter) {
    }

    public void listenedChanged() {
    }

    public boolean areAllOrderesToBuffer() {
        return this.cachedAreAllOrderesToBuffer;
    }

    public void cacheAreAllOrderesToBuffer() {
        boolean result = true;
        for (LogisticsItemOrder order : this.getItemOrderManager()) {
            if (order.getDestination() instanceof IItemSpaceControl) {
                SinkReply reply = LogisticsManager.canSink((ItemStack)order.getResource().getItemStack().makeNormalStack(), (IRouter)order.getDestination().getRouter(), null, (boolean)true, (ItemIdentifier)order.getResource().getItem(), null, (boolean)true, (boolean)false);
                if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) continue;
                result = false;
                break;
            }
            result = false;
            break;
        }
        this.cachedAreAllOrderesToBuffer = result;
    }

    protected int neededEnergy() {
        return (int)(10.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public List<NeighborTileEntity<TileEntity>> locateCrafters() {
        if (this.cachedCrafters == null) {
            this.cachedCrafters = new WorldCoordinatesWrapper(this.getWorld(), this.getPos()).connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).filter(neighbor -> neighbor.isItemHandler() || neighbor.getInventoryUtil() != null).collect(Collectors.toList());
        }
        return this.cachedCrafters;
    }

    private ItemStack extract(NeighborTileEntity<TileEntity> adjacent, IResource item, int amount) {
        if (adjacent.getTileEntity().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, adjacent.getDirection().func_176734_d())) {
            return this.extractFromInventory(adjacent.getTileEntity(), item, amount, adjacent.getDirection());
        }
        return null;
    }

    private ItemStack extractFromInventory(TileEntity inv, IResource wanteditem, int count, EnumFacing dir) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, dir.func_176734_d());
        ItemIdentifier itemToExtract = null;
        if (wanteditem instanceof ItemResource) {
            itemToExtract = ((ItemResource)wanteditem).getItem();
        } else if (wanteditem instanceof DictResource) {
            int max = Integer.MIN_VALUE;
            ItemIdentifier toExtract = null;
            for (Map.Entry content : invUtil.getItemsAndCount().entrySet()) {
                if (!wanteditem.matches((ItemIdentifier)content.getKey(), IResource.MatchSettings.NORMAL) || (Integer)content.getValue() <= max) continue;
                max = (Integer)content.getValue();
                toExtract = (ItemIdentifier)content.getKey();
            }
            if (toExtract == null) {
                return null;
            }
            itemToExtract = toExtract;
        }
        int available = invUtil.itemCount(itemToExtract);
        if (available == 0) {
            return null;
        }
        if (!this.useEnergy(this.neededEnergy() * Math.min(count, available))) {
            return null;
        }
        return invUtil.getMultipleItems(itemToExtract, Math.min(count, available));
    }

    private ItemStack extractFromInventoryFiltered(TileEntity inv, ItemIdentifierInventory filter, boolean isExcluded, int filterInvLimit, EnumFacing dir) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, dir.func_176734_d());
        ItemIdentifier wanteditem = null;
        for (ItemIdentifier item : invUtil.getItemsAndCount().keySet()) {
            ItemIdentifierStack identStack;
            int i;
            boolean found;
            if (isExcluded) {
                found = false;
                for (i = 0; i < filter.func_70302_i_() && i < filterInvLimit; ++i) {
                    identStack = filter.getIDStackInSlot(i);
                    if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                wanteditem = item;
                continue;
            }
            found = false;
            for (i = 0; i < filter.func_70302_i_() && i < filterInvLimit; ++i) {
                identStack = filter.getIDStackInSlot(i);
                if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            wanteditem = item;
        }
        if (wanteditem == null) {
            return null;
        }
        int available = invUtil.itemCount(wanteditem);
        if (available == 0) {
            return null;
        }
        if (!this.useEnergy(this.neededEnergy() * Math.min(64, available))) {
            return null;
        }
        return invUtil.getMultipleItems(wanteditem, Math.min(64, available));
    }

    @Override
    public String getName(int id) {
        return "gui.resultPipe.id";
    }

    public void registerExtras(IPromise promise) {
        if (promise instanceof LogisticsDictPromise) {
            this.getItemOrderManager().addExtra(((LogisticsDictPromise)promise).getResource());
            return;
        }
        ItemIdentifierStack stack = new ItemIdentifierStack(promise.getItemType(), promise.getAmount());
        this.getItemOrderManager().addExtra(new DictResource(stack, null));
    }

    public String getResultPipeName() {
        return this.id;
    }

    public void extractCleanup(ItemIdentifierInventory _cleanupInventory, boolean cleanupModeIsExclude, int i) {
        List<NeighborTileEntity<TileEntity>> adjacentCrafters = this.locateCrafters();
        if (adjacentCrafters.size() > 0) {
            NeighborTileEntity<TileEntity> adjacentCrafter;
            ItemStack extracted = null;
            NeighborTileEntity<TileEntity> adjacent = null;
            Iterator<NeighborTileEntity<TileEntity>> iterator = adjacentCrafters.iterator();
            while (iterator.hasNext() && ((extracted = this.extractFromInventoryFiltered((adjacent = (adjacentCrafter = iterator.next())).getTileEntity(), _cleanupInventory, cleanupModeIsExclude, i, adjacent.getDirection())) == null || extracted.func_190916_E() <= 0)) {
            }
            if (extracted == null || extracted.func_190916_E() == 0) {
                return;
            }
            this.queueRoutedItem((IRoutedItem)SimpleServiceLocator.routedItemHelper.createNewTravelItem(extracted), EnumFacing.UP);
            this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
        }
    }

    public boolean hasRequests() {
        return this.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA});
    }

    public void onNeighborBlockChange() {
        this.clearCache();
        super.onNeighborBlockChange();
    }
}

