/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.tileentity;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.crafting.CraftingLink;
import appeng.me.GridAccessException;
import appeng.me.storage.MEMonitorIInventory;
import appeng.tile.grid.AENetworkInvTile;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IMEAdaptor;
import appeng.util.inv.InvOperation;
import com.google.common.collect.ImmutableSet;
import com.tom.logisticsbridge.AE2Plugin;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.api.BridgeStack;
import com.tom.logisticsbridge.api.IDynamicPatternDetailsAE;
import com.tom.logisticsbridge.item.VirtualPatternAE;
import com.tom.logisticsbridge.pipe.BridgePipe;
import com.tom.logisticsbridge.tileentity.IBridge;
import com.tom.logisticsbridge.util.DynamicInventory;
import com.tom.logisticsbridge.util.TileProfiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityBridgeAE
extends AENetworkInvTile
implements IGridHost,
ITickable,
IActionSource,
ICraftingRequester,
ICellContainer,
ICraftingProvider,
ICraftingCallback,
IMEInventoryHandler<IAEItemStack>,
IItemHandlerModifiable,
IDynamicPatternDetailsAE,
IBridge {
    private Optional<IActionHost> machine = Optional.of(this);
    private Set<ICraftingLink> links = new HashSet<ICraftingLink>();
    private Set<ICraftingPatternDetails> craftings = new HashSet<ICraftingPatternDetails>();
    private BridgePipe.Req reqapi;
    private MEMonitorIInventory meInv = new MEMonitorIInventory((InventoryAdaptor)new IMEAdaptor((IMEInventory)this, (IActionSource)this));
    private List<IMEInventoryHandler> cellArray = Collections.singletonList(this);
    private DynamicInventory dynInv = new DynamicInventory();
    private InvWrapper wrapper = new InvWrapper((IInventory)this.dynInv);
    private static final IItemStorageChannel ITEMS = (IItemStorageChannel)AE2Plugin.INSTANCE.api.storage().getStorageChannel(IItemStorageChannel.class);
    private static final IAEItemStack[] OVERFLOW;
    private IItemList<IAEItemStack> fakeItems = ITEMS.createList();
    private Map<ItemStack, Integer> toCraft = new HashMap<ItemStack, Integer>();
    private List<ItemStack> insertingStacks = new ArrayList<ItemStack>();
    private final IAEItemStack FAKE_ITEM = (IAEItemStack)ITEMS.createStack((Object)new ItemStack(LogisticsBridge.logisticsFakeItem, 1));
    private long lastInjectTime = -1L;
    private BridgePipe.OpResult lastPush;
    private long lastPushTime;
    private boolean disableLP;
    private boolean bridgeMode;
    private TileProfiler profiler = new TileProfiler("AE Bridge");
    private boolean updatingAECache;
    boolean readingFromNBT;

    public TileEntityBridgeAE() {
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                long wt = this.field_145850_b.func_82737_E();
                this.profiler.startProfiling();
                if (wt % 40L == 0L && this.getProxy().getNode() != null) {
                    this.profiler.startSection("Net update (every 40 ticks)");
                    this.profiler.startSection("Tick AE Inv");
                    this.updatingAECache = true;
                    boolean changed = this.meInv.onTick() == TickRateModulation.URGENT;
                    this.updatingAECache = false;
                    if (changed) {
                        this.profiler.endStartSection("Refresh AE item list");
                        this.getProxy().getNode().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                    }
                    if (this.reqapi != null) {
                        this.profiler.endStartSection("Detect crafting changes");
                        changed = this.reqapi.detectChanged();
                        if (changed) {
                            this.profiler.endStartSection("Refresh AE");
                            this.getProxy().getNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                        }
                    }
                    this.profiler.endStartSection("Updating queued crafting");
                    Map<ItemStack, Integer> map = this.toCraft;
                    synchronized (map) {
                        this.toCraft.entrySet().forEach(s -> this.craftStack((ItemStack)s.getKey(), (Integer)s.getValue(), false));
                        this.toCraft.clear();
                    }
                    this.dynInv.removeEmpties();
                    this.profiler.endSection();
                    this.profiler.endSection();
                }
                if (this.lastInjectTime == -1L) {
                    this.lastInjectTime = wt;
                } else {
                    if (this.lastInjectTime + 200L < wt && this.getProxy().getNode() != null && !this.dynInv.func_191420_l()) {
                        this.profiler.startSection("Empting internal inventory");
                        this.emptyInternalInventory();
                        this.profiler.endSection();
                    }
                    this.profiler.startSection("Emitting fake items");
                    try {
                        ICraftingGrid cg = (ICraftingGrid)this.getProxy().getGrid().getCache(ICraftingGrid.class);
                        if (cg.isRequesting(this.FAKE_ITEM)) {
                            this.insertItem(0, LogisticsBridge.fakeStack(1), false);
                        }
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    this.profiler.endSection();
                }
                this.profiler.finishProfiling();
            }
            catch (RuntimeException e) {
                e.addSuppressed(new RuntimeException("Profiler stage: " + this.profiler.lastSection));
                throw e;
            }
        }
    }

    private void emptyInternalInventory() {
        this.lastInjectTime = this.field_145850_b.func_82737_E() - 20L;
        for (int i = 0; i < this.dynInv.func_70302_i_(); ++i) {
            this.dynInv.func_70299_a(i, this.insertItem(0, this.dynInv.func_70301_a(i), false));
        }
        this.dynInv.removeEmpties();
    }

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    @Override
    public List<BridgeStack<ItemStack>> getItems() {
        if (this.getProxy().getNode() == null || this.disableLP && !this.bridgeMode) {
            return Collections.emptyList();
        }
        this.profiler.startSection("getItems");
        IStorageGrid g = (IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class);
        IMEMonitor i = g.getInventory((IStorageChannel)ITEMS);
        IItemList items = i.getAvailableItems(ITEMS.createList());
        List<BridgeStack<ItemStack>> list = Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(items.iterator(), 16), false).map(ae -> new BridgeStack<ItemStack>(ae.asItemStackRepresentation(), ae.getStackSize(), ae.isCraftable(), ae.getCountRequestable())).filter(s -> ((ItemStack)s.obj).func_77973_b() != LogisticsBridge.logisticsFakeItem && ((ItemStack)s.obj).func_77973_b() != LogisticsBridge.packageItem), Stream.concat(this.insertingStacks.stream(), this.dynInv.stream()).map(s -> new BridgeStack<ItemStack>((ItemStack)s, s.func_190916_E(), false, 0L))).collect(Collectors.toList());
        this.profiler.endSection();
        return list;
    }

    @Override
    public long countItem(ItemStack stack, boolean requestable) {
        ItemStack is;
        int i;
        if (this.getProxy().getNode() == null || this.disableLP && !this.bridgeMode) {
            return 0L;
        }
        this.profiler.startSection("countItems");
        int buffered = 0;
        for (i = 0; i < this.dynInv.func_70302_i_(); ++i) {
            is = this.dynInv.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)is) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)is)) continue;
            buffered += is.func_190916_E();
        }
        for (i = 0; i < this.insertingStacks.size(); ++i) {
            is = this.insertingStacks.get(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)is) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)is)) continue;
            buffered += is.func_190916_E();
        }
        IStorageGrid g = (IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class);
        IMEMonitor i2 = g.getInventory((IStorageChannel)ITEMS);
        IItemList items = i2.getAvailableItems(ITEMS.createList());
        IAEItemStack is2 = (IAEItemStack)items.findPrecise(ITEMS.createStack((Object)stack));
        long inAE = is2 == null ? 0L : (requestable ? is2.getStackSize() + is2.getCountRequestable() : is2.getStackSize());
        this.profiler.endSection();
        return inAE + (long)buffered;
    }

    @Override
    public ItemStack extractStack(ItemStack stack, int count, boolean simulate) {
        if (this.getProxy().getNode() == null) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < this.dynInv.func_70302_i_(); ++i) {
            ItemStack is = this.dynInv.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)is) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)is)) continue;
            return this.wrapper.extractItem(i, count, simulate);
        }
        IStorageGrid g = (IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class);
        IMEMonitor i = g.getInventory((IStorageChannel)ITEMS);
        IAEItemStack st = (IAEItemStack)ITEMS.createStack((Object)stack);
        st.setStackSize((long)count);
        IAEItemStack is = (IAEItemStack)i.extractItems((IAEStack)st, simulate ? Actionable.SIMULATE : Actionable.MODULATE, (IActionSource)this);
        return is == null ? ItemStack.field_190927_a : is.createItemStack();
    }

    @Override
    public void craftStack(ItemStack stack, int count, boolean simulate) {
        if (this.getProxy().getNode() == null) {
            return;
        }
        ICraftingGrid g = (ICraftingGrid)this.getProxy().getNode().getGrid().getCache(ICraftingGrid.class);
        IAEItemStack aestack = (IAEItemStack)ITEMS.createStack((Object)stack);
        aestack.setStackSize((long)count);
        g.beginCraftingJob(this.field_145850_b, this.getProxy().getNode().getGrid(), (IActionSource)this, aestack, (ICraftingCallback)this);
    }

    public Optional<EntityPlayer> player() {
        return Optional.empty();
    }

    public Optional<IActionHost> machine() {
        return this.machine;
    }

    public <T> Optional<T> context(Class<T> key) {
        return Optional.empty();
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        return channel == ITEMS ? this.cellArray : Collections.emptyList();
    }

    public int getPriority() {
        return 0;
    }

    public void blinkCell(int slot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculationComplete(ICraftingJob job) {
        if (this.getProxy().getNode() == null) {
            return;
        }
        if (job.isSimulation()) {
            return;
        }
        ICraftingGrid g = (ICraftingGrid)this.getProxy().getNode().getGrid().getCache(ICraftingGrid.class);
        ICraftingLink link = g.submitJob(job, (ICraftingRequester)this, null, false, (IActionSource)this);
        if (link == null) {
            Map<ItemStack, Integer> map = this.toCraft;
            synchronized (map) {
                this.toCraft.put(job.getOutput().asItemStackRepresentation(), (int)job.getOutput().getStackSize());
            }
        }
        if (link != null) {
            this.links.add(link);
        }
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.copyOf(this.links);
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        if (mode == Actionable.MODULATE) {
            this.lastInjectTime = this.field_145850_b.func_82737_E();
            this.dynInv.insert(items.createItemStack());
            return null;
        }
        return null;
    }

    public void jobStateChange(ICraftingLink link) {
        this.links.remove(link);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList lst = new NBTTagList();
        compound.func_74782_a("links", (NBTBase)lst);
        this.links.stream().filter(e -> e != null).map(l -> {
            NBTTagCompound t = new NBTTagCompound();
            l.writeToNBT(t);
            return t;
        }).forEach(arg_0 -> ((NBTTagList)lst).func_74742_a(arg_0));
        NBTTagList lst2 = new NBTTagList();
        compound.func_74782_a("toCraft", (NBTBase)lst2);
        this.toCraft.entrySet().stream().filter(e -> e != null).map(l -> {
            NBTTagCompound t = new NBTTagCompound();
            ((ItemStack)l.getKey()).func_77955_b(t);
            t.func_74768_a("Count", ((Integer)l.getValue()).intValue());
            return t;
        }).forEach(arg_0 -> ((NBTTagList)lst2).func_74742_a(arg_0));
        this.dynInv.removeEmpties();
        compound.func_74782_a("intInventory", (NBTBase)LogisticsBridge.saveAllItems(this.dynInv));
        compound.func_74757_a("bridgeMode", this.bridgeMode);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        try {
            this.readingFromNBT = true;
            super.func_145839_a(compound);
        }
        finally {
            this.readingFromNBT = false;
        }
        LogisticsBridge.loadAllItems(compound.func_150295_c("intInventory", 10), this.dynInv);
        NBTTagList lst = compound.func_150295_c("links", 10);
        this.toCraft.clear();
        this.links.clear();
        for (i = 0; i < lst.func_74745_c(); ++i) {
            tag = lst.func_150305_b(i);
            this.links.add((ICraftingLink)new CraftingLink(tag, (ICraftingRequester)this));
        }
        lst = compound.func_150295_c("toCraft", 10);
        for (i = 0; i < lst.func_74745_c(); ++i) {
            tag = lst.func_150305_b(i);
            int count = tag.func_74762_e("Count");
            this.toCraft.put(new ItemStack(tag), count);
        }
        this.bridgeMode = compound.func_74767_n("bridgeMode");
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (input.asItemStackRepresentation().func_77973_b() == LogisticsBridge.logisticsFakeItem) {
            return null;
        }
        return input;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable type, IActionSource src) {
        if (request.createItemStack().func_77973_b() == LogisticsBridge.logisticsFakeItem) {
            IAEItemStack req = (IAEItemStack)this.fakeItems.findPrecise((IAEStack)request);
            if (req == null) {
                return null;
            }
            long min = Math.min(req.getStackSize(), request.getStackSize());
            IAEItemStack ret = req.copy();
            ret.setStackSize(min);
            if (type == Actionable.MODULATE) {
                req.decStackSize(min);
            }
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        if (this.reqapi == null) {
            return out;
        }
        this.profiler.startSection("getAvailableItems");
        this.craftings.clear();
        this.fakeItems.resetStatus();
        try {
            if (Loader.instance().getLoaderState() == LoaderState.SERVER_STOPPING) {
                IItemList<IAEItemStack> iItemList = out;
                return iItemList;
            }
            this.profiler.startSection("List LP");
            List<ItemStack> pi = this.reqapi.getProvidedItems();
            List<ItemStack> ci = this.reqapi.getCraftedItems();
            this.profiler.endStartSection("Wrap AE");
            pi.stream().map(arg_0 -> ((IItemStorageChannel)ITEMS).createStack(arg_0)).map(s -> {
                s.setCraftable(true);
                s.setCountRequestable(s.getStackSize());
                s.setStackSize(0L);
                return s;
            }).forEach(arg_0 -> out.add(arg_0));
            ci.stream().map(arg_0 -> ((IItemStorageChannel)ITEMS).createStack(arg_0)).forEach(arg_0 -> out.addCrafting(arg_0));
            IDynamicPatternDetailsAE.TileEntityWrapper wr = new IDynamicPatternDetailsAE.TileEntityWrapper((TileEntity)this);
            this.profiler.endStartSection("Wrap VP item");
            pi.stream().map(i -> {
                ItemStack r = i.func_77946_l();
                r.func_190920_e(1);
                this.fakeItems.add(ITEMS.createStack((Object)LogisticsBridge.fakeStack(r, i.func_190916_E())));
                return VirtualPatternAE.create((IAEItemStack)ITEMS.createStack((Object)r), wr);
            }).forEach(this.craftings::add);
            this.profiler.endStartSection("Wrap VP craft");
            ci.stream().map(i -> VirtualPatternAE.create((IAEItemStack)ITEMS.createStack(i), wr)).forEach(this.craftings::add);
            this.profiler.endStartSection("Mount Fake Items");
            this.fakeItems.forEach(arg_0 -> out.addStorage(arg_0));
            this.profiler.endSection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.profiler.endSection();
        }
        return out;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return ITEMS;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack input) {
        return input.asItemStackRepresentation().func_77973_b() == LogisticsBridge.logisticsFakeItem;
    }

    public boolean canAccept(IAEItemStack input) {
        return input.asItemStackRepresentation().func_77973_b() == LogisticsBridge.logisticsFakeItem;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return i == 1;
    }

    public int getSlots() {
        return this.wrapper.getSlots() + 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.wrapper.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.getProxy().getNode() == null || stack.func_190926_b()) {
            return stack;
        }
        IStorageGrid g = (IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class);
        IMEMonitor i = g.getInventory((IStorageChannel)ITEMS);
        IAEItemStack st = (IAEItemStack)ITEMS.createStack((Object)stack);
        IAEItemStack r = (IAEItemStack)i.injectItems((IAEStack)st, simulate ? Actionable.SIMULATE : Actionable.MODULATE, (IActionSource)this);
        return r == null ? ItemStack.field_190927_a : r.createItemStack();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.wrapper.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.wrapper.setStackInSlot(slot, stack);
    }

    public void saveChanges(ICellInventory<?> arg0) {
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.reqapi == null) {
            return false;
        }
        this.insertingStacks.clear();
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            if (table.func_70301_a(i).func_77973_b() == LogisticsBridge.logisticsFakeItem) continue;
            this.insertingStacks.add(table.func_70301_a(i));
        }
        BridgePipe.OpResult opres = this.reqapi.performRequest(patternDetails.getOutputs()[0].createItemStack(), true);
        boolean pushed = opres.missing.isEmpty();
        this.insertingStacks.clear();
        if (pushed) {
            this.lastInjectTime = this.field_145850_b.func_82737_E();
            for (int i = 0; i < table.func_70302_i_(); ++i) {
                ItemStack stack = table.func_70301_a(i);
                if (stack.func_77973_b() == LogisticsBridge.logisticsFakeItem) continue;
                this.dynInv.insert(stack.func_77946_l());
            }
        } else {
            this.lastPush = opres;
            this.lastPushTime = System.currentTimeMillis();
        }
        return pushed;
    }

    public boolean isBusy() {
        return false;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.craftings.forEach(c -> craftingTracker.addCraftingOption((ICraftingMedium)this, c));
        craftingTracker.setEmitable(this.FAKE_ITEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAEItemStack[] getInputs(ItemStack res, IAEItemStack[] def, boolean condensed) {
        if (this.reqapi == null) {
            return def;
        }
        try {
            this.disableLP = true;
            boolean craftable = this.reqapi.getCraftedItems().stream().anyMatch(s -> res.func_77969_a(s));
            BridgePipe.OpResult r = this.reqapi.simulateRequest(res, 1, true);
            IAEItemStack[] inputs = (IAEItemStack[])Stream.concat(r.missing.stream(), Stream.of(LogisticsBridge.fakeStack(craftable ? null : res, 1))).map(arg_0 -> ((IItemStorageChannel)ITEMS).createStack(arg_0)).toArray(IAEItemStack[]::new);
            if (inputs.length > 9) {
                IAEItemStack[] iAEItemStackArray = OVERFLOW;
                return iAEItemStackArray;
            }
            IAEItemStack[] iAEItemStackArray = inputs;
            return iAEItemStackArray;
        }
        finally {
            this.disableLP = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAEItemStack[] getOutputs(ItemStack res, IAEItemStack[] def, boolean condensed) {
        if (this.reqapi == null || !this.reqapi.isDefaultRoute() || Loader.instance().getLoaderState() == LoaderState.SERVER_STOPPING) {
            return def;
        }
        try {
            this.disableLP = true;
            BridgePipe.OpResult r = this.reqapi.simulateRequest(res, 6, true);
            ArrayList<IAEItemStack> ret = new ArrayList<IAEItemStack>();
            IAEItemStack resAE = (IAEItemStack)ITEMS.createStack((Object)res);
            if (def != null || this.bridgeMode) {
                ret.add(resAE.copy());
            }
            if (!this.bridgeMode) {
                r.extra.forEach(i -> {
                    IAEItemStack is = (IAEItemStack)ITEMS.createStack(i);
                    boolean added = false;
                    for (IAEItemStack e : ret) {
                        if (!e.equals(is)) continue;
                        e.add(is);
                        added = true;
                        break;
                    }
                    if (!added) {
                        ret.add(is);
                    }
                });
            }
            if (def == null && !this.bridgeMode) {
                for (IAEItemStack e : ret) {
                    if (!e.equals(resAE)) continue;
                    res.func_190920_e((int)e.getStackSize() + res.func_190916_E());
                }
                Iterator iterator = null;
                return iterator;
            }
            IAEItemStack[] iAEItemStackArray = ret.toArray(new IAEItemStack[ret.size()]);
            return iAEItemStackArray;
        }
        finally {
            this.disableLP = false;
        }
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInternalInventory() {
        return this.readingFromNBT ? EmptyHandler.INSTANCE : this;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public String infoString() {
        StringBuilder b = new StringBuilder();
        if (this.disableLP) {
            b.append("  disableLP flag is stuck\n");
        }
        b.append("Mode: ");
        b.append(this.bridgeMode ? "Simple Mode" : "Smart Mode");
        b.append('\n');
        if (this.lastPush != null) {
            b.append("  Missing items:\n");
        }
        return b.toString();
    }

    public void blockClicked(EntityPlayer playerIn) {
        if (playerIn.func_70093_af()) {
            this.bridgeMode = !this.bridgeMode;
            TextComponentTranslation text = new TextComponentTranslation("chat.logisticsbridge.bridgeMode", new Object[]{"AE", this.bridgeMode ? new TextComponentTranslation("chat.logisticsbridge.bridgeMode.simple", new Object[0]) : new TextComponentTranslation("chat.logisticsbridge.bridgeMode.smart", new Object[0])});
            playerIn.func_145747_a((ITextComponent)text);
        } else if (playerIn.func_184614_ca().func_77973_b() == Items.field_151055_y) {
            if (this.profiler.resultPlayer != null) {
                return;
            }
            TextComponentString text = new TextComponentString("Bridge diagnostics started, testing for 200 ticks (10 sec)...");
            playerIn.func_145747_a((ITextComponent)text);
            this.profiler.setResultPlayer(playerIn, 200);
        } else {
            String info = this.infoString();
            if (info.isEmpty()) {
                info = "  No problems";
            }
            TextComponentString text = new TextComponentString("AE Bridge\n" + info);
            if (this.lastPush != null) {
                for (ItemStack i : this.lastPush.missing) {
                    text.func_150258_a("    ");
                    text.func_150257_a(i.func_151000_E());
                    text.func_150258_a(" * " + i.func_190916_E() + "\n");
                }
                long ago = System.currentTimeMillis() - this.lastPushTime;
                text.func_150258_a(String.format("  %1$tH %1$tM,%1$tS ago\n", ago));
            }
            if (this.dynInv.func_70302_i_() > 0) {
                text.func_150258_a("\nStored items:\n");
                for (int i = 0; i < this.dynInv.func_70302_i_(); ++i) {
                    ItemStack is = this.dynInv.func_70301_a(i);
                    text.func_150258_a("    ");
                    text.func_150257_a(is.func_151000_E());
                    text.func_150258_a(" * " + is.func_190916_E() + "\n");
                }
            }
            playerIn.func_145747_a((ITextComponent)text);
        }
    }

    @Override
    public void setReqAPI(BridgePipe.Req reqapi) {
        this.reqapi = reqapi;
    }

    static {
        ItemStack is = new ItemStack(Blocks.field_180401_cv);
        is.func_190924_f("tooltip.logisticsbridge.smartModeOverflow");
        OVERFLOW = new IAEItemStack[]{(IAEItemStack)ITEMS.createStack((Object)is)};
    }
}

