/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.block;

import botaunomy.ItemStackType;
import botaunomy.block.tile.TileElvenAvatar;
import botaunomy.item.RodItem;
import botaunomy.registry.BlockBase;
import botaunomy.registry.TileEntityRegisteredBlocked;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class ElvenAvatarBlock
extends BlockBase
implements ILexiconable,
TileEntityRegisteredBlocked,
IWandHUD {
    public static final String NAME = "elven_avatar";
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.3125, 0.0, 0.21875, 0.6875, 1.0625, 0.78125);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.21875, 0.0, 0.3125, 0.78125, 1.0625, 0.6875);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public ElvenAvatarBlock() {
        super(Material.field_151573_f, NAME);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("botaunomy.elven_avatar");
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(pos);
        if (avatar != null) {
            avatar.renderHUD(mc, res);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(pos);
        int signal = (int)Math.ceil(Math.floor((double)avatar.getCurrentMana() / 100000.0 * 480.0) / 32.0);
        return signal;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((EnumFacing)state.func_177229_b((IProperty)BotaniaStateProps.CARDINALS)).func_176740_k() == EnumFacing.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS, POWERED});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)BotaniaStateProps.CARDINALS)).func_176745_a();
        meta <<= 1;
        return meta |= (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int power = meta & 1;
        if ((meta >>= 1) < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(power == 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer realPlayer, EnumHand hand, EnumFacing s, float xs, float ys, float zs) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(pos);
        ItemStack stackOnRealPlayer = realPlayer.func_184586_b(hand);
        ArrayList<ItemStackType.Types> stackOnRealPlayerType = ItemStackType.getTypeTool(stackOnRealPlayer);
        boolean rodWorkOnPlayer = stackOnRealPlayer.func_77973_b() instanceof RodItem && ItemStackType.isStackType(stackOnRealPlayerType, ItemStackType.Types.ROD_WORK);
        boolean wandOnPlayer = stackOnRealPlayer.func_77977_a().equals("item.twigWand");
        if (ItemStackType.isStackType(avatar.getInventory().getType1(), ItemStackType.Types.ROD_WORK)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)realPlayer, (ItemStack)avatar.getInventory().take1());
            avatar.func_70296_d();
            return false;
        } else if (avatar.getInventory().getType0().get(0) != ItemStackType.Types.NONE && !rodWorkOnPlayer) {
            if (!wandOnPlayer) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)realPlayer, (ItemStack)avatar.getInventory().take0());
                return true;
            }
            avatar.onWanded(realPlayer, avatar.getInventory().get0());
            return false;
        } else {
            if (stackOnRealPlayer.func_190926_b()) return false;
            boolean dontGive = wandOnPlayer;
            dontGive |= ItemStackType.isStackType(stackOnRealPlayerType, ItemStackType.Types.BLOCK);
            dontGive |= ItemStackType.isStackType(stackOnRealPlayerType, ItemStackType.Types.NONE);
            if (wandOnPlayer) {
                avatar.onWanded(realPlayer, avatar.getInventory().get0());
            }
            if (dontGive) return false;
            if (rodWorkOnPlayer) {
                if (!ItemStackType.isStackType(avatar.getInventory().getType0(), ItemStackType.Types.BREAK)) return false;
                avatar.getInventory().set1(stackOnRealPlayer.func_77979_a(1));
                avatar.resetBreak();
                avatar.func_70296_d();
            } else {
                avatar.getInventory().set0(stackOnRealPlayer.func_77979_a(1));
            }
            avatar.func_70296_d();
            return true;
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(pos);
        InventoryHelper.dropInventory((TileSimpleInventory)avatar, (World)world, (IBlockState)state, (BlockPos)pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, boolean enableStats) {
        TileElvenAvatar avatar = (TileElvenAvatar)worldIn.func_175625_s(pos);
        if (avatar != null) {
            avatar.onBreak();
        }
        return super.removedByPlayer(state, worldIn, pos, player, enableStats);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileElvenAvatar();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileElvenAvatar.class;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.avatar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        this.customRegisterModels();
    }
}

