/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.block.tile;

import botaunomy.Botaunomy;
import botaunomy.ItemStackType;
import botaunomy.block.tile.TileElvenAvatar;
import botaunomy.config.Config;
import botaunomy.network.MessagePlayer;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.mana.IManaItem;

@Mod.EventBusSubscriber
public class ElvenFakePlayerHandler {
    private WeakReference<FakePlayer> refMyFakePlayer = new WeakReference<Object>(null);
    EntityPlayer myElvenEntityPlayer = null;
    private ArrayList<ItemStackType.Types> typePlayerToolCache;
    TileElvenAvatar avatarParent;

    public ElvenFakePlayerHandler(World ws, BlockPos pos, TileElvenAvatar avatar) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.avatarParent = avatar;
        if (ws == null) {
            return;
        }
        if (!ws.field_72995_K) {
            this.initServer(ws, pos, avatar);
        }
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K && evt.getEntityPlayer().equals(this.refMyFakePlayer.get())) {
            ItemStack itemStack = evt.getEntityPlayer().func_184614_ca();
            Multimap attr = itemStack.func_111283_C(EntityEquipmentSlot.MAINHAND);
            Collection coldmg = attr.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            float dmg = 0.0f;
            for (AttributeModifier i : coldmg) {
                dmg = (float)i.func_111164_d();
            }
            evt.setResult(Event.Result.ALLOW);
            evt.setDamageModifier(dmg * 1.2f);
        }
    }

    public WeakReference<FakePlayer> getRefAndRetryInit(World ws, BlockPos pos, TileElvenAvatar avatar) {
        if (ws.field_72995_K) {
            return null;
        }
        if (this.refMyFakePlayer == null) {
            return null;
        }
        if (this.refMyFakePlayer.get() == null) {
            this.initServer(ws, pos, avatar);
        }
        return this.refMyFakePlayer;
    }

    private void initPlayerPos(EntityPlayer player, BlockPos pos, TileElvenAvatar avatar) {
        BlockPos spawnPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        player.func_180473_a(spawnPos, false);
        player.field_70165_t = (float)pos.func_177958_n() + 0.5f;
        player.field_70163_u = (float)pos.func_177956_o() - 0.5f;
        player.field_70161_v = (float)pos.func_177952_p() + 0.5f;
    }

    public void initClient(World w, BlockPos pos, TileElvenAvatar avatar) {
        if (!w.field_72995_K) {
            return;
        }
        if (Config.disableFakePlayerAddedToWorld) {
            return;
        }
        UUID nameUuid = avatar.getUUID();
        if (nameUuid == null) {
            return;
        }
        if (this.myElvenEntityPlayer == null) {
            EntityPlayer f = this.findPlayer(w, nameUuid);
            if (f == null) {
                int navatar = TileElvenAvatar.nAvatarClient++;
                GameProfile gameProfile = new GameProfile(nameUuid, "ElvenAvt" + navatar + "_" + nameUuid.toString().substring(0, 5));
                this.myElvenEntityPlayer = new ElvenEntityPlayer(w, gameProfile);
                ((IsetSpectator)this.myElvenEntityPlayer).setSpectator(avatar.playerIsSpectator);
                this.initPlayerPos(this.myElvenEntityPlayer, pos, avatar);
                w.field_73010_i.add(this.myElvenEntityPlayer);
            } else {
                this.myElvenEntityPlayer = f;
            }
        }
    }

    public void setSpectator(boolean value) {
        if (this.myElvenEntityPlayer != null) {
            ((IsetSpectator)this.myElvenEntityPlayer).setSpectator(value);
        }
    }

    public boolean isSpectator() {
        if (this.myElvenEntityPlayer != null) {
            return ((IsetSpectator)this.myElvenEntityPlayer).getSpectator();
        }
        return true;
    }

    private void setFakeConnection(ElvenFakePlayer fakeplayer) {
        fakeplayer.field_71135_a = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)this.refMyFakePlayer.get()){

            public void func_147359_a(Packet packetIn) {
            }
        };
    }

    private EntityPlayer findPlayer(World w, UUID nameUuid) {
        List entities = w.field_73010_i;
        for (int i = 0; i < entities.size(); ++i) {
            if (!((EntityPlayer)entities.get(i)).func_146103_bH().getId().equals(nameUuid)) continue;
            return (EntityPlayer)entities.get(i);
        }
        return null;
    }

    public void removePlayer(World w, TileElvenAvatar avatar) {
        if (w == null) {
            return;
        }
        UUID nameUuid = avatar.getUUID();
        List entities = w.field_73010_i;
        for (int i = 0; i < entities.size(); ++i) {
            if (!((EntityPlayer)entities.get(i)).func_146103_bH().getId().equals(nameUuid)) continue;
            entities.remove(i);
            break;
        }
    }

    private void initServer(World ws, BlockPos pos, TileElvenAvatar avatar) {
        try {
            if (!(ws instanceof WorldServer)) {
                return;
            }
            WorldServer wss = (WorldServer)ws;
            UUID nameUuid = avatar.getUUID();
            if (nameUuid == null) {
                nameUuid = UUID.randomUUID();
                avatar.setUUID(nameUuid);
            }
            GameProfile gameProfile = new GameProfile(nameUuid, "FkElvenAvt_" + nameUuid.toString().substring(0, 5));
            ElvenFakePlayer myFakePlayer = new ElvenFakePlayer(wss, gameProfile);
            this.refMyFakePlayer = new WeakReference<ElvenFakePlayer>(myFakePlayer);
            this.setFakeConnection(myFakePlayer);
            this.initPlayerPos((EntityPlayer)myFakePlayer, pos, avatar);
            myFakePlayer.field_70177_z = ElvenFakePlayerHandler.getYaw(avatar.getAvatarFacing());
            myFakePlayer.field_70125_A = 0.0f;
            if (this.myElvenEntityPlayer == null && !Config.disableFakePlayerAddedToWorld) {
                EntityPlayer f = this.findPlayer(ws, nameUuid);
                if (f == null) {
                    int navatar = TileElvenAvatar.nAvatarServer++;
                    GameProfile gameProfileCopy = new GameProfile(nameUuid, "ElvenAvt" + navatar);
                    ElvenFakePlayer myElvenEntityPlayerCopy = new ElvenFakePlayer(wss, gameProfileCopy);
                    myElvenEntityPlayerCopy.func_193104_a((EntityPlayerMP)myFakePlayer, false);
                    myElvenEntityPlayerCopy.setSpectator(avatar.playerIsSpectator);
                    this.initPlayerPos((EntityPlayer)myElvenEntityPlayerCopy, pos, avatar);
                    this.setFakeConnection(myElvenEntityPlayerCopy);
                    myElvenEntityPlayerCopy.goToSleep(Config.fakePlayersAreAsleep);
                    ws.field_73010_i.add(myElvenEntityPlayerCopy);
                    this.myElvenEntityPlayer = myElvenEntityPlayerCopy;
                } else {
                    this.myElvenEntityPlayer = f;
                }
                new MessagePlayer(pos, nameUuid);
            }
            this.inventoryToFakePlayer(avatar);
            ItemStack fakeTablet = new ItemStack((Item)new FakeTable());
            myFakePlayer.field_71071_by.field_70462_a.set(35, (Object)fakeTablet);
        }
        catch (Exception e) {
            Botaunomy.logger.error("Exception thrown trying to create fake player : " + e.getMessage());
            this.refMyFakePlayer = null;
        }
    }

    public static float getYaw(EnumFacing currentFacing) {
        switch (currentFacing) {
            default: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case EAST: 
        }
        return 270.0f;
    }

    public ArrayList<ItemStackType.Types> stackMainHandType() {
        return this.typePlayerToolCache;
    }

    public ItemStack stackMainHand() {
        if (this.refMyFakePlayer.get() != null) {
            return ((FakePlayer)this.refMyFakePlayer.get()).func_184614_ca();
        }
        return ItemStack.field_190927_a;
    }

    public void fakePlayerToInventory(TileElvenAvatar avatar) {
        FakePlayer player = (FakePlayer)this.refMyFakePlayer.get();
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null || stack == ItemStack.field_190927_a) {
            return;
        }
        if (stack.func_190926_b()) {
            avatar.getInventory().empty0();
        } else {
            avatar.getInventory().set0(stack);
        }
        this.typePlayerToolCache = avatar.getInventory().getType0();
    }

    public void inventoryToFakePlayer(TileElvenAvatar avatar) {
        FakePlayer player = (FakePlayer)this.refMyFakePlayer.get();
        if (player != null) {
            ItemStack inventoryItem = avatar.getInventory().get0();
            if (inventoryItem != null && !inventoryItem.func_190926_b()) {
                player.func_184611_a(EnumHand.MAIN_HAND, inventoryItem);
                this.typePlayerToolCache = avatar.getInventory().getType0();
            } else {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                this.typePlayerToolCache = new ArrayList();
                this.typePlayerToolCache.add(ItemStackType.Types.NONE);
            }
        }
    }

    private class FakeTable
    extends Item
    implements IManaItem {
        private FakeTable() {
        }

        public int getMana(ItemStack stack) {
            if (ElvenFakePlayerHandler.this.avatarParent != null) {
                return ElvenFakePlayerHandler.this.avatarParent.getCurrentMana();
            }
            return 0;
        }

        public int getMaxMana(ItemStack stack) {
            return 100000;
        }

        public void addMana(ItemStack stack, int mana) {
            if (ElvenFakePlayerHandler.this.avatarParent != null) {
                ElvenFakePlayerHandler.this.avatarParent.recieveMana(mana);
            }
        }

        public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
            return false;
        }

        public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
            return false;
        }

        public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
            return false;
        }

        public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
            return true;
        }

        public boolean isNoExport(ItemStack stack) {
            return false;
        }
    }

    public class ElvenFakePlayer
    extends FakePlayer
    implements IsetSpectator {
        private boolean spectatorValue;
        private boolean elvenSleeping;

        public ElvenFakePlayer(WorldServer world, GameProfile name) {
            super(world, name);
            this.spectatorValue = false;
            this.field_70122_E = true;
            this.func_174810_b(true);
            this.func_70095_a(false);
        }

        public void goToSleep(boolean value) {
            this.elvenSleeping = value;
        }

        public boolean func_71026_bH() {
            return this.elvenSleeping;
        }

        public boolean func_70608_bn() {
            return this.elvenSleeping;
        }

        @Override
        public void setSpectator(boolean value) {
            this.spectatorValue = value;
        }

        @Override
        public boolean getSpectator() {
            return this.spectatorValue;
        }

        public boolean func_175149_v() {
            return this.spectatorValue;
        }

        public float func_184825_o(float adjustTicks) {
            return super.func_184825_o(adjustTicks);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            ++this.field_184617_aD;
        }
    }

    public class ElvenEntityPlayer
    extends EntityPlayer
    implements IsetSpectator {
        private boolean spectatorValue;
        private boolean elvenSleeping;

        public ElvenEntityPlayer(World worldIn, GameProfile gameProfileIn) {
            super(worldIn, gameProfileIn);
            this.spectatorValue = false;
            this.field_70122_E = true;
            this.func_174810_b(true);
            this.func_70095_a(false);
            this.field_71083_bS = false;
            this.elvenSleeping = false;
        }

        public boolean func_71026_bH() {
            return this.elvenSleeping;
        }

        public boolean func_70608_bn() {
            return this.elvenSleeping;
        }

        @Override
        public void setSpectator(boolean value) {
            this.spectatorValue = value;
        }

        @Override
        public boolean getSpectator() {
            return this.spectatorValue;
        }

        public boolean func_175149_v() {
            return this.spectatorValue;
        }

        public boolean func_184812_l_() {
            return true;
        }
    }

    public static interface IsetSpectator {
        public void setSpectator(boolean var1);

        public boolean getSpectator();
    }
}

