/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.block.tile;

import botaunomy.ItemStackType;
import botaunomy.block.tile.IElvenAvatarItemHadlerChangedListener;
import botaunomy.block.tile.TitleElvenAvatar_FakePlayerHelper;
import botaunomy.client.render.SecuencesAvatar;
import botaunomy.config.Config;
import botaunomy.network.MessageEnabled;
import botaunomy.network.MessageMana;
import botaunomy.network.MessageMoveArm;
import botaunomy.network.MessageSpectator;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;

public class TileElvenAvatar
extends TileSimpleInventory
implements IAvatarTile,
ITickable,
IElvenAvatarItemHadlerChangedListener,
IManaPool,
ISparkAttachable {
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    public SecuencesAvatar secuencesAvatar = new SecuencesAvatar();
    private float[][] anglePoints = new float[3][33];
    public static final int POINTS_SEQUENCE_DURATION = 125;
    public static final int MAX_MANA = 100000;
    private static final int AVATAR_TICK = 20;
    private static final int TABLET_BURST = 5000;
    public static final double MANA_MIN_DIVISION = 32.0;
    public static final double MIN_MANA = 208.33333333333334;
    protected static final String TAG_ENABLED = "enabled";
    protected static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    protected static final String TAG_MANA = "mana";
    protected static final String TAG_WAND = "wamd";
    protected static final String TAG_UUID = "uuid";
    protected static final String TAG_SPECT = "spectator";
    protected boolean enabled = true;
    private int ticksElapsed;
    private int ticksElapsedDisabled = 0;
    private int manaAvatar;
    public static int nAvatarServer;
    public static int nAvatarClient;
    private TitleElvenAvatar_FakePlayerHelper fakePlayerHelper = new TitleElvenAvatar_FakePlayerHelper(this);
    private boolean wandManaToTablet = false;
    private UUID playerUUID = null;
    public boolean playerIsSpectator = false;
    private boolean haveSpark = false;

    public UUID getUUID() {
        return this.playerUUID;
    }

    public void setUUID(UUID uuid) {
        this.playerUUID = uuid;
    }

    public void setClientUUID(UUID uuid) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.playerUUID == null) {
            this.playerUUID = uuid;
            this.fakePlayerHelper.elvenFakePlayer.initClient(this.field_145850_b, this.field_174879_c, this);
        }
        this.playerUUID = uuid;
    }

    public void onBreak() {
        this.fakePlayerHelper.elvenFakePlayer.removePlayer(this.field_145850_b, this);
    }

    private TileEntityChest findChest() {
        TileEntity chest = null;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            chest = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (chest == null || !(chest instanceof TileEntityChest)) continue;
            return (TileEntityChest)chest;
        }
        return null;
    }

    private boolean insertInChest(ItemStack[] refItemStackIn, TileEntityChest chest) {
        int i;
        ItemStack itemStack = null;
        ItemStack itemStackIn = refItemStackIn[0];
        for (i = 0; i < chest.func_70302_i_(); ++i) {
            itemStack = chest.func_70301_a(i);
            if (itemStack == null || itemStack == ItemStack.field_190927_a) continue;
            int quantity = itemStack.func_190916_E();
            int maxQuantity = itemStack.func_77976_d();
            if (!itemStack.func_77973_b().equals(itemStackIn.func_77973_b()) || quantity >= chest.func_70297_j_() || quantity >= maxQuantity) continue;
            itemStack.func_190920_e(quantity + 1);
            if (itemStackIn.func_190916_E() - 1 <= 0) {
                refItemStackIn[0] = ItemStack.field_190927_a;
            } else {
                itemStackIn.func_190918_g(1);
                refItemStackIn[0] = itemStackIn;
            }
            chest.func_70299_a(i, itemStack);
            return true;
        }
        for (i = 0; i < chest.func_70302_i_(); ++i) {
            itemStack = chest.func_70301_a(i);
            if (itemStack != null && itemStack != ItemStack.field_190927_a) continue;
            itemStack = itemStackIn.func_77946_l();
            itemStack.func_190920_e(1);
            chest.func_70299_a(i, itemStack);
            if (itemStackIn.func_190916_E() - 1 <= 0) {
                refItemStackIn[0] = ItemStack.field_190927_a;
            } else {
                itemStackIn.func_190918_g(1);
                refItemStackIn[0] = itemStackIn;
            }
            return true;
        }
        return false;
    }

    private void dropOrInsert(ElvenAvatarItemHadler inventory) {
        boolean insertado = false;
        TileEntityChest chest = this.findChest();
        ItemStack itemStack = inventory.get0();
        ItemStack[] refItemStack = new ItemStack[]{itemStack};
        if (chest != null) {
            insertado = this.insertInChest(refItemStack, chest);
        }
        if (insertado) {
            inventory.set0(refItemStack[0]);
        } else {
            this.fakePlayerHelper.dropItem(inventory.take0());
        }
    }

    @Override
    public void onItemStackHandlerChanged(ElvenAvatarItemHadler inventory, int slot) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (slot == 0) {
            if (!ItemStackType.isStackType(this.getInventory().cacheType0, ItemStackType.Types.EYE)) {
                this.inventoryToFakePlayer();
            }
            if (inventory.haveItem()) {
                boolean isValid;
                if (!this.secuencesAvatar.isActive()) {
                    new MessageMoveArm(this.func_174877_v(), 2);
                }
                if (!(isValid = inventory.isItemValid0())) {
                    this.dropOrInsert(inventory);
                }
            } else if (!this.resetBreak()) {
                new MessageMoveArm(this.func_174877_v(), 3);
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.func_70296_d();
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    public boolean isAvatarTick() {
        return this.ticksElapsed % 20 == 1;
    }

    private boolean isHalfAvatarTick() {
        return this.ticksElapsed % 20 == 10;
    }

    public boolean haveItem() {
        return this.getInventory().haveItem();
    }

    public void inventoryToFakePlayer() {
        this.fakePlayerHelper.inventoryToFakePlayer();
    }

    public boolean resetBreak() {
        return this.fakePlayerHelper.resetBreak();
    }

    public void updateRotatePoints(ModelRenderer[][] points, float[] RNDs, float elapsed) {
        for (int b = 0; b < 3; ++b) {
            for (int a = 0; a < 33; ++a) {
                int points_duration = 1000 - 875 * (this.manaAvatar / 100000);
                float[] fArray = this.anglePoints[b];
                int n = a;
                fArray[n] = fArray[n] + -6.2832f / (float)points_duration * elapsed * RNDs[a];
                if (this.anglePoints[b][a] > -6.2832f) {
                    float[] fArray2 = this.anglePoints[b];
                    int n2 = a;
                    fArray2[n2] = fArray2[n2] - -6.2832f;
                }
                points[b][a].field_78808_h = points[b][a].field_78796_g = this.anglePoints[b][a] + -2.0944f * (float)b;
                points[b][a].field_78795_f = points[b][a].field_78796_g;
            }
        }
    }

    public void setPlayerSpectator(boolean isSpectator) {
        this.playerIsSpectator = isSpectator;
        if (this.fakePlayerHelper.elvenFakePlayer.isSpectator() != isSpectator) {
            this.fakePlayerHelper.elvenFakePlayer.setSpectator(isSpectator);
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                new MessageSpectator(this.field_174879_c, isSpectator);
            }
        }
    }

    public void func_73660_a() {
        ArrayList<ItemStackType.Types> type0 = this.getInventory().getType0();
        ArrayList<ItemStackType.Types> type1 = this.getInventory().getType1();
        if (ItemStackType.isStackType(type0, ItemStackType.Types.ROD_AVATAR)) {
            ((IAvatarWieldable)this.getInventory().get0().func_77973_b()).onAvatarUpdate((IAvatarTile)this, this.getInventory().get0());
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.isAvatarTick()) {
            boolean haveToBeSpectator;
            int manaCost = 20 * Config.mobSpawnerCostPertick;
            boolean haveMana = this.manaAvatar >= manaCost;
            boolean haveEye = ItemStackType.isStackType(this.getInventory().cacheType0, ItemStackType.Types.EYE);
            boolean bl = haveToBeSpectator = !haveEye || !haveMana || !this.enabled;
            if (!haveToBeSpectator) {
                this.manaAvatar -= manaCost;
                this.func_70296_d();
                new MessageMana(this.func_174877_v(), this.manaAvatar);
            }
            this.setPlayerSpectator(haveToBeSpectator);
        }
        boolean enabledBeforeRedstone = this.enabled;
        this.enabled = true;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide < 14) continue;
            this.enabled = false;
            break;
        }
        if (enabledBeforeRedstone != this.enabled) {
            new MessageEnabled(this.func_174877_v(), this.enabled);
            if (this.enabled) {
                this.ticksElapsed = 0;
            }
            if (this.secuencesAvatar.isActive()) {
                if (this.getInventory().haveItem()) {
                    new MessageMoveArm(this.func_174877_v(), 2);
                } else {
                    new MessageMoveArm(this.func_174877_v(), 3);
                    this.resetBreak();
                }
            }
        }
        if (this.isAvatarTick() || enabledBeforeRedstone != this.enabled) {
            if (this.getInventory().haveItem()) {
                if (ItemStackType.isStackType(type0, ItemStackType.Types.ROD_WILL)) {
                    this.fakePlayerHelper.rodRightClick(this);
                } else if (!this.chargeMana(type0)) {
                    if (ItemStackType.isStackType(type0, ItemStackType.Types.BREAK)) {
                        if (ItemStackType.isStackType(type1, ItemStackType.Types.ROD_WORK)) {
                            this.fakePlayerHelper.rightClickBlockWhithItem();
                        } else {
                            this.fakePlayerHelper.beginBreak();
                        }
                    }
                    if (ItemStackType.isStackType(type0, ItemStackType.Types.USE) || ItemStackType.isStackType(type0, ItemStackType.Types.SHEAR) || ItemStackType.isStackType(type0, ItemStackType.Types.KILL)) {
                        this.fakePlayerHelper.beginUse();
                    }
                    if (ItemStackType.isStackType(type0, ItemStackType.Types.JUSTRC)) {
                        this.fakePlayerHelper.justRightClick(this);
                    }
                }
            }
        } else if (this.ticksElapsedDisabled > 20) {
            this.ticksElapsedDisabled = 0;
            this.chargeMana(type0);
        } else {
            ++this.ticksElapsedDisabled;
        }
        if (this.enabled) {
            ++this.ticksElapsed;
        }
        this.fakePlayerHelper.updateHelper();
    }

    private boolean chargeMana(ArrayList<ItemStackType.Types> type0) {
        if (ItemStackType.isStackType(type0, ItemStackType.Types.MANA)) {
            ItemStack stackMana = this.getInventory().get0();
            Item itemmana = stackMana.func_77973_b();
            EntityItem entityItemMana = new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stackMana);
            if (itemmana instanceof IManaDissolvable) {
                ((IManaDissolvable)itemmana).onDissolveTick((IManaPool)this, stackMana, entityItemMana);
                stackMana = this.getInventory().get0();
                if (stackMana.func_190926_b()) {
                    this.getInventory().take0();
                }
            } else if (stackMana.func_77973_b() instanceof IManaItem) {
                if (this.wandManaToTablet) {
                    this.avatarToTablet(stackMana);
                } else {
                    this.tabletToAvatar(stackMana);
                }
            }
            return true;
        }
        return false;
    }

    private void tabletToAvatar(ItemStack stack) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        IManaItem tablet = (IManaItem)stack.func_77973_b();
        int manaActualTablet = tablet.getMana(stack);
        if (manaActualTablet <= 0) {
            return;
        }
        int burst = 5000;
        int espacioAvatar = 100000 - this.manaAvatar;
        if (espacioAvatar <= 0) {
            return;
        }
        if (manaActualTablet < burst) {
            burst = manaActualTablet;
        }
        if (burst > espacioAvatar) {
            burst = espacioAvatar;
        }
        tablet.addMana(stack, -burst);
        this.manaAvatar += burst;
        this.func_70296_d();
        new MessageMana(this.func_174877_v(), this.manaAvatar);
        this.fakePlayerHelper.emitRedstone();
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.spreaderFire, SoundCategory.BLOCKS, 0.11f, 1.0f);
    }

    private void avatarToTablet(ItemStack stack) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.manaAvatar <= 0) {
            return;
        }
        int burst = 5000;
        IManaItem tablet = (IManaItem)stack.func_77973_b();
        int manaActualTablet = tablet.getMana(stack);
        int manaMaxTablet = tablet.getMaxMana(stack);
        int espacioTablet = manaMaxTablet - manaActualTablet;
        if (espacioTablet <= 0) {
            return;
        }
        if (this.manaAvatar < burst) {
            burst = this.manaAvatar;
        }
        if (burst > espacioTablet) {
            burst = espacioTablet;
        }
        this.manaAvatar -= burst;
        tablet.addMana(stack, burst);
        this.func_70296_d();
        new MessageMana(this.func_174877_v(), this.manaAvatar);
        this.fakePlayerHelper.emitRedstone();
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.spreaderFire, SoundCategory.BLOCKS, 0.11f, 1.0f);
    }

    public EnumFacing getAvatarFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BotaniaStateProps.CARDINALS);
    }

    public BlockPos func_174877_v() {
        return super.func_174877_v();
    }

    public int func_145832_p() {
        return 0;
    }

    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    public ElvenAvatarItemHadler getInventory() {
        return (ElvenAvatarItemHadler)this.getItemHandler();
    }

    public int getSizeInventory() {
        return 2;
    }

    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new ElvenAvatarItemHadler(this, true);
    }

    public boolean isOutputtingPower() {
        return this.wandManaToTablet;
    }

    public EnumDyeColor getColor() {
        return null;
    }

    public void setColor(EnumDyeColor color) {
    }

    public int getCurrentMana() {
        return this.manaAvatar;
    }

    public boolean isFull() {
        return this.manaAvatar >= 100000;
    }

    public void recieveMana(int mana) {
        this.manaAvatar = Math.max(0, Math.min(100000, this.manaAvatar + mana));
        new MessageMana(this.func_174877_v(), this.manaAvatar);
        this.func_70296_d();
    }

    public boolean canRecieveManaFromBursts() {
        return this.getInventory().haveItem() && !ItemStackType.isStackType(this.getInventory().getType0(), ItemStackType.Types.MANA);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean penabled) {
        this.enabled = penabled;
    }

    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound.func_74775_l("inventory"));
        this.enabled = par1nbtTagCompound.func_74767_n(TAG_ENABLED);
        this.ticksElapsed = par1nbtTagCompound.func_74762_e(TAG_TICKS_ELAPSED);
        this.manaAvatar = par1nbtTagCompound.func_74762_e(TAG_MANA);
        this.wandManaToTablet = par1nbtTagCompound.func_74767_n(TAG_WAND);
        this.playerIsSpectator = par1nbtTagCompound.func_74767_n(TAG_SPECT);
        try {
            this.playerUUID = UUID.fromString(par1nbtTagCompound.func_74779_i(TAG_UUID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.playerUUID != null) {
            this.fakePlayerHelper.elvenFakePlayer.initClient(this.field_145850_b, this.field_174879_c, this);
        } else {
            this.setPlayerSpectator(this.playerIsSpectator);
        }
        this.fakePlayerHelper.readPacketNBT(par1nbtTagCompound);
    }

    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        par1nbtTagCompound.func_74782_a("inventory", (NBTBase)this.getInventory().serializeNBT());
        par1nbtTagCompound.func_74757_a(TAG_ENABLED, this.enabled);
        par1nbtTagCompound.func_74768_a(TAG_TICKS_ELAPSED, this.ticksElapsed);
        par1nbtTagCompound.func_74768_a(TAG_MANA, this.manaAvatar);
        par1nbtTagCompound.func_74757_a(TAG_WAND, this.wandManaToTablet);
        par1nbtTagCompound.func_74757_a(TAG_SPECT, this.playerIsSpectator);
        if (this.playerUUID != null) {
            par1nbtTagCompound.func_74778_a(TAG_UUID, this.playerUUID.toString());
        }
        this.fakePlayerHelper.writePacketNBT(par1nbtTagCompound);
    }

    public void setmana(int pmana) {
        this.manaAvatar = pmana;
    }

    public boolean haveMana() {
        return (double)this.manaAvatar >= 208.33333333333334;
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.wandManaToTablet = !this.wandManaToTablet;
        this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ding, SoundCategory.PLAYERS, 0.11f, 1.0f);
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        Block avatarBlock = this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
        ItemStack avatarStack = new ItemStack(avatarBlock, 1, this.func_145832_p());
        String name = I18n.func_135052_a((String)"Elven Avatar", (Object[])new Object[0]);
        int color = 0x4444FF;
        int manaInt = this.manaAvatar;
        if (manaInt > 100000) {
            manaInt = 100000;
        }
        HUDHandler.drawSimpleManaHUD((int)color, (int)manaInt, (int)100000, (String)name, (ScaledResolution)res);
        int x = res.func_78326_a() / 2 - 11;
        int y = res.func_78328_b() / 2 + 30;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
        int u = this.wandManaToTablet ? 22 : 0;
        RenderHelper.drawTexturedModalRect((int)x, (int)y, (float)0.0f, (int)u, (int)38, (int)22, (int)15);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tablet = new ItemStack(ModItems.manaTablet);
        ItemManaTablet.setStackCreative((ItemStack)tablet);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        mc.func_175599_af().func_180450_b(tablet, x - 20, y);
        mc.func_175599_af().func_180450_b(avatarStack, x + 26, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public void attachSpark(ISparkEntity entity) {
        this.haveSpark = true;
    }

    public int getAvailableSpaceForMana() {
        return 100000 - this.manaAvatar;
    }

    public ISparkEntity getAttachedSpark() {
        EntitySpark spark;
        AxisAlignedBB bounding = new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1));
        List sparks = this.field_145850_b.func_175647_a(Entity.class, bounding, Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1 && (spark = (EntitySpark)sparks.get(0)) != null && spark.func_70089_S()) {
            return spark;
        }
        if (this.haveSpark) {
            this.func_70296_d();
            this.haveSpark = false;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.isFull();
    }

    public boolean func_145842_c(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        Botania.proxy.sparkleFX((double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
                    }
                }
                return true;
            }
            case 1: {
                if (this.field_145850_b.field_72995_K && ConfigHandler.chargingAnimationEnabled) {
                    boolean outputting = param == 1;
                    Vector3 itemVec = Vector3.fromBlockPos((BlockPos)this.field_174879_c).add(0.5, 0.5 + Math.random() * 0.3, 0.5);
                    Vector3 tileVec = Vector3.fromBlockPos((BlockPos)this.field_174879_c).add(0.2 + Math.random() * 0.6, 0.0, 0.2 + Math.random() * 0.6);
                    Botania.proxy.lightningFX(outputting ? tileVec : itemVec, outputting ? itemVec : tileVec, 80.0f, this.field_145850_b.field_73012_v.nextLong(), 1140881820, 1140901631);
                }
                return true;
            }
        }
        return super.func_145842_c(event, param);
    }

    public class ElvenAvatarItemHadler
    extends TileSimpleInventory.SimpleItemStackHandler {
        private ArrayList<ItemStackType.Types> cacheType0;
        private ArrayList<ItemStackType.Types> cacheType1;
        private ItemStack[] lastTryToInsert;
        private List<IElvenAvatarItemHadlerChangedListener> listIInventoryChangedListener;

        public <T extends TileSimpleInventory> ElvenAvatarItemHadler(T inv, boolean allowWrite) {
            super(inv, allowWrite);
            this.lastTryToInsert = new ItemStack[2];
            this.listIInventoryChangedListener = new ArrayList<IElvenAvatarItemHadlerChangedListener>();
            if (super.getStackInSlot(0) == null) {
                super.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (super.getStackInSlot(1) == null) {
                super.setStackInSlot(1, ItemStack.field_190927_a);
            }
            this.reloadCache();
            this.addIInventoryChangedListener((IElvenAvatarItemHadlerChangedListener)inv);
        }

        private void reloadCache() {
            this.cacheType0 = ItemStackType.getTypeTool(super.getStackInSlot(0));
            this.cacheType1 = ItemStackType.getTypeTool(super.getStackInSlot(1));
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            this.reloadCache();
        }

        public void addIInventoryChangedListener(IElvenAvatarItemHadlerChangedListener listener) {
            if (listener != null) {
                this.listIInventoryChangedListener.add(listener);
            }
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileElvenAvatar.this.func_70296_d();
            if (slot == 1) {
                this.cacheType1 = ItemStackType.getTypeTool(super.getStackInSlot(1));
            }
            if (slot == 0) {
                this.cacheType0 = ItemStackType.getTypeTool(super.getStackInSlot(0));
                this.lastTryToInsert[slot] = null;
            }
            for (int i = 0; i < this.listIInventoryChangedListener.size(); ++i) {
                this.listIInventoryChangedListener.get(i).onItemStackHandlerChanged(this, slot);
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!TileElvenAvatar.this.isHalfAvatarTick()) {
                return stack;
            }
            if (slot == 0 && this.get0() != ItemStack.field_190927_a) {
                return stack;
            }
            if (slot == 1 && this.get1() != ItemStack.field_190927_a) {
                return stack;
            }
            boolean valid = this.isItemValid(slot, stack);
            if (valid) {
                this.lastTryToInsert[slot] = null;
                return super.insertItem(slot, stack, simulate);
            }
            this.lastTryToInsert[slot] = stack.func_77946_l();
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            boolean allow = false;
            if (slot == 1) {
                allow = true;
            }
            if (slot == 0 && ItemStackType.isStackType(this.getType0(), ItemStackType.Types.MANA)) {
                ItemStack stack = TileElvenAvatar.this.getInventory().get0();
                Item itemmana = stack.func_77973_b();
                if (itemmana instanceof IManaDissolvable) {
                    allow = false;
                } else {
                    IManaItem tablet = (IManaItem)stack.func_77973_b();
                    int manaActualTablet = tablet.getMana(stack);
                    if (TileElvenAvatar.this.wandManaToTablet && manaActualTablet >= tablet.getMaxMana(stack)) {
                        allow = true;
                    }
                    if (!TileElvenAvatar.this.wandManaToTablet && manaActualTablet == 0) {
                        allow = true;
                    }
                }
            } else {
                allow = true;
            }
            if (allow) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack getStackInSlot(int slot) {
            return super.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            super.setStackInSlot(slot, stack);
        }

        public boolean isItemValid0() {
            return this.isItemValid(0, this.getStackInSlot(0));
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.lastTryToInsert[slot] != null && stack.func_77969_a(this.lastTryToInsert[slot])) {
                return false;
            }
            boolean valid_super = super.isItemValid(slot, stack);
            boolean valid = true;
            if (valid_super) {
                ArrayList<ItemStackType.Types> type = ItemStackType.getTypeTool(stack);
                if (slot == 1) {
                    valid = ItemStackType.isStackType(type, ItemStackType.Types.ROD_WORK) && ItemStackType.isStackType(this.cacheType0, ItemStackType.Types.BREAK);
                } else {
                    Item itemmana;
                    if (type.get(0) == ItemStackType.Types.NONE) {
                        valid = false;
                    }
                    if (valid && ItemStackType.isStackType(type, ItemStackType.Types.BLOCK)) {
                        valid = false;
                    }
                    if (valid && ItemStackType.isStackType(type, ItemStackType.Types.ROD_WORK)) {
                        valid = false;
                    }
                    if (ItemStackType.isStackType(type, ItemStackType.Types.MANA) && (itemmana = stack.func_77973_b()) instanceof IManaDissolvable && !TileElvenAvatar.this.wandManaToTablet && TileElvenAvatar.this.isFull()) {
                        valid = false;
                    }
                }
            }
            return valid;
        }

        public void set0(ItemStack stack) {
            super.setStackInSlot(0, stack);
        }

        public void set1(ItemStack stack) {
            super.setStackInSlot(1, stack);
        }

        public void empty0() {
            this.setStackInSlot(0, ItemStack.field_190927_a);
        }

        public void empty1() {
            this.setStackInSlot(1, ItemStack.field_190927_a);
        }

        public ItemStack get0() {
            return this.getStackInSlot(0);
        }

        public ItemStack get1() {
            return this.getStackInSlot(1);
        }

        public ItemStack take0() {
            ItemStack t = this.getStackInSlot(0);
            this.setStackInSlot(0, ItemStack.field_190927_a);
            return t;
        }

        public ItemStack take1() {
            ItemStack t = this.getStackInSlot(1);
            this.setStackInSlot(1, ItemStack.field_190927_a);
            return t;
        }

        public ArrayList<ItemStackType.Types> getType0() {
            return this.cacheType0;
        }

        public ArrayList<ItemStackType.Types> getType1() {
            return this.cacheType1;
        }

        public boolean haveItem() {
            ItemStack stack = this.getStackInSlot(0);
            return stack != null && stack != ItemStack.field_190927_a;
        }
    }
}

