/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.block.tile;

import botaunomy.ItemStackType;
import botaunomy.block.ElvenAvatarBlock;
import botaunomy.block.tile.ElvenFakePlayerHandler;
import botaunomy.block.tile.TileElvenAvatar;
import botaunomy.config.Config;
import botaunomy.network.MessageInventoryEmpty;
import botaunomy.network.MessageMana;
import botaunomy.network.MessageMoveArm;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class TitleElvenAvatar_FakePlayerHelper {
    TileElvenAvatar avatar;
    protected ElvenFakePlayerHandler elvenFakePlayer;
    private static final int MANA_PER_TOOLDAMAGE = 30;
    private BreakingData breakingData = new BreakingData();
    private boolean isRodRighClick = false;
    private boolean blockRighClick = false;
    private boolean toolUse = false;
    private List<Entity> entitiesList = null;
    int entitieIndex = 0;
    private EmitResdstoneTimer emitResdstoneTimer = new EmitResdstoneTimer();

    public TitleElvenAvatar_FakePlayerHelper(TileElvenAvatar pavatar) {
        this.avatar = pavatar;
        this.elvenFakePlayer = new ElvenFakePlayerHandler(this.avatar.func_145831_w(), this.avatar.func_174877_v(), pavatar);
    }

    private WeakReference<FakePlayer> getRefAndRetryInit() {
        return this.elvenFakePlayer.getRefAndRetryInit(this.getWorld(), this.getPos(), this.avatar);
    }

    public void emitRedstone() {
        if (this.emitResdstoneTimer != null) {
            this.emitResdstoneTimer.emitRedstone();
        }
    }

    private void checkManaIsEmpty() {
        if (this.avatar.getCurrentMana() >= 0) {
            return;
        }
        if (this.avatar.getInventory().haveItem()) {
            new MessageMoveArm(this.getPos(), 2);
        } else {
            new MessageMoveArm(this.getPos(), 3);
        }
        if (this.breakingData.isBreaking()) {
            this.breakingData.stopBreak();
        }
    }

    public void inventoryToFakePlayer() {
        this.elvenFakePlayer.inventoryToFakePlayer(this.avatar);
    }

    public void fakePlayerToInventory() {
        this.elvenFakePlayer.fakePlayerToInventory(this.avatar);
    }

    public boolean isBusy() {
        boolean isBusy = this.breakingData.isBreaking() || this.isRodRighClick || this.blockRighClick || this.toolUse;
        return isBusy;
    }

    public boolean resetBreak() {
        if (this.breakingData.isBreaking()) {
            if (this.avatar.getInventory().haveItem()) {
                new MessageMoveArm(this.getPos(), 2);
            } else {
                new MessageMoveArm(this.getPos(), 3);
            }
            this.breakingData.stopBreak();
            return true;
        }
        return false;
    }

    private World getWorld() {
        return this.avatar.func_145831_w();
    }

    private BlockPos getPos() {
        return this.avatar.func_174877_v();
    }

    public void updateHelper() {
        WeakReference<FakePlayer> player = this.getRefAndRetryInit();
        if (player != null) {
            ((FakePlayer)player.get()).func_70071_h_();
        }
        if (player != null && this.breakingData.isBreaking()) {
            this.continueBreaking();
        } else {
            this.resetBreak();
        }
        this.emitResdstoneTimer.checkStopEmitRedstone();
    }

    public void sneak(boolean isSneaking) {
        FakePlayer player = (FakePlayer)this.getRefAndRetryInit().get();
        if (player.func_70093_af() != isSneaking) {
            player.func_70095_a(isSneaking);
        }
    }

    public void beginBreak() {
        if (!(this.getWorld() instanceof WorldServer)) {
            return;
        }
        if (!this.avatar.isEnabled()) {
            return;
        }
        if (this.isBusy()) {
            return;
        }
        WeakReference<FakePlayer> player = this.getRefAndRetryInit();
        if (player == null) {
            return;
        }
        if (this.elvenFakePlayer.stackMainHandType().get(0) == ItemStackType.Types.BLOCK) {
            return;
        }
        if (this.avatar.getCurrentMana() < Config.breakManaCost) {
            return;
        }
        if (this.breakingData.isBreaking()) {
            return;
        }
        if (this.getWorld().func_175623_d(this.getTargetPos())) {
            return;
        }
        this.breakingData.BeginBreak(this.getTargetPos());
        this.breakingData.sendBlockBreakProgress((EntityPlayer)player.get());
        this.avatar.recieveMana(-Config.breakManaCost);
        this.checkManaIsEmpty();
        this.emitResdstoneTimer.emitRedstone();
        new MessageMana(this.getPos(), this.avatar.getCurrentMana());
        new MessageMoveArm(this.getPos(), 1);
    }

    private void continueBreaking() {
        if (this.elvenFakePlayer.stackMainHand().func_190926_b()) {
            this.resetBreak();
            return;
        }
        FakePlayer player = (FakePlayer)this.getRefAndRetryInit().get();
        this.breakingData.addBlockDamage((EntityPlayer)player);
        if (this.breakingData.blockIsFullDamage()) {
            this.breakingData.sendBlockBreakProgress100((EntityPlayer)player);
            this.onPlayerDestroyBlock();
            this.breakingData.stopBreak();
        } else {
            this.breakingData.sendBlockBreakProgress((EntityPlayer)player);
        }
    }

    private void onPlayerDestroyBlock() {
        boolean flag;
        FakePlayer player = (FakePlayer)this.getRefAndRetryInit().get();
        ItemStack stackMainHand = this.elvenFakePlayer.stackMainHand();
        Item itemStackMainHand = stackMainHand.func_77973_b();
        if (!(this.getWorld() instanceof WorldServer)) {
            return;
        }
        if (player == null || !this.breakingData.isBreaking()) {
            return;
        }
        if (this.breakingData.blockIsAir()) {
            return;
        }
        if (stackMainHand.func_190926_b()) {
            return;
        }
        boolean notCanBeHarvested = stackMainHand.func_77973_b().onBlockStartBreak(stackMainHand, this.breakingData.getPosBlockToBreak(), (EntityPlayer)player);
        this.getWorld().func_175718_b(2001, this.breakingData.getPosBlockToBreak(), Block.func_176210_f((IBlockState)this.breakingData.getStateBlockToBreak()));
        if (!notCanBeHarvested && this.breakingData.getBlockToBreak().canHarvestBlock((IBlockAccess)this.getWorld(), this.breakingData.getPosBlockToBreak(), (EntityPlayer)player)) {
            this.breakingData.getBlockToBreak().func_180657_a(this.getWorld(), (EntityPlayer)player, this.breakingData.getPosBlockToBreak(), this.breakingData.getStateBlockToBreak(), null, stackMainHand);
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stackMainHand);
            this.breakingData.getBlockToBreak().func_180637_b(this.getWorld(), this.breakingData.getPosBlockToBreak(), this.breakingData.getBlockToBreak().getExpDrop(this.breakingData.getStateBlockToBreak(), (IBlockAccess)this.getWorld(), this.breakingData.getPosBlockToBreak(), fortune));
            if (itemStackMainHand instanceof IManaUsingItem && ((IManaUsingItem)itemStackMainHand).usesMana(stackMainHand)) {
                ToolCommons.damageItem((ItemStack)stackMainHand, (int)1, (EntityLivingBase)player, (int)30);
            } else {
                stackMainHand.func_179548_a(this.getWorld(), this.breakingData.getStateBlockToBreak(), this.breakingData.getPosBlockToBreak(), (EntityPlayer)player);
            }
        }
        if (flag = this.breakingData.getBlockToBreak().removedByPlayer(this.breakingData.getStateBlockToBreak(), this.getWorld(), this.breakingData.getPosBlockToBreak(), (EntityPlayer)player, false)) {
            this.breakingData.getBlockToBreak().func_176206_d(this.getWorld(), this.breakingData.getPosBlockToBreak(), this.breakingData.getStateBlockToBreak());
        }
        if (stackMainHand.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stackMainHand, (EnumHand)EnumHand.MAIN_HAND);
            this.avatar.getInventory().empty0();
            if (this.getWorld() instanceof WorldServer) {
                new MessageInventoryEmpty(this.getPos());
                new MessageMoveArm(this.getPos(), 3);
            }
        } else {
            this.avatar.getInventory().set0(stackMainHand.func_77946_l());
            new MessageMoveArm(this.getPos(), 2);
        }
    }

    private BlockPos getTargetPos() {
        try {
            BlockPos targetPos = this.getPos().func_177972_a(this.avatar.getAvatarFacing());
            return targetPos;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void rightClickBlockWhithItem() {
        if (!this.avatar.isEnabled()) {
            return;
        }
        if (this.isBusy()) {
            return;
        }
        WeakReference<FakePlayer> avatarPlayer = this.getRefAndRetryInit();
        if (avatarPlayer == null) {
            return;
        }
        if (this.avatar.getCurrentMana() >= Config.rodManaCost) {
            boolean interactedWithBlock = false;
            BlockPos targetPos = this.getTargetPos();
            if (targetPos != null) {
                this.blockRighClick = true;
                interactedWithBlock = this.interactBlockWithItem(this.avatar, avatarPlayer, targetPos);
                if (interactedWithBlock) {
                    this.avatar.recieveMana(-Config.rodManaCost);
                    this.checkManaIsEmpty();
                    this.emitResdstoneTimer.emitRedstone();
                    if (this.avatar.func_145831_w() instanceof WorldServer) {
                        this.fakePlayerToInventory();
                        if (!this.elvenFakePlayer.stackMainHand().func_190926_b()) {
                            new MessageMoveArm(this.getPos(), 2);
                        } else {
                            new MessageMoveArm(this.getPos(), 3);
                            this.inventoryToFakePlayer();
                        }
                        new MessageMana(this.getPos(), this.avatar.getCurrentMana());
                        this.avatar.func_145831_w().func_175646_b(targetPos, (TileEntity)this.avatar);
                    }
                }
                this.blockRighClick = false;
            }
        }
    }

    public void beginUse() {
        if (!this.avatar.isEnabled()) {
            return;
        }
        if (this.elvenFakePlayer.stackMainHand().func_190926_b()) {
            return;
        }
        if (this.avatar.getCurrentMana() < Config.useManaCost) {
            return;
        }
        if (!this.toolUse) {
            this.entitiesList = this.detectEntity(this.getPos());
        }
        if (this.entitiesList == null || this.entitiesList.size() == 0) {
            return;
        }
        Entity currentEntity = null;
        boolean interactedWithEntities = false;
        try {
            currentEntity = this.entitiesList.get(this.entitieIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentEntity != null) {
            interactedWithEntities = this.useTool(currentEntity);
        }
        this.toolUse |= interactedWithEntities;
        if (interactedWithEntities) {
            this.avatar.recieveMana(-Config.useManaCost);
            this.checkManaIsEmpty();
            this.emitResdstoneTimer.emitRedstone();
            if (this.getWorld() instanceof WorldServer) {
                new MessageMana(this.getPos(), this.avatar.getCurrentMana());
                new MessageMoveArm(this.getPos(), 1);
            }
        }
        ++this.entitieIndex;
        if (this.entitieIndex >= this.entitiesList.size()) {
            new MessageMoveArm(this.getPos(), 2);
            this.entitieIndex = 0;
            this.entitiesList.clear();
            this.toolUse = false;
        }
        if (this.elvenFakePlayer.stackMainHand().func_190926_b()) {
            this.toolUse = false;
            this.avatar.getInventory().empty0();
            if (this.getWorld() instanceof WorldServer) {
                new MessageInventoryEmpty(this.getPos());
                new MessageMoveArm(this.getPos(), 3);
            }
        }
    }

    public boolean useTool(Entity entity) {
        BlockPos pos;
        boolean entityShareable;
        WeakReference<FakePlayer> avatarPlayer = this.getRefAndRetryInit();
        if (avatarPlayer == null) {
            return false;
        }
        if (avatarPlayer.get() == null) {
            return false;
        }
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        boolean result = false;
        ItemStack tool = this.elvenFakePlayer.stackMainHand();
        if (ItemStackType.isStackType(this.elvenFakePlayer.stackMainHandType(), ItemStackType.Types.SHEAR) && entity instanceof IShearable && !(entityShareable = ((IShearable)entity).isShearable(tool, (IBlockAccess)entity.field_70170_p, pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)))) {
            return false;
        }
        if (ItemStackType.isStackType(this.elvenFakePlayer.stackMainHandType(), ItemStackType.Types.SHEAR) || ItemStackType.isStackType(this.elvenFakePlayer.stackMainHandType(), ItemStackType.Types.USE)) {
            String previosName = this.elvenFakePlayer.stackMainHand().func_77977_a();
            EnumActionResult interaction = ((FakePlayer)avatarPlayer.get()).func_190775_a(entity, EnumHand.MAIN_HAND);
            boolean bl = result = interaction == EnumActionResult.SUCCESS;
            if (result) {
                this.avatar.func_145831_w().func_175646_b(entity.func_180425_c(), (TileEntity)this.avatar);
            }
            if (result && !previosName.equals(this.elvenFakePlayer.stackMainHand().func_77977_a())) {
                this.fakePlayerToInventory();
            }
            return result;
        }
        if (ItemStackType.isStackType(this.elvenFakePlayer.stackMainHandType(), ItemStackType.Types.KILL) && entity instanceof EntityLivingBase) {
            if (((FakePlayer)avatarPlayer.get()).func_184825_o(0.0f) == 1.0f) {
                ((FakePlayer)avatarPlayer.get()).func_71059_n(entity);
                return true;
            }
            return false;
        }
        return false;
    }

    private AxisAlignedBB boundingNorth(BlockPos avatarPos) {
        BlockPos e1 = avatarPos.func_177967_a(EnumFacing.NORTH, 2).func_177972_a(EnumFacing.WEST);
        BlockPos e2 = avatarPos.func_177967_a(EnumFacing.EAST, 2).func_177972_a(EnumFacing.UP);
        return new AxisAlignedBB(e1, e2);
    }

    private AxisAlignedBB boundingSouth(BlockPos avatarPos) {
        BlockPos e1 = avatarPos.func_177967_a(EnumFacing.SOUTH, 3).func_177972_a(EnumFacing.WEST);
        BlockPos e2 = avatarPos.func_177972_a(EnumFacing.SOUTH).func_177967_a(EnumFacing.EAST, 2).func_177972_a(EnumFacing.UP);
        return new AxisAlignedBB(e1, e2);
    }

    private AxisAlignedBB boundingEast(BlockPos avatarPos) {
        BlockPos e1 = avatarPos.func_177967_a(EnumFacing.NORTH, 1).func_177972_a(EnumFacing.EAST);
        BlockPos e2 = avatarPos.func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.EAST, 3).func_177972_a(EnumFacing.UP);
        return new AxisAlignedBB(e1, e2);
    }

    private AxisAlignedBB boundingWest(BlockPos avatarPos) {
        BlockPos e1 = avatarPos.func_177967_a(EnumFacing.NORTH, 1).func_177967_a(EnumFacing.WEST, 2);
        BlockPos e2 = avatarPos.func_177967_a(EnumFacing.SOUTH, 2).func_177972_a(EnumFacing.UP);
        return new AxisAlignedBB(e1, e2);
    }

    private List<Entity> detectEntity(BlockPos avatarPos) {
        AxisAlignedBB bounding = new AxisAlignedBB(avatarPos);
        switch (this.avatar.getAvatarFacing()) {
            case NORTH: {
                bounding = this.boundingNorth(avatarPos);
                break;
            }
            case EAST: {
                bounding = this.boundingEast(avatarPos);
                break;
            }
            case SOUTH: {
                bounding = this.boundingSouth(avatarPos);
                break;
            }
            case WEST: {
                bounding = this.boundingWest(avatarPos);
                break;
            }
            case DOWN: {
                break;
            }
        }
        List detectedEntities = this.getWorld().func_72872_a(EntityLivingBase.class, bounding);
        detectedEntities.removeIf(entity -> entity instanceof EntityPlayer);
        return detectedEntities;
    }

    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        this.breakingData.readPacketNBT(par1nbtTagCompound);
    }

    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        this.breakingData.writePacketNBT(par1nbtTagCompound);
    }

    public void rodRightClick(TileElvenAvatar avatar) {
        if (!avatar.isEnabled()) {
            return;
        }
        if (this.isBusy()) {
            return;
        }
        if (avatar.getCurrentMana() >= Config.rodManaCost) {
            boolean interactedWithBlock = false;
            WeakReference<FakePlayer> avatarPlayer = this.getRefAndRetryInit();
            if (avatarPlayer == null) {
                return;
            }
            BlockPos targetPos = this.getTargetPos();
            if (targetPos != null) {
                this.isRodRighClick = true;
                interactedWithBlock = this.interactBlock(avatar, avatarPlayer, targetPos);
                if (interactedWithBlock) {
                    avatar.recieveMana(-Config.rodManaCost);
                    this.checkManaIsEmpty();
                    this.emitResdstoneTimer.emitRedstone();
                    if (avatar.func_145831_w() instanceof WorldServer) {
                        new MessageMoveArm(this.getPos(), 2);
                        new MessageMana(this.getPos(), avatar.getCurrentMana());
                    }
                }
                this.isRodRighClick = false;
            }
        }
    }

    public void justRightClick(TileElvenAvatar avatar) {
        if (!avatar.isEnabled()) {
            return;
        }
        if (this.isBusy()) {
            return;
        }
        if (avatar.getCurrentMana() < Config.rodManaCost) {
            return;
        }
        boolean interactedWithBlock = false;
        WeakReference<FakePlayer> avatarPlayer = this.getRefAndRetryInit();
        if (avatarPlayer == null) {
            return;
        }
        ActionResult result = ((FakePlayer)avatarPlayer.get()).func_184614_ca().func_77973_b().func_77659_a(this.getWorld(), (EntityPlayer)avatarPlayer.get(), EnumHand.MAIN_HAND);
        boolean bl = interactedWithBlock = result.func_188397_a() == EnumActionResult.SUCCESS;
        if (interactedWithBlock) {
            avatar.recieveMana(-Config.rodManaCost);
            this.fakePlayerToInventory();
            this.checkManaIsEmpty();
            this.emitResdstoneTimer.emitRedstone();
            if (avatar.func_145831_w() instanceof WorldServer) {
                new MessageMoveArm(this.getPos(), 2);
                new MessageMana(this.getPos(), avatar.getCurrentMana());
            }
        }
    }

    private boolean interactBlock(TileElvenAvatar tileElvenAvatar, WeakReference<FakePlayer> fakePlayer, BlockPos targetPos) {
        boolean blockIsAir;
        if (this.elvenFakePlayer.stackMainHandType().get(0) == ItemStackType.Types.BLOCK) {
            return false;
        }
        IBlockState iblockstate = this.getWorld().func_180495_p(targetPos);
        boolean bl = blockIsAir = iblockstate.func_185904_a() == Material.field_151579_a;
        if (!blockIsAir) {
            World world = tileElvenAvatar.func_145831_w();
            EnumActionResult r = ((FakePlayer)fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)fakePlayer.get(), world, this.elvenFakePlayer.stackMainHand(), EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
            if (r == EnumActionResult.SUCCESS) {
                if (this.avatar.func_145831_w() instanceof WorldServer) {
                    new MessageMoveArm(this.getPos(), 1);
                }
                return true;
            }
        }
        return false;
    }

    private boolean interactBlockWithItem(TileElvenAvatar tileElvenAvatar, WeakReference<FakePlayer> fakePlayer, BlockPos targetPos) {
        boolean blockIsAir;
        if (this.elvenFakePlayer.stackMainHandType().get(0) == ItemStackType.Types.BLOCK) {
            return false;
        }
        IBlockState iblockstate = this.getWorld().func_180495_p(targetPos);
        boolean bl = blockIsAir = iblockstate.func_185904_a() == Material.field_151579_a;
        if (!blockIsAir) {
            World world = tileElvenAvatar.func_145831_w();
            EnumActionResult r = ((FakePlayer)fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)fakePlayer.get(), world, this.elvenFakePlayer.stackMainHand(), EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
            if (r == EnumActionResult.SUCCESS) {
                if (this.avatar.func_145831_w() instanceof WorldServer) {
                    new MessageMoveArm(this.getPos(), 1);
                }
                return true;
            }
        }
        return false;
    }

    public void dropItem(ItemStack stack) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        BlockPos targetPos = this.getPos().func_177972_a(this.avatar.getAvatarFacing());
        EntityItem entityItem = new EntityItem(this.getWorld(), (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5, stack);
        this.getWorld().func_72838_d((Entity)entityItem);
    }

    private class EmitResdstoneTimer {
        private int ticksElapsed;
        private static final int PULSE_TIME = 10;
        public boolean isEnabled = false;

        public void emitRedstone() {
            this.isEnabled = true;
            this.ticksElapsed = 0;
            this.setState(this.isEnabled);
        }

        public void checkStopEmitRedstone() {
            if (!this.isEnabled) {
                return;
            }
            ++this.ticksElapsed;
            if (this.ticksElapsed > 10) {
                this.isEnabled = false;
                this.ticksElapsed = 0;
                this.setState(this.isEnabled);
            }
        }

        private void setState(boolean value) {
            IBlockState state = TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_180495_p(TitleElvenAvatar_FakePlayerHelper.this.getPos());
            TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_175656_a(TitleElvenAvatar_FakePlayerHelper.this.getPos(), state.func_177226_a((IProperty)ElvenAvatarBlock.POWERED, (Comparable)Boolean.valueOf(value)));
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_175685_c(TitleElvenAvatar_FakePlayerHelper.this.getPos().func_177972_a(facing), state.func_177230_c(), true);
            }
        }
    }

    private class BreakingData {
        private boolean _isBreaking = false;
        private BlockPos posBlockToBreak;
        private float curBlockDamageMP;

        public boolean isBreaking() {
            return this._isBreaking;
        }

        public void BeginBreak(BlockPos blockPos) {
            this.posBlockToBreak = blockPos;
            this._isBreaking = true;
        }

        public void stopBreak() {
            this.posBlockToBreak = null;
            this._isBreaking = false;
            this.curBlockDamageMP = 0.0f;
        }

        public BlockPos getPosBlockToBreak() {
            if (this._isBreaking) {
                return this.posBlockToBreak;
            }
            return null;
        }

        public IBlockState getStateBlockToBreak() {
            return TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_180495_p(this.posBlockToBreak);
        }

        public Block getBlockToBreak() {
            return TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_180495_p(this.posBlockToBreak).func_177230_c();
        }

        public void addBlockDamage(float damage) {
            this.curBlockDamageMP += damage;
        }

        public void addBlockDamage(EntityPlayer player) {
            IBlockState iblockstate = TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_180495_p(this.posBlockToBreak);
            this.addBlockDamage(iblockstate.func_185903_a(player, TitleElvenAvatar_FakePlayerHelper.this.getWorld(), this.posBlockToBreak));
        }

        private int readBlockDamage() {
            return (int)((double)this.curBlockDamageMP * 10.0 - 1.0);
        }

        public boolean blockIsFullDamage() {
            return this.curBlockDamageMP >= 1.0f;
        }

        public boolean blockIsAir() {
            return TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_180495_p(this.posBlockToBreak).func_185904_a() == Material.field_151579_a;
        }

        public void sendBlockBreakProgress100(EntityPlayer player) {
            TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_175715_c(player.func_145782_y(), this.posBlockToBreak, -1);
        }

        public void sendBlockBreakProgress(EntityPlayer player) {
            TitleElvenAvatar_FakePlayerHelper.this.getWorld().func_175715_c(player.func_145782_y(), this.posBlockToBreak, this.readBlockDamage());
        }

        public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
            this._isBreaking = par1nbtTagCompound.func_74767_n("isBreaking");
            if (!this._isBreaking) {
                this.posBlockToBreak = null;
                this.curBlockDamageMP = 0.0f;
            } else {
                this.posBlockToBreak = new BlockPos(par1nbtTagCompound.func_74762_e("posBlockToBreakX"), par1nbtTagCompound.func_74762_e("posBlockToBreakY"), par1nbtTagCompound.func_74762_e("posBlockToBreakZ"));
            }
        }

        public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
            par1nbtTagCompound.func_74757_a("isBreaking", this._isBreaking);
            if (this.posBlockToBreak != null) {
                par1nbtTagCompound.func_74768_a("posBlockToBreakX", this.posBlockToBreak.func_177958_n());
                par1nbtTagCompound.func_74768_a("posBlockToBreakY", this.posBlockToBreak.func_177956_o());
                par1nbtTagCompound.func_74768_a("posBlockToBreakZ", this.posBlockToBreak.func_177952_p());
            }
        }
    }
}

