/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.client.render;

import botaunomy.ModBlocks;
import botaunomy.block.tile.TileElvenAvatar;
import botaunomy.item.RodItem;
import botaunomy.model.ModelAvatar;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class RenderTileElvenAvatar
extends TileEntitySpecialRenderer<TileElvenAvatar> {
    private static final float[] ROTATIONS = new float[]{180.0f, 0.0f, 90.0f, 270.0f};
    private static final ResourceLocation avatarTexture = new ResourceLocation("botaunomy:textures/model/elven_avatar3.png");
    private static final ResourceLocation overlayTexture = new ResourceLocation("botaunomy:textures/model/avatar_overlay.png");
    private static final double DESPL = 0.22;

    public void render(@Nullable TileElvenAvatar avatar, double d0, double d1, double d2, float pticks, int digProgress, float unused) {
        if (avatar != null) {
            avatar.secuencesAvatar.update(pticks);
        }
        if (!(avatar == null || avatar.func_145831_w().func_175668_a(avatar.func_174877_v(), false) && avatar.func_145831_w().func_180495_p(avatar.func_174877_v()).func_177230_c() == ModBlocks.elven_avatar)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double t0 = 0.0;
        double t2 = 0.0;
        if (avatar != null) {
            EnumFacing enumfacing = avatar.getAvatarFacing();
            if (enumfacing == EnumFacing.EAST) {
                t0 = -0.22;
            }
            if (enumfacing == EnumFacing.WEST) {
                t0 = 0.22;
            }
            if (enumfacing == EnumFacing.NORTH) {
                t2 = 0.22;
            }
            if (enumfacing == EnumFacing.SOUTH) {
                t2 = -0.22;
            }
        }
        GlStateManager.func_179137_b((double)(d0 + t0), (double)d1, (double)(d2 + t2));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(avatarTexture);
        EnumFacing facing = avatar != null && avatar.func_145831_w() != null ? (EnumFacing)avatar.func_145831_w().func_180495_p(avatar.func_174877_v()).func_177229_b((IProperty)BotaniaStateProps.CARDINALS) : EnumFacing.SOUTH;
        GlStateManager.func_179109_b((float)0.5f, (float)1.6f, (float)0.5f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.func_176745_a() - 2), 0)], (float)0.0f, (float)1.0f, (float)0.0f);
        ItemStack stack = null;
        ItemStack stack2 = null;
        if (avatar != null) {
            stack = avatar.getInventory().get0();
            if (avatar.getInventory().getSlots() >= 2) {
                stack2 = avatar.getInventory().get1();
            }
        }
        boolean risearm = stack != null && !stack.func_190926_b() && !avatar.secuencesAvatar.isActive();
        ModelAvatar.render(avatar, pticks, risearm, true);
        if (avatar == null) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179121_F();
            return;
        }
        if (stack != null && !stack.func_190926_b()) {
            this.renderTool(avatar, stack, 0.6f, true);
            if (avatar.haveMana()) {
                if (stack.func_77973_b() instanceof RodItem) {
                    RodItem willrod = (RodItem)stack.func_77973_b();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(willrod.getOverlayResource());
                } else if (stack.func_77973_b() instanceof IAvatarWieldable) {
                    IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(wieldable.getOverlayResource((IAvatarTile)avatar, stack));
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(overlayTexture);
                }
                this.renderOverlay(avatar, pticks, risearm);
            }
        }
        if (stack2 != null && !stack2.func_190926_b()) {
            this.renderTool(avatar, stack2, 0.6f, false);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
    }

    private void renderTool(TileElvenAvatar avatar, ItemStack stack, float s, boolean righthand) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (righthand) {
            if (!avatar.secuencesAvatar.isActive()) {
                float corr = (float)Math.sin(avatar.secuencesAvatar.getEndValue("RiseArm", "toolCorrection"));
                GlStateManager.func_179137_b((double)-0.5, (double)avatar.secuencesAvatar.getEndValue("RiseArm", "toolOffset"), (double)((double)-0.4f - (double)corr * 0.3));
                GlStateManager.func_179114_b((float)avatar.secuencesAvatar.getEndValue("RiseArm", "tool"), (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                float corr = 0.0f;
                if (avatar.secuencesAvatar.elementExists("toolCorrection")) {
                    corr = (float)Math.sin(avatar.secuencesAvatar.getValue("toolCorrection"));
                }
                if (avatar.secuencesAvatar.elementExists("toolOffset")) {
                    GlStateManager.func_179137_b((double)-0.5, (double)avatar.secuencesAvatar.getValue("toolOffset"), (double)((double)-0.4f - (double)corr * 0.3));
                }
                if (avatar.secuencesAvatar.elementExists("tool")) {
                    GlStateManager.func_179114_b((float)avatar.secuencesAvatar.getValue("tool"), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        } else {
            float corr = (float)Math.sin(avatar.secuencesAvatar.getInitValue("RiseArm", "toolCorrection"));
            GlStateManager.func_179137_b((double)0.5, (double)1.9, (double)((double)-0.4f - (double)corr * 0.3));
            GlStateManager.func_179114_b((float)0.2f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
    }

    private void renderOverlay(TileElvenAvatar avatar, float pticks, boolean risearm) {
        float s = 1.01f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.01f, (float)0.0f);
        int light = 0xF000F0;
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        float alpha = (float)Math.sin((double)ClientTickHandler.ticksInGame / 20.0) / 2.0f + 0.5f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha + 0.183f));
        ModelAvatar.render(avatar, pticks, risearm, false);
        GlStateManager.func_179121_F();
    }
}

