/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.client.render;

import java.util.HashMap;

public class Secuence {
    protected HashMap<Integer, Range> ranges = new HashMap();
    protected float duration;
    protected String name;
    protected float timeElapsed;
    protected boolean isFinished;
    protected float percent;

    public Secuence(String pname, float pduration) {
        this.name = pname;
        this.duration = pduration;
        this.reset();
    }

    public void reset() {
        this.timeElapsed = 0.0f;
        this.percent = 0.0f;
        this.isFinished = false;
    }

    public void update(float pticks) {
        if (this.percent < 1.0f) {
            this.timeElapsed += pticks;
            this.percent = this.timeElapsed / this.duration;
        } else {
            this.percent = 1.0f;
            this.isFinished = true;
        }
    }

    public boolean getisFinished() {
        return this.isFinished;
    }

    public String getName() {
        return this.name;
    }

    public void addRange(String elementeName, float pinit, float pend) {
        Range arc = new Range(elementeName, pinit, pend);
        this.ranges.put(elementeName.hashCode(), arc);
    }

    public boolean isElementInSequence(String elementName) {
        return this.ranges.containsKey(elementName.hashCode());
    }

    public float getValue(String rangeName) {
        Range range = this.ranges.get(rangeName.hashCode());
        return range.getValue(this.percent);
    }

    public boolean rangeExists(String rangeName) {
        return this.ranges.containsKey(rangeName.hashCode());
    }

    public float getEndValue(String rangeName) {
        Range range = this.ranges.get(rangeName.hashCode());
        return range.getEndValue();
    }

    public float getInitValue(String rangeName) {
        Range range = this.ranges.get(rangeName.hashCode());
        return range.getInitValue();
    }

    protected class Range {
        private String name;
        private float init;
        private float end;

        public Range(String pname, float pinit, float pend) {
            this.name = pname;
            this.init = pinit;
            this.end = pend;
        }

        public String getName() {
            return this.name;
        }

        public float getValue(float percent) {
            return this.init + (this.end - this.init) * percent;
        }

        public float getEndValue() {
            return this.end;
        }

        public float getInitValue() {
            return this.init;
        }

        public float getValueSwing(float percent) {
            if ((double)percent < 0.5) {
                return this.end - (this.end - this.init) * percent * 2.0f;
            }
            return this.init + (this.end - this.init) * (percent - 0.5f) * 2.0f;
        }
    }
}

