/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.model;

import botaunomy.block.tile.TileElvenAvatar;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelAvatar {
    public static final int NPOINTS = 33;
    public static final int NARC = 3;
    private static MyModelBase myModelBase = new MyModelBase();
    private static ModelRenderer body;
    private static ModelRenderer rightarm;
    private static ModelRenderer leftarm;
    private static ModelRenderer rightleg;
    private static ModelRenderer leftleg;
    private static ModelRenderer head;
    private static ModelRenderer botton;
    private static ModelRenderer[][] points;
    private static float[] rndForPoints;
    private static boolean loaded;

    private static boolean loadModelAvatar() {
        for (int a = 0; a < 33; ++a) {
            ModelAvatar.rndForPoints[a] = (float)Math.random();
        }
        ModelAvatar.myModelBase.field_78090_t = 32;
        ModelAvatar.myModelBase.field_78089_u = 32;
        body = new ModelRenderer((ModelBase)myModelBase);
        body.func_78793_a(0.0f, 16.0f, 0.0f);
        ModelAvatar.body.field_78804_l.add(new ModelBox(body, 0, 12, -3.0f, -2.0f, -2.0f, 6, 4, 4, 0.0f, false));
        rightarm = new ModelRenderer((ModelBase)myModelBase);
        rightarm.func_78793_a(-4.0f, 14.0f, 0.5f);
        ModelAvatar.rightarm.field_78804_l.add(new ModelBox(rightarm, 0, 20, -1.0f, 0.0f, -1.5f, 2, 6, 3, 0.0f, false));
        leftarm = new ModelRenderer((ModelBase)myModelBase);
        leftarm.func_78793_a(4.0f, 14.0f, 0.5f);
        ModelAvatar.leftarm.field_78804_l.add(new ModelBox(leftarm, 0, 20, -1.0f, 0.0f, -1.5f, 2, 6, 3, 0.0f, true));
        rightleg = new ModelRenderer((ModelBase)myModelBase);
        rightleg.func_78793_a(-1.5f, 19.0f, 0.5f);
        ModelAvatar.rightleg.field_78804_l.add(new ModelBox(rightleg, 0, 20, -1.5f, -1.0f, -1.5f, 3, 6, 3, 0.0f, false));
        leftleg = new ModelRenderer((ModelBase)myModelBase);
        leftleg.func_78793_a(1.5f, 19.0f, 0.5f);
        ModelAvatar.leftleg.field_78804_l.add(new ModelBox(leftleg, 0, 20, -1.5f, -1.0f, -1.5f, 3, 6, 3, 0.0f, true));
        head = new ModelRenderer((ModelBase)myModelBase);
        head.func_78793_a(0.0f, 14.0f, 0.0f);
        ModelAvatar.head.field_78804_l.add(new ModelBox(head, 0, 0, -3.0f, -6.0f, -3.0f, 6, 6, 6, 0.0f, false));
        botton = new ModelRenderer((ModelBase)myModelBase);
        botton.func_78793_a(0.0f, 19.5f, 2.5f);
        ModelAvatar.botton.field_78804_l.add(new ModelBox(botton, 4, 12, -2.0f, -1.5f, -0.5f, 4, 3, 1, 0.0f, false));
        float origenx = -14.0f;
        float origeny = -4.0f;
        for (int b = 0; b < 3; ++b) {
            for (int a = 0; a < 33; ++a) {
                ModelAvatar.points[b][a] = new ModelRenderer((ModelBase)myModelBase);
                double angle = 0.098175f * (float)a;
                double cos = Math.cos(angle) * 16.0;
                float desx = (float)(-((double)origenx + cos));
                double sin = Math.sin(angle) * 16.0;
                float desy = (float)sin;
                double color = 6.0 - Math.floor(rndForPoints[a] * 7.0f);
                int textureOffsetX = (int)color * 4;
                points[b][a].func_78793_a(0.0f, origeny + 24.0f, 0.0f);
                points[b][a].func_78784_a(textureOffsetX, 29);
                ModelAvatar.points[b][a].field_78804_l.add(new ModelBox(points[b][a], textureOffsetX, 29, origenx + desx - 1.0f, -desy - 1.0f, -1.0f, 1, 1, 1, 0.0f, false));
            }
        }
        return true;
    }

    public static void render(TileElvenAvatar avatar, float elapsed, boolean riseArm, boolean renderPoints) {
        float scale = 0.06666667f;
        ModelAvatar.rightarm.field_78795_f = 0.0f;
        if (avatar != null) {
            if (riseArm) {
                ModelAvatar.rightarm.field_78795_f = avatar.secuencesAvatar.getEndValue("RiseArm", "Arm");
            } else if (avatar.secuencesAvatar.isElemenActiveSecuence("Arm")) {
                ModelAvatar.rightarm.field_78795_f = avatar.secuencesAvatar.getValue("Arm");
            }
        }
        body.func_78785_a(scale);
        rightarm.func_78785_a(scale);
        leftarm.func_78785_a(scale);
        rightleg.func_78785_a(scale);
        leftleg.func_78785_a(scale);
        head.func_78785_a(scale);
        botton.func_78785_a(scale);
        if (avatar != null && avatar.isEnabled() && renderPoints) {
            avatar.updateRotatePoints(points, rndForPoints, elapsed);
            for (int b = 0; b < 3; ++b) {
                for (int a = 0; a < 33 && avatar.haveMana() && avatar.haveItem() && avatar.isEnabled(); ++a) {
                    if (!(Math.random() > 0.35)) continue;
                    ModelAvatar.renderParticles(5.0f, points[b][a], scale * 2.0f / 3.0f);
                }
            }
        }
    }

    private static void renderParticles(float partialTicks, ModelRenderer point, float scale) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)1);
        try {
            point.func_78785_a(scale);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    static {
        points = new ModelRenderer[3][33];
        rndForPoints = new float[33];
        loaded = ModelAvatar.loadModelAvatar();
    }

    private static class MyModelBase
    extends ModelBase {
    }
}

