/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.model;

import botaunomy.block.tile.TileElvenAvatar;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelAvatarTest {
    private static MyModelBase myModelBase = new MyModelBase();
    private static HashMap<String, ModelRenderer> modelRendererList = ModelAvatarTest.loadModelAvatarTest();

    private static JsonArray obtainJsonArray(JsonObject o, String path) {
        String[] nodes = path.split("\\.");
        JsonObject t = o;
        for (int i = 0; i < nodes.length - 1; ++i) {
            t = (JsonObject)t.get(nodes[i]);
        }
        return t.get(nodes[nodes.length - 1]).getAsJsonArray();
    }

    private static HashMap<String, ModelRenderer> loadModelAvatarTest() {
        modelRendererList = new HashMap();
        Gson gson = new Gson();
        JsonObject json = null;
        try {
            ResourceLocation model_json = new ResourceLocation("botaunomy:custom/modelavatar.json");
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(model_json).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            json = je.getAsJsonObject();
            ModelAvatarTest.myModelBase.field_78090_t = json.get("texture_size").getAsJsonArray().get(0).getAsInt();
            ModelAvatarTest.myModelBase.field_78089_u = json.get("texture_size").getAsJsonArray().get(1).getAsInt();
            for (JsonElement elemento : json.get("elements").getAsJsonArray()) {
                JsonObject $elementoJson = (JsonObject)elemento;
                String name = $elementoJson.get("name").getAsString();
                Point from = new Point($elementoJson.get("from").getAsJsonArray());
                Point to = new Point($elementoJson.get("to").getAsJsonArray());
                Point rotationTemp = new Point(ModelAvatarTest.obtainJsonArray($elementoJson, "rotation.origin"));
                Point rotation = new Point(-(rotationTemp.x - 8.0f), -(rotationTemp.y - 24.0f), rotationTemp.z - 8.0f);
                Point size = new Point(to.x - from.x, to.y - from.y, to.z - from.z);
                Point position = new Point(rotationTemp.x - from.x - size.x, rotationTemp.y - from.y - size.y, rotationTemp.z - from.z - size.z);
                boolean $textureMirrorx = false;
                int $txi = (int)Math.floor(ModelAvatarTest.obtainJsonArray($elementoJson, "faces.east.uv").get(0).getAsFloat() * 2.0f);
                int $txi2 = (int)Math.floor(ModelAvatarTest.obtainJsonArray($elementoJson, "faces.west.uv").get(2).getAsFloat() * 2.0f);
                int $tyi = (int)Math.floor(ModelAvatarTest.obtainJsonArray($elementoJson, "faces.down.uv").get(1).getAsFloat() * 2.0f);
                int $tyi2 = (int)Math.floor(ModelAvatarTest.obtainJsonArray($elementoJson, "faces.up.uv").get(3).getAsFloat() * 2.0f);
                if ($txi > $txi2) {
                    $txi = $txi2;
                    $textureMirrorx = true;
                }
                if ($tyi > $tyi2) {
                    $tyi = $tyi2;
                }
                ModelRenderer t = new ModelRenderer((ModelBase)myModelBase);
                modelRendererList.put(name, t);
                t.func_78793_a(rotation.x, rotation.y, rotation.z);
                t.field_78804_l.add(new ModelBox(t, $txi, $tyi, position.x, position.y, position.z, (int)size.x, (int)size.y, (int)size.z, 0.0f, $textureMirrorx));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return modelRendererList;
    }

    public static void render(TileElvenAvatar avatar, float elapsed, boolean riseArm) {
        float scale = 0.06666667f;
        ModelRenderer rightarm = modelRendererList.get("rightarm");
        rightarm.field_78795_f = 0.0f;
        if (avatar != null) {
            if (riseArm) {
                rightarm.field_78795_f = avatar.secuencesAvatar.getEndValue("RiseArm", "Arm");
            } else if (avatar.secuencesAvatar.isElemenActiveSecuence("Arm")) {
                rightarm.field_78795_f = avatar.secuencesAvatar.getValue("Arm");
            }
        }
        for (String key : modelRendererList.keySet()) {
            modelRendererList.get(key).func_78785_a(scale);
        }
    }

    private static class Point {
        public float x;
        public float y;
        public float z;

        public Point() {
        }

        public Point(float px, float py, float pz) {
            this();
            this.x = px;
            this.y = py;
            this.z = pz;
        }

        public Point(JsonArray array) {
            this.x = array.get(0).getAsFloat();
            this.y = array.get(1).getAsFloat();
            this.z = array.get(2).getAsFloat();
        }
    }

    private static class MyModelBase
    extends ModelBase {
    }
}

