/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.network;

import botaunomy.block.ElvenAvatarBlock;
import botaunomy.block.tile.TileElvenAvatar;
import botaunomy.network.ModSimpleNetworkChannel;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePlayer
implements IMessage {
    private UUID playerUuid;
    private BlockPos blockPos;

    public MessagePlayer() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.blockPos.func_177986_g());
        buf.writeInt(this.playerUuid.toString().length());
        buf.writeBytes(this.playerUuid.toString().getBytes());
    }

    public void fromBytes(ByteBuf buf) {
        this.blockPos = BlockPos.func_177969_a((long)buf.readLong());
        int snLen = buf.readInt();
        byte[] bytesPlayerUuid = new byte[snLen];
        buf.readBytes(bytesPlayerUuid);
        String stringUUID = new String(bytesPlayerUuid);
        this.playerUuid = UUID.fromString(stringUUID);
    }

    public MessagePlayer(BlockPos pblockpos, UUID pplayerUuid) {
        this.blockPos = pblockpos;
        this.playerUuid = pplayerUuid;
        ModSimpleNetworkChannel.INSTANCE.sendToAll((IMessage)this);
    }

    public static class MessagePlayerHandler
    implements IMessageHandler<MessagePlayer, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessagePlayer message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IBlockState ibs = world.func_180495_p(message.blockPos);
            Block block = ibs.func_177230_c();
            if (block instanceof ElvenAvatarBlock && world.func_175667_e(message.blockPos)) {
                TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(message.blockPos);
                avatar.setClientUUID(message.playerUuid);
            }
            return null;
        }
    }
}

