/*
 * Decompiled with CFR 0.152.
 */
package botaunomy.registry;

import botaunomy.registry.BlockBase;
import botaunomy.registry.ItemBase;
import botaunomy.registry.TileEntityRegisteredBlocked;
import botaunomy.registry.UtilResourceLocation;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class Registry {
    private ArrayList<BlockBase> blocks = new ArrayList();
    private ArrayList<BlockBase> blockItems = new ArrayList();
    private ArrayList<ItemBase> items = new ArrayList();

    public void addBlockForRegistry(BlockBase block, boolean addItem) {
        this.blocks.add(block);
        if (addItem) {
            this.blockItems.add(block);
        }
    }

    public void addItemForRegistry(ItemBase item) {
        this.items.add(item);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).setRegistryName(this.blocks.get((int)i).resourceLocation);
            this.blocks.get(i).func_149663_c(UtilResourceLocation.getUnlocalizedName(this.blocks.get((int)i).resourceLocation));
            registry.register((IForgeRegistryEntry)this.blocks.get(i));
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        int i;
        IForgeRegistry registry = event.getRegistry();
        for (i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setRegistryName(this.items.get((int)i).resourceLocation);
            this.items.get(i).func_77655_b(UtilResourceLocation.getUnlocalizedName(this.items.get((int)i).resourceLocation));
            registry.register((IForgeRegistryEntry)this.items.get(i));
        }
        for (i = 0; i < this.blockItems.size(); ++i) {
            ItemBlock itemBlock = new ItemBlock((Block)this.blockItems.get(i));
            ResourceLocation rl = new ResourceLocation(UtilResourceLocation.getItemBlockName(this.blockItems.get((int)i).resourceLocation));
            itemBlock.setRegistryName(rl);
            itemBlock.func_77655_b(UtilResourceLocation.getUnlocalizedName(rl));
            registry.register((IForgeRegistryEntry)itemBlock);
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            Block block = this.blocks.get(i);
            if (!block.func_149716_u() || !(block instanceof TileEntityRegisteredBlocked)) continue;
            GameRegistry.registerTileEntity(((TileEntityRegisteredBlocked)block).getTileEntityClass(), (String)block.getRegistryName().toString());
        }
    }

    public void registerModels(ModelRegistryEvent event) {
        int i;
        for (i = 0; i < this.blockItems.size(); ++i) {
            this.blocks.get(i).registerModels();
        }
        for (i = 0; i < this.items.size(); ++i) {
            this.items.get(i).registerModels();
        }
    }
}

