/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.jeroreintegration.integrations;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.distributions.DistributionUnderWater;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.JERAPI;
import me.axieum.mcmod.jeroreintegration.OreBlock;
import me.axieum.mcmod.jeroreintegration.config.Config;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.ArrayUtils;

public class Integrate {
    private static Map<String, Restriction> map = new HashMap<String, Restriction>();

    public static void init() {
        for (File file : Config.getFiles()) {
            Integrate.load(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(File file) {
        JsonParser parser = new JsonParser();
        try {
            JsonElement base = parser.parse((Reader)new FileReader(file));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) {
                return false;
            }
            JsonArray array = base.getAsJsonArray();
            block36: for (int i = 0; i < array.size(); ++i) {
                String[] blockParts;
                Block blockBlock;
                JsonObject obj = array.get(i).getAsJsonObject();
                JsonElement element = obj.get("mod");
                if (element != null && !Loader.isModLoaded((String)element.getAsString())) continue;
                String block = obj.get("block").getAsString();
                JsonObject distribObject = obj.get("distrib").getAsJsonObject();
                if (distribObject == null) continue;
                String distribType = distribObject.get("type").getAsString();
                String distrib = distribObject.get("value").getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();
                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";
                JsonArray biomesArray = obj.get("biomes").getAsJsonArray();
                Object[] biomes = new Biome[]{};
                for (JsonElement biomeElement : biomesArray) {
                    int biomeId = 0;
                    try {
                        biomeId = biomeElement.getAsInt();
                    }
                    catch (Exception e) {
                        break;
                    }
                    finally {
                        biomes = (Biome[])ArrayUtils.add((Object[])biomes, (Object)Biome.func_150568_d((int)biomeId));
                    }
                }
                if ((blockBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation((blockParts = block.split(":"))[0], blockParts[1]))) == null || Item.func_150898_a((Block)blockBlock) == null) continue;
                int oreMeta = blockParts.length == 3 ? Integer.parseInt(blockParts[2]) : 0;
                ItemStack blockStack = new ItemStack(blockBlock, 1, oreMeta);
                DistributionSquare distribution = new DistributionSquare(0, 0, 0, 255);
                block15 : switch (distribType.toLowerCase()) {
                    case "points": {
                        ArrayList<DistributionHelpers.OrePoint> points = new ArrayList<DistributionHelpers.OrePoint>();
                        for (String point : distrib.split(";")) {
                            String[] split = point.split(",");
                            if (split.length != 2) continue;
                            points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                        }
                        distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints((DistributionHelpers.OrePoint[])points.toArray(new DistributionHelpers.OrePoint[points.size()])));
                        break;
                    }
                    case "square": {
                        String[] squareVals = distrib.split(",");
                        switch (squareVals.length) {
                            case 3: {
                                try {
                                    distribution = new DistributionSquare(Integer.parseInt(squareVals[0]), Integer.parseInt(squareVals[1]), Float.parseFloat(squareVals[2]));
                                    break block15;
                                }
                                catch (NumberFormatException e) {
                                    break;
                                }
                            }
                            case 4: {
                                try {
                                    distribution = new DistributionSquare(Integer.parseInt(squareVals[0]), Integer.parseInt(squareVals[1]), Integer.parseInt(squareVals[2]), Integer.parseInt(squareVals[3]));
                                    break block15;
                                }
                                catch (NumberFormatException e) {
                                    break;
                                }
                            }
                            case 5: {
                                try {
                                    distribution = new DistributionSquare(Integer.parseInt(squareVals[0]), Integer.parseInt(squareVals[1]), Integer.parseInt(squareVals[2]), Integer.parseInt(squareVals[3]), Float.parseFloat(squareVals[4]));
                                    break block15;
                                }
                                catch (NumberFormatException e) {
                                    break;
                                }
                            }
                        }
                        continue block36;
                    }
                    case "triangular": {
                        String[] triangularVals = distrib.split(",");
                        if (triangularVals.length != 3) continue block36;
                        try {
                            distribution = new DistributionTriangular(Integer.parseInt(triangularVals[0]), Integer.parseInt(triangularVals[1]), Float.parseFloat(triangularVals[2]));
                            break;
                        }
                        catch (NumberFormatException e) {
                            continue block36;
                        }
                    }
                    case "underwater": {
                        String[] underwaterVals = distrib.split(",");
                        if (underwaterVals.length != 1) continue block36;
                        try {
                            distribution = new DistributionUnderWater(Float.parseFloat(underwaterVals[0]));
                            break;
                        }
                        catch (NumberFormatException e) {
                            continue block36;
                        }
                    }
                    default: {
                        continue block36;
                    }
                }
                JsonElement dropsListElement = obj.get("dropsList");
                LinkedList<LootDrop> dropList = new LinkedList<LootDrop>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonElement fortuneElement;
                        String itemStackString;
                        String[] stackStrings;
                        Item item;
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull() || (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((stackStrings = (itemStackString = itemStackElement.getAsString()).split(":", 4))[0], stackStrings[1]))) == null) continue;
                        ItemStack itemStack = new ItemStack(item);
                        if (stackStrings.length >= 3) {
                            itemStack.func_77964_b(Integer.valueOf(stackStrings[2]).intValue());
                        }
                        if (stackStrings.length == 4) {
                            try {
                                itemStack.func_77982_d(JsonToNBT.func_180713_a((String)stackStrings[3]));
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((fortuneElement = drop.get("fortunes")) == null) continue;
                        JsonObject fortunes = fortuneElement.getAsJsonObject();
                        for (Map.Entry fortuneValue : fortunes.entrySet()) {
                            int fortuneLevel = Integer.valueOf((String)fortuneValue.getKey());
                            float dropAmount = ((JsonElement)fortuneValue.getValue()).getAsFloat();
                            dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                        }
                    }
                }
                if ((blockStack.func_190926_b() || blockStack.func_77973_b() == Items.field_190931_a) && dropList.size() > 0) {
                    blockStack = ((LootDrop)dropList.get((int)0)).item.func_77946_l();
                    blockStack.func_190920_e(1);
                }
                JERAPI.getInstance().getWorldGenRegistry().register(blockStack, (DistributionBase)distribution, Integrate.getRestriction((Biome[])biomes, dim), silktouch, dropList.toArray(new LootDrop[dropList.size()]));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Restriction getRestriction(Biome[] biomes, String dim) {
        if (biomes.length > 0) {
            return new Restriction(new BiomeRestriction(biomes[0], (Biome[])ArrayUtils.remove((Object[])biomes, (int)0)), new DimensionRestriction(dim));
        }
        return map.computeIfAbsent(dim, k -> new Restriction(new DimensionRestriction(dim)));
    }

    public static boolean write(File file, OreBlock ... oreBlocks) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(new File(Config.config_dir, "biomesoplenty.json")));
            writer.setIndent("\t");
            writer.beginArray();
            for (OreBlock bopOre : oreBlocks) {
                writer.beginObject();
                if (bopOre.getBlockKey() == null) continue;
                writer.name("block").value(bopOre.getBlockKey());
                writer.name("distrib");
                writer.beginObject();
                if (bopOre.getGenerationType() == null || bopOre.getGenerationValue() == null) continue;
                writer.name("type").value(bopOre.getGenerationType());
                writer.name("value").value(bopOre.getGenerationValue());
                writer.endObject();
                writer.name("silktouch").value(bopOre.requiresSilktouch());
                writer.name("dropsList");
                writer.beginArray();
                ItemStack[] drops = bopOre.getDrops();
                if (drops == null) continue;
                for (ItemStack drop : drops) {
                    writer.beginObject();
                    writer.name("itemStack").value(drop.func_77973_b().getRegistryName() + ":" + drop.func_77960_j());
                    writer.name("fortunes");
                    writer.beginObject();
                    writer.name("0").value(1.0);
                    writer.endObject();
                    writer.endObject();
                }
                writer.endArray();
                writer.name("dim").value(bopOre.getDimensionName());
                writer.name("biomes");
                writer.beginArray();
                Biome[] spawnBiomes = bopOre.getSpawnBiomes();
                if (spawnBiomes != null) {
                    for (Biome biome : spawnBiomes) {
                        writer.value((long)Biome.func_185362_a((Biome)biome));
                    }
                }
                writer.endArray();
                writer.endObject();
            }
            writer.endArray();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

