/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.biolib.library;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.block.BlockMolten;
import slimeknights.tconstruct.tools.TinkerTools;

@Mod.EventBusSubscriber(modid="biolib")
public class Registry {
    private static ArrayList<String> toolforgeBlocks = new ArrayList();
    private static ArrayList<ResourceLocation> fluids = new ArrayList();
    private static ArrayList<BlockMolten> fluidBlocks = new ArrayList();

    public static void addBToolForgeBlock(String oredict) {
        toolforgeBlocks.add("block" + oredict);
    }

    public static void addFluidBlock(String modid, String name) {
        fluids.add(new ResourceLocation(modid, name));
    }

    public static void addFluidBlock(ResourceLocation resourceLocation) {
        fluids.add(resourceLocation);
    }

    @SubscribeEvent
    public static void addRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        for (String ore : toolforgeBlocks) {
            TinkerTools.registerToolForgeBlock((IForgeRegistry)r, (String)ore);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (BlockMolten block : fluidBlocks) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (ResourceLocation resource : fluids) {
            Registry.registerBlock((IForgeRegistry<Block>)event.getRegistry(), resource.func_110624_b(), resource.func_110623_a());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Block block : fluidBlocks) {
            ItemBlock itemBlock = new ItemBlock(block);
            itemBlock.setRegistryName(block.getRegistryName());
            itemBlock.func_77655_b(itemBlock.func_77658_a());
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
    }

    private static void registerBlock(IForgeRegistry<Block> r, String modid, String name) {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        BlockMolten block = new BlockMolten(fluid);
        block.setRegistryName(modid, "molten_" + name);
        block.func_149663_c(modid + "_molten_" + name);
        block.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
        r.register((IForgeRegistryEntry)block);
    }
}

