/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.biolib.library;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class SmelteryUtils {
    public static int VALUE_Gear = 576;
    public static int VALUE_SHEET = 200;
    public static int VALUE_DOUBLE_INGOT = 200;

    public static void registerIngotCasting(String ore, Fluid fluid) {
        ItemStack result = (ItemStack)OreDictionary.getOres((String)("ingot" + ore)).get(0);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castIngot, (Fluid)fluid, (int)144);
        }
    }

    public static void registerCasting(String ore, ItemStack cast, Fluid fluid, int amount) {
        ItemStack result = (ItemStack)OreDictionary.getOres((String)ore).get(0);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)cast, (Fluid)fluid, (int)amount);
        }
    }

    public static void registerCasting(ItemStack input, ItemStack cast, Fluid fluid, int amount) {
        TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)cast, (Fluid)fluid, (int)amount);
    }

    public static void registerCasting(String type, String ore, Fluid fluid) {
        ItemStack input = (ItemStack)OreDictionary.getOres((String)(type + ore)).get(0);
        if (!input.func_190926_b()) {
            switch (type) {
                case "plate": {
                    TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)TinkerSmeltery.castPlate, (Fluid)fluid, (int)144);
                    break;
                }
                case "gear": {
                    TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)TinkerSmeltery.castGear, (Fluid)fluid, (int)VALUE_Gear);
                    break;
                }
                case "gem": {
                    TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)TinkerSmeltery.castGem, (Fluid)fluid, (int)144);
                    break;
                }
                case "nugget": {
                    TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)TinkerSmeltery.castNugget, (Fluid)fluid, (int)16);
                    break;
                }
                case "ingot": {
                    TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)TinkerSmeltery.castIngot, (Fluid)fluid, (int)144);
                    break;
                }
                case "block": {
                    TinkerRegistry.registerBasinCasting((ItemStack)input, (ItemStack)ItemStack.field_190927_a, (Fluid)fluid, (int)1296);
                }
            }
        }
    }

    public static void addMelting(String ore, FluidStack fluidstack) {
        TinkerRegistry.registerMelting((String)ore, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void addMelting(ItemStack item, FluidStack fluidstack) {
        TinkerRegistry.registerMelting((ItemStack)item, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void addBasinCasing(ItemStack output, FluidStack fluidstack, @Nullable ItemStack input) {
        TinkerRegistry.registerBasinCasting((ItemStack)output, (ItemStack)input, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void defaultMelting(String ore, Fluid fluid) {
        TinkerRegistry.registerMelting((String)("ingot" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("dust" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("block" + ore), (Fluid)fluid, (int)1296);
        TinkerRegistry.registerMelting((String)("ore" + ore), (Fluid)fluid, (int)Material.VALUE_Ore());
        SmelteryUtils.registerIngotCasting(ore, fluid);
    }

    public static void registerMelting(String ore, Fluid fluid, int mat) {
        TinkerRegistry.registerMelting((String)ore, (Fluid)fluid, (int)mat);
    }

    public static void registerAlloy(FluidStack output, FluidStack ... inputs) {
        AlloyRecipe recipe = new AlloyRecipe(output, inputs);
        TinkerRegistry.registerAlloy((AlloyRecipe)recipe);
    }

    public static boolean checkIfAlloyRecipeExist(FluidStack output, FluidStack ... inputs) {
        boolean exist = false;
        AlloyRecipe recipe = new AlloyRecipe(output, inputs);
        for (AlloyRecipe alloy : TinkerRegistry.getAlloys()) {
            if (!alloy.equals(recipe)) continue;
            exist = true;
        }
        return exist;
    }
}

