/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.block;

import com.google.common.base.Predicate;
import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.block.BlockBase;
import com.vladmarica.energymeters.energy.EnergyType;
import com.vladmarica.energymeters.energy.EnergyTypes;
import com.vladmarica.energymeters.properties.UnlistedPropertyBoolean;
import com.vladmarica.energymeters.properties.UnlistedPropertyFacing;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterEU;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterFE;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterMJ;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnergyMeter
extends BlockBase {
    public static final String NAME = "meter";
    public static final PropertyDirection PROP_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<MeterType> PROP_TYPE = PropertyEnum.func_177709_a((String)"type", MeterType.class);
    public static final UnlistedPropertyFacing PROP_INPUT = UnlistedPropertyFacing.create("input");
    public static final UnlistedPropertyFacing PROP_OUTPUT = UnlistedPropertyFacing.create("output");
    public static final UnlistedPropertyBoolean PROP_CONNECTED = UnlistedPropertyBoolean.create("connected");

    public BlockEnergyMeter() {
        super(Material.field_151573_f, NAME);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PROP_FACING, (Comparable)EnumFacing.NORTH).func_177226_a(PROP_TYPE, (Comparable)((Object)MeterType.FE_METER)));
        this.setHarvestLevel("pickaxe", 1);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        MeterType type = (MeterType)((Object)state.func_177229_b(PROP_TYPE));
        switch (type) {
            case FE_METER: {
                return new TileEntityEnergyMeterFE();
            }
            case MJ_METER: {
                return new TileEntityEnergyMeterMJ();
            }
            case EU_METER: {
                return new TileEntityEnergyMeterEU();
            }
        }
        EnergyMetersMod.LOGGER.error("Attempted to create tile entity for invalid type {}", (Object)type.func_176610_l());
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileEntityEnergyMeterBase tile = (TileEntityEnergyMeterBase)world.func_175625_s(pos);
        if (tile != null) {
            tile.onNeighborChanged(fromPos, state);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        MeterType meterType = MeterType.values()[meta];
        return this.func_176223_P().func_177226_a(PROP_TYPE, (Comparable)((Object)meterType));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        StackTraceElement[] stack;
        if (Loader.isModLoaded((String)"betterbuilderswands") && (stack = Thread.currentThread().getStackTrace()).length > 2 && stack[2].getClassName().equals("portablejim.bbw.core.WandWorker")) {
            return this.func_176203_a(meta);
        }
        return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public IBlockState func_176203_a(int meta) {
        int facingIndex = meta & 3;
        int typeIndex = (meta & 0xC) >> 2;
        return this.func_176223_P().func_177226_a((IProperty)PROP_FACING, (Comparable)EnumFacing.func_176731_b((int)facingIndex)).func_177226_a(PROP_TYPE, (Comparable)((Object)MeterType.values()[typeIndex]));
    }

    public int func_176201_c(IBlockState state) {
        int facingIndex = ((EnumFacing)state.func_177229_b((IProperty)PROP_FACING)).func_176736_b();
        int typeIndex = ((MeterType)((Object)state.func_177229_b(PROP_TYPE))).getIndex();
        return facingIndex | typeIndex << 2;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnergyMetersMod.PROXY.handleEnergyBlockActivation(world, pos, player);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PROP_FACING, PROP_TYPE}, new IUnlistedProperty[]{PROP_INPUT, PROP_OUTPUT, PROP_CONNECTED});
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState ext = (IExtendedBlockState)state;
        TileEntityEnergyMeterBase tile = (TileEntityEnergyMeterBase)world.func_175625_s(pos);
        if (tile != null) {
            ext = ext.withProperty((IUnlistedProperty)PROP_INPUT, (Object)tile.getInputSide()).withProperty((IUnlistedProperty)PROP_OUTPUT, (Object)tile.getOutputSide()).withProperty((IUnlistedProperty)PROP_CONNECTED, (Object)tile.isFullyConnected());
        }
        return ext;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)PROP_FACING, (Comparable)BlockEnergyMeter.getFacingFromEntity(pos, placer)), 2);
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entity) {
        EnumFacing facing = EnumFacing.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)((float)(entity.field_70163_u - (double)clickedBlock.func_177956_o())), (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return facing;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null && side != ((EnumFacing)state.func_177229_b((IProperty)PROP_FACING)).func_176734_d();
    }

    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> items) {
        for (MeterType type : MeterType.values()) {
            if (!type.getEnergyType().isAvailable()) continue;
            items.add((Object)new ItemStack((Block)this, 1, type.getIndex()));
        }
    }

    public int func_180651_a(IBlockState state) {
        MeterType type = (MeterType)((Object)state.func_177229_b(PROP_TYPE));
        return type.getIndex();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        MeterType type = (MeterType)((Object)state.func_177229_b(PROP_TYPE));
        return new ItemStack(Item.func_150898_a((Block)this), 1, type.getIndex());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        for (MeterType type : MeterType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)type.getIndex(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_" + type.func_176610_l()));
        }
    }

    public static enum MeterType implements IStringSerializable
    {
        FE_METER(0, EnergyTypes.FE),
        MJ_METER(1, EnergyTypes.MJ),
        EU_METER(2, EnergyTypes.EU);

        private int index;
        private EnergyType type;

        private MeterType(int index, EnergyType type) {
            this.index = index;
            this.type = type;
        }

        public int getIndex() {
            return this.index;
        }

        public EnergyType getEnergyType() {
            return this.type;
        }

        public String func_176610_l() {
            return this.type.getName().toLowerCase();
        }
    }
}

