/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.tile.config;

import com.vladmarica.energymeters.client.Sprite;
import com.vladmarica.energymeters.client.Sprites;
import com.vladmarica.energymeters.tile.config.IConfigEnum;
import java.util.function.Function;
import javax.annotation.Nullable;

public enum EnumRedstoneControlState implements IConfigEnum
{
    ACTIVE("Active", powered -> powered == false),
    INVERTED("Inverted", Function.identity()),
    IGNORED("Ignored", powered -> true);

    private String title;
    private Function<Boolean, Boolean> checkEnabledFunction;

    private EnumRedstoneControlState(String title, Function<Boolean, Boolean> checkEnabledFunction) {
        this.title = title;
        this.checkEnabledFunction = checkEnabledFunction;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.title;
    }

    public EnumRedstoneControlState getDefault() {
        return ACTIVE;
    }

    @Override
    public Sprite getIcon() {
        switch (this.ordinal()) {
            case 0: {
                return Sprites.REDSTONE_ACTIVE;
            }
            case 1: {
                return Sprites.REDSTONE_INVERTED;
            }
            case 2: {
                return Sprites.REDSTONE_DISABLED;
            }
        }
        throw new RuntimeException("EnumRedstoneControl attempted to get icon for invalid ordinal " + this.ordinal());
    }

    public boolean isMachineEnabled(boolean powered) {
        return this.checkEnabledFunction.apply(powered);
    }
}

