/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import javax.annotation.Nullable;
import magicbees.api.ICrumblingHandler;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AlleleEffectCrumbling
extends AlleleEffectThrottled {
    private final ICrumblingHandler crumblingHandler;

    public AlleleEffectCrumbling(ResourceLocation rl, ICrumblingHandler crumblingHandler) {
        super(rl);
        this.setDominant();
        this.setThrottle(600);
        this.crumblingHandler = crumblingHandler;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int xRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory().func_177958_n());
        int yRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory().func_177956_o());
        int zRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory().func_177952_p());
        int xCoord = coords.func_177958_n() + world.field_73012_v.nextInt(xRange) - xRange / 2;
        int yCoord = coords.func_177956_o() + world.field_73012_v.nextInt(yRange) - yRange / 2;
        int zCoord = coords.func_177952_p() + world.field_73012_v.nextInt(zRange) - zRange / 2;
        BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
        this.crumblingHandler.crumble(world, pos);
        storedData.setInteger(0, 0);
        return storedData;
    }

    @Override
    public IEffectData validateStorage(@Nullable IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }
}

