/*
 * Decompiled with CFR 0.152.
 */
package magicbees.elec332.corerepack.util;

import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public enum MoonPhase {
    FULL("full"),
    WANING_GIBBOUS("gibbousWaning"),
    WANING_HALF("halfWaning"),
    WANING_CRESCENT("crescentWaning"),
    NEW("new"),
    WAXING_CRESCENT("crescentWaxing"),
    WAXING_HALF("halfWaxing"),
    WAXING_GIBBOUS("gibbousWaxing");

    private String phaseName;

    private MoonPhase(String name) {
        this.phaseName = name;
    }

    public boolean isBetween(MoonPhase first, MoonPhase second) {
        if (first.ordinal() <= second.ordinal()) {
            return first.ordinal() <= this.ordinal() && this.ordinal() <= second.ordinal();
        }
        return first.ordinal() <= this.ordinal() && this.ordinal() <= WAXING_GIBBOUS.ordinal() || FULL.ordinal() <= this.ordinal() && this.ordinal() <= second.ordinal();
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)("moon." + this.phaseName));
    }

    public static MoonPhase getMoonPhase(World w) {
        return MoonPhase.getMoonPhaseFromTime(w.func_72820_D());
    }

    public static MoonPhase getMoonPhaseFromTime(long time) {
        return MoonPhase.values()[(int)((time - 6000L) / 24000L) % 8];
    }
}

