/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.botania;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import java.util.List;
import magicbees.integration.botania.BotaniaIntegrationConfig;
import magicbees.util.Utils;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.botania.api.subtile.SubTileGenerating;

public class SubTileBeegonia
extends SubTileGenerating {
    public static final String NAME = "beegonia";
    private static final int DRONE_BURN_TIME_BASE = 100;
    private static final int ITEM_STACK_AGE_THRESHOLD = 60;
    private static final int RANGE = 3;
    private int burnTimeLeft = 0;

    private void searchForDroneStack() {
        if (!this.supertile.func_145831_w().field_72995_K && this.mana < this.getMaxMana()) {
            boolean needsSync = false;
            List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, Utils.getAABB(this.supertile.func_174877_v(), 3, true));
            for (EntityItem item : items) {
                ItemStack stack;
                if (item.field_70292_b < 60 || item.field_70128_L || !BeeManager.beeRoot.isDrone(stack = item.func_92059_d())) continue;
                IBee bee = BeeManager.beeRoot.getMember(stack);
                if (bee == null) {
                    return;
                }
                if (stack.func_190916_E() > 0) {
                    stack.func_190918_g(1);
                    this.burnTimeLeft = (int)((float)(100 * this.getSpeciesScaledComplexity(bee.getGenome().getPrimary())) * BotaniaIntegrationConfig.beegoniaManaMultiplier);
                    needsSync = true;
                }
                if (stack.func_190916_E() > 0) continue;
                item.func_70106_y();
            }
            if (needsSync) {
                this.sync();
            }
        }
    }

    private int getSpeciesScaledComplexity(IAlleleBeeSpecies species) {
        if (species == null) {
            return 0;
        }
        try {
            int halfComplexity = species.getComplexity() / 2;
            return halfComplexity >= 1 ? halfComplexity : 1;
        }
        catch (NoSuchMethodError error) {
            return 1;
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.linkedCollector != null) {
            if (this.burnTimeLeft > 0) {
                --this.burnTimeLeft;
            } else {
                this.searchForDroneStack();
            }
        }
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTimeLeft = cmp.func_74762_e("burnTimeLeft");
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a("burnTimeLeft", this.burnTimeLeft);
    }

    public int getMaxMana() {
        return 600;
    }

    public int getValueForPassiveGeneration() {
        return 1;
    }

    public boolean canGeneratePassively() {
        return this.burnTimeLeft > 0;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 1;
    }

    public int getColor() {
        return 0xFFFF96;
    }
}

