/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import magicbees.api.ICrumblingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class DefaultCrumblingHandler
implements ICrumblingHandler {
    private final Map<ItemStack, IBlockState> crumbleMap = Maps.newHashMap();

    @Override
    public void addCrumblingHandler(@Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (after.func_190926_b()) {
            throw new IllegalArgumentException();
        }
        Block block = Block.func_149634_a((Item)after.func_77973_b());
        if (block == null || block == Blocks.field_150350_a) {
            throw new IllegalArgumentException();
        }
        this.addCrumblingHandler(before, block.func_176203_a(after.func_77960_j()));
    }

    @Override
    public void addCrumblingHandler(@Nonnull ItemStack before, @Nonnull IBlockState after) {
        if (before.func_190926_b()) {
            throw new IllegalArgumentException();
        }
        for (ItemStack stack : this.crumbleMap.keySet()) {
            if (!OreDictionary.itemMatches((ItemStack)before, (ItemStack)stack, (boolean)false)) continue;
            return;
        }
        this.crumbleMap.put(before, (IBlockState)Preconditions.checkNotNull((Object)after));
    }

    @Override
    public boolean crumble(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            IBlockState state = world.func_180495_p(pos);
            ItemStack source = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            for (ItemStack stack : this.crumbleMap.keySet()) {
                if (!OreDictionary.itemMatches((ItemStack)source, (ItemStack)stack, (boolean)false)) continue;
                IBlockState target = this.crumbleMap.get(stack);
                world.func_180501_a(pos, target, 2);
                return true;
            }
        }
        return false;
    }
}

