/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.net;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import landmaster.plustic.api.Toggle;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketUpdateToggleGui;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import slimeknights.tconstruct.library.utils.TagUtil;

public class PacketHandleToggleGui
implements IMessage {
    @CapabilityInject(value=Toggle.IToggleArmor.class)
    private static Capability<Toggle.IToggleArmor> TOGGLE_ARMOR = null;
    private String identifier;

    public PacketHandleToggleGui() {
    }

    public PacketHandleToggleGui(String identifier) {
        this.identifier = identifier;
    }

    public static IMessage onMessage(PacketHandleToggleGui message, MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_();
        mainThread.func_152344_a(() -> {
            EntityPlayerMP ep = ctx.getServerHandler().field_147369_b;
            if (ep.func_130014_f_().field_72995_K) {
                return;
            }
            boolean newState = false;
            if (message.identifier.startsWith("\\") && ep.hasCapability(TOGGLE_ARMOR, null)) {
                String rawIdentifier = Toggle.rawIdentifier(message.identifier);
                Toggle.IToggleArmor cap = (Toggle.IToggleArmor)ep.getCapability(TOGGLE_ARMOR, null);
                Set<String> disabled = cap.getDisabled();
                newState = disabled.contains(rawIdentifier);
                if (newState) {
                    disabled.remove(rawIdentifier);
                } else {
                    disabled.add(rawIdentifier);
                }
            } else {
                NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)ep.func_184614_ca());
                newState = !Toggle.getToggleState(nbt, message.identifier);
                Toggle.setToggleState(nbt, message.identifier, newState);
                ep.func_184614_ca().func_77982_d(nbt);
                ep.field_71071_by.func_70296_d();
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateToggleGui(message.identifier, newState), ep);
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.identifier = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.identifier);
    }
}

