/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.util;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Coord4D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;
    public static final Coord4D NIHIL = new Coord4D(0.0, 0.0, 0.0, 0);

    public Coord4D(Entity ent) {
        this.xCoord = (int)ent.field_70165_t;
        this.yCoord = (int)ent.field_70163_u;
        this.zCoord = (int)ent.field_70161_v;
        this.dimensionId = ent.field_71093_bK;
    }

    public Coord4D(double x, double y, double z, int dimension) {
        this.xCoord = MathHelper.func_76128_c((double)x);
        this.yCoord = MathHelper.func_76128_c((double)y);
        this.zCoord = MathHelper.func_76128_c((double)z);
        this.dimensionId = dimension;
    }

    public Coord4D(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension());
    }

    public static Coord4D fromNBT(NBTTagCompound nbt) {
        if (nbt.func_186856_d() == 0) {
            return null;
        }
        return new Coord4D(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim"));
    }

    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.xCoord);
        nbt.func_74768_a("y", this.yCoord);
        nbt.func_74768_a("z", this.zCoord);
        nbt.func_74768_a("dim", this.dimensionId);
        return nbt;
    }

    public static Coord4D fromByteBuf(ByteBuf bb) {
        return new Coord4D(bb.readInt(), bb.readInt(), bb.readInt(), bb.readInt());
    }

    public ByteBuf toByteBuf(ByteBuf bb) {
        return bb.writeInt(this.xCoord).writeInt(this.yCoord).writeInt(this.zCoord).writeInt(this.dimensionId);
    }

    public Coord4D add(int x, int y, int z) {
        return new Coord4D(this.xCoord + x, this.yCoord + y, this.zCoord + z, this.dimensionId);
    }

    public IBlockState blockState() {
        WorldServer world = this.world();
        if (world == null) {
            return null;
        }
        return world.func_180495_p(this.pos());
    }

    public TileEntity TE() {
        WorldServer world = this.world();
        if (world == null) {
            return null;
        }
        return world.func_175625_s(this.pos());
    }

    public BlockPos pos() {
        return new BlockPos(this.xCoord, this.yCoord, this.zCoord);
    }

    public WorldServer world() {
        return DimensionManager.getWorld((int)this.dimensionId);
    }

    public String toString() {
        return String.format(Locale.US, "[x=%d, y=%d, z=%d] @ dimension %d", this.xCoord, this.yCoord, this.zCoord, this.dimensionId);
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).xCoord == this.xCoord && ((Coord4D)obj).yCoord == this.yCoord && ((Coord4D)obj).zCoord == this.zCoord && ((Coord4D)obj).dimensionId == this.dimensionId;
    }
}

