/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrossBigReactors
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TileEntityReactorPartBase) {
            MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
            if (reactor == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "FE");
            tag.func_74780_a("storage", (double)reactor.getEnergyStored());
            tag.func_74780_a("maxStorage", (double)reactor.getEnergyCapacity());
            return tag;
        }
        if (te instanceof TileEntityTurbinePartBase) {
            MultiblockTurbine turbine = ((TileEntityTurbinePartBase)te).getTurbine();
            if (turbine == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "FE");
            tag.func_74780_a("storage", (double)turbine.getEnergyStored());
            tag.func_74780_a("maxStorage", (double)turbine.getEnergyCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            MultiblockReactor reactor;
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof TileEntityReactorPartBase) || (reactor = ((TileEntityReactorPartBase)te).getReactorController()) == null) continue;
            return (int)reactor.getReactorHeat();
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof TileEntityReactorPartBase) {
            MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
            if (reactor == null) {
                return null;
            }
            if (reactor.isPassivelyCooled()) {
                return null;
            }
            FluidTankInfo[] info = reactor.getCoolantContainer().getTankInfo(-1);
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            for (FluidTankInfo tank : info) {
                result.add(new FluidInfo(tank.fluid, tank.capacity));
            }
            return result;
        }
        if (te instanceof TileEntityTurbinePartBase) {
            MultiblockTurbine turbine = ((TileEntityTurbinePartBase)te).getTurbine();
            if (turbine == null) {
                return null;
            }
            IFluidHandler input = turbine.getFluidHandler(IInputOutputPort.Direction.Input);
            IFluidHandler output = turbine.getFluidHandler(IInputOutputPort.Direction.Output);
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            result.add(new FluidInfo(input.getTankProperties()[0].getContents(), input.getTankProperties()[0].getCapacity()));
            result.add(new FluidInfo(output.getTankProperties()[0].getContents(), output.getTankProperties()[0].getCapacity()));
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(TileEntity te) {
        if (te instanceof TileEntityReactorPartBase) {
            MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
            if (reactor == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 1);
            tag.func_74757_a("reactorPoweredB", reactor.getActive());
            tag.func_74757_a("cooling", reactor.isPassivelyCooled());
            tag.func_74778_a("system", reactor.getPowerSystem().unitOfMeasure);
            tag.func_74780_a("heat", (double)reactor.getFuelHeat());
            tag.func_74768_a("coreHeat", (int)reactor.getReactorHeat());
            tag.func_74780_a("storage", (double)reactor.getEnergyStored());
            tag.func_74780_a("capacity", (double)reactor.getEnergyCapacity());
            tag.func_74780_a("output", (double)reactor.getEnergyGeneratedLastTick());
            tag.func_74768_a("rods", reactor.getFuelRodCount());
            tag.func_74768_a("fuel", reactor.getFuelAmount());
            tag.func_74768_a("waste", reactor.getWasteAmount());
            tag.func_74768_a("fuelCapacity", reactor.getCapacity());
            tag.func_74780_a("consumption", (double)reactor.getFuelConsumedLastTick());
            BlockPos min = reactor.getMinimumCoord();
            BlockPos max = reactor.getMaximumCoord();
            tag.func_74778_a("size", String.format("%sx%sx%s", max.func_177958_n() - min.func_177958_n() + 1, max.func_177956_o() - min.func_177956_o() + 1, max.func_177952_p() - min.func_177952_p() + 1));
            return tag;
        }
        if (te instanceof TileEntityTurbinePartBase) {
            MultiblockTurbine turbine = ((TileEntityTurbinePartBase)te).getTurbine();
            if (turbine == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74757_a("reactorPoweredB", turbine.getActive());
            tag.func_74778_a("system", turbine.getPowerSystem().unitOfMeasure);
            tag.func_74780_a("storage", (double)turbine.getEnergyStored());
            tag.func_74780_a("capacity", (double)turbine.getEnergyCapacity());
            tag.func_74780_a("output", (double)turbine.getEnergyGeneratedLastTick());
            tag.func_74780_a("speed", (double)turbine.getRotorSpeed());
            tag.func_74780_a("speedMax", (double)turbine.getMaxRotorSpeed());
            tag.func_74780_a("efficiency", (double)turbine.getRotorEfficiencyLastTick());
            tag.func_74780_a("consumption", (double)turbine.getFluidConsumedLastTick());
            tag.func_74768_a("blades", turbine.getNumRotorBlades());
            tag.func_74768_a("mass", turbine.getRotorMass());
            BlockPos min = turbine.getMinimumCoord();
            BlockPos max = turbine.getMaximumCoord();
            tag.func_74778_a("size", String.format("%sx%sx%s", max.func_177958_n() - min.func_177958_n() + 1, max.func_177956_o() - min.func_177956_o() + 1, max.func_177952_p() - min.func_177952_p() + 1));
            return tag;
        }
        return null;
    }
}

