/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.enderio.core.common.fluid.SmartTank;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorEntity;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredMachineEntity;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.machines.machine.generator.combustion.CombustionMath;
import crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import crazypants.enderio.machines.machine.solar.TileSolarPanel;
import crazypants.enderio.machines.machine.vat.TileVat;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class CrossEnderIO
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof AbstractPoweredMachineEntity) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "\u00b5I");
            tag.func_74780_a("storage", (double)((AbstractPoweredMachineEntity)te).getEnergyStored());
            tag.func_74780_a("maxStorage", (double)((AbstractPoweredMachineEntity)te).getMaxEnergyStored());
            return tag;
        }
        if (te instanceof TileCapBank) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "\u00b5I");
            tag.func_74780_a("storage", (double)((TileCapBank)te).getEnergyStored());
            tag.func_74780_a("maxStorage", (double)((TileCapBank)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        ArrayList result = new ArrayList();
        return null;
    }

    @Override
    public NBTTagCompound getCardData(TileEntity te) {
        if (te instanceof AbstractPoweredMachineEntity) {
            AbstractPoweredMachineEntity machine = (AbstractPoweredMachineEntity)te;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "\u00b5I");
            tag.func_74780_a("storage", (double)machine.getEnergyStored());
            tag.func_74780_a("maxStorage", (double)machine.getMaxEnergyStored());
            tag.func_74757_a("active", machine.isActive());
            if (machine.getPowerLossPerTick() > 0.0f) {
                tag.func_74780_a("leakage", (double)machine.getPowerLossPerTick());
            }
            if (te instanceof AbstractGeneratorEntity) {
                if (te instanceof TileStirlingGenerator) {
                    if (machine.isActive()) {
                        tag.func_74780_a("output", (double)machine.getPowerUsePerTick());
                    } else {
                        tag.func_74780_a("output", 0.0);
                    }
                    tag.func_74780_a("efficiency", (double)(((TileStirlingGenerator)te).getBurnEfficiency() * 100.0f));
                }
                if (te instanceof TileCombustionGenerator) {
                    TileCombustionGenerator comb = (TileCombustionGenerator)te;
                    tag.func_74780_a("output", (double)comb.getGeneratedLastTick());
                    FluidInfo.addTank("tank", tag, (FluidTank)comb.getFuelTank());
                    FluidInfo.addTank("tank2", tag, (FluidTank)comb.getCoolantTank());
                    try {
                        Field field = AbstractPoweredMachineEntity.class.getDeclaredField("maxEnergyUsed");
                        field.setAccessible(true);
                        ICapacitorKey maxEnergyUsed = (ICapacitorKey)field.get(te);
                        CombustionMath math = new CombustionMath(CombustionMath.toCoolant((SmartTank)comb.getCoolantTank()), CombustionMath.toFuel((SmartTank)comb.getFuelTank()), maxEnergyUsed.getFloat(comb.getCapacitorData()), CapacitorKey.LEGACY_ENERGY_EFFICIENCY.getFloat(comb.getCapacitorData()));
                        tag.func_74780_a("usage1", (double)math.getTicksPerFuel());
                        tag.func_74780_a("usage2", (double)math.getTicksPerCoolant());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (te instanceof AbstractPoweredTaskEntity) {
                if (machine.isActive()) {
                    tag.func_74780_a("usage", (double)machine.getPowerUsePerTick());
                } else {
                    tag.func_74780_a("usage", 0.0);
                }
                if (te instanceof TileVat) {
                    FluidInfo.addTank("tank", tag, ((TileVat)te).getInputTank(new FluidStack(FluidRegistry.WATER, 1000)));
                    FluidInfo.addTank("tank2", tag, ((TileVat)te).getOutputTanks()[0]);
                }
            }
            return tag;
        }
        if (te instanceof TileCapBank) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "\u00b5I");
            tag.func_74780_a("storage", (double)((TileCapBank)te).getEnergyStored());
            tag.func_74780_a("maxStorage", (double)((TileCapBank)te).getMaxEnergyStored());
            tag.func_74780_a("maxInput", (double)((TileCapBank)te).getMaxInput());
            tag.func_74780_a("maxOutput", (double)((TileCapBank)te).getMaxOutput());
            tag.func_74780_a("difference", (double)((TileCapBank)te).getAverageIOPerTick());
            return tag;
        }
        if (te instanceof TileSolarPanel) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "\u00b5I");
            tag.func_74757_a("active", ((TileSolarPanel)te).getEnergyStored() > 0);
            tag.func_74780_a("output", (double)((TileSolarPanel)te).getEnergyStored());
            tag.func_74780_a("maxOutput", (double)((TileSolarPanel)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }
}

