/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.IC2ReactorHelper;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.utils.FluidInfo;
import ic2.api.classic.reactor.IChamberReactor;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.generator.tile.TileEntityLiquidFuelGenerator;
import ic2.core.block.generator.tile.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tile.TileEntityNuclearSteamReactor;
import ic2.core.block.generator.tile.TileEntityReactorChamberElectric;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.block.machine.low.TileEntityMachineTank;
import ic2.core.block.personal.tile.TileEntityPersonalTank;
import ic2.core.item.reactor.ItemReactorUraniumRod;
import ic2.core.item.tool.ItemToolWrench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class CrossIC2Classic
extends CrossModBase {
    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem((String)"upgrade", (String)"transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem((String)"upgrade", (String)"energy_storage");
            }
            case "machine": {
                return IC2Items.getItem((String)"resource", (String)"machine");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack par1) {
        return par1 != null && par1.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUraniumRod) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        return 0;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyStorage) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = (IEnergyStorage)te;
            tag.func_74768_a("type", 1);
            tag.func_74780_a("storage", (double)storage.getStored());
            tag.func_74780_a("maxStorage", (double)storage.getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(TileEntity te) {
        if (te instanceof TileEntitySolarPanel || te instanceof TileEntityGeneratorBase) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "EU");
            if (te instanceof TileEntitySolarPanel) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", ((TileEntitySolarPanel)te).getOfferedEnergy());
                tag.func_74780_a("maxStorage", (double)((TileEntitySolarPanel)te).getOutput());
                boolean active = ((TileEntitySolarPanel)te).getActive();
                tag.func_74757_a("active", active);
                if (active) {
                    tag.func_74780_a("production", (double)((TileEntitySolarPanel)te).getOutput());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
            if (te instanceof TileEntityGeneratorBase) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", (double)((TileEntityGeneratorBase)te).getStoredEU());
                tag.func_74780_a("maxStorage", (double)((TileEntityGeneratorBase)te).getMaxEU());
                boolean active = ((TileEntityGeneratorBase)te).getActive();
                tag.func_74757_a("active", active);
                if (active) {
                    tag.func_74780_a("production", (double)((TileEntityGeneratorBase)te).getOutput());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ItemStack getReactorCard(World world, BlockPos pos) {
        BlockPos position;
        TileEntity te = world.func_175625_s(pos);
        if ((te instanceof TileEntityNuclearReactorElectric || te instanceof TileEntityReactorChamberElectric || te instanceof TileEntityNuclearSteamReactor) && (position = IC2ReactorHelper.getTargetCoordinates(world, pos)) != null) {
            ItemStack sensorLocationCard = new ItemStack(ModItems.itemCard, 1, 7);
            ItemStackHelper.setCoordinates(sensorLocationCard, position);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getReactorData(TileEntity te) {
        if (!(te instanceof IChamberReactor)) {
            return null;
        }
        IReactor reactor = (IReactor)te;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("reactorPoweredB", reactor.produceEnergy());
        tag.func_74768_a("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
        tag.func_74757_a("isSteam", this.isSteamReactor(te));
        IChamberReactor chamber = (IChamberReactor)reactor;
        int size = chamber.getReactorSize();
        int dmgLeft = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack stack = chamber.getItemAt(x, y);
                if (stack.func_190926_b()) continue;
                dmgLeft = Math.max(dmgLeft, IC2ReactorHelper.getNuclearCellTimeLeft(stack));
            }
        }
        int timeLeft = this.isSteamReactor(te) ? dmgLeft : dmgLeft * reactor.getTickRate() / 20;
        tag.func_74768_a("timeLeft", timeLeft);
        return tag;
    }

    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactorAround(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        reactor = IC2ReactorHelper.getReactor3x3(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileEntityNuclearSteamReactor) {
            result.add(new FluidInfo((IFluidTank)((TileEntityNuclearSteamReactor)te).getWaterTank()));
            result.add(new FluidInfo((IFluidTank)((TileEntityNuclearSteamReactor)te).getSteamTank()));
        }
        if (te instanceof TileEntityMachineTank) {
            result.add(new FluidInfo((IFluidTank)((TileEntityMachineTank)te).tank));
        }
        if (te instanceof TileEntityPersonalTank) {
            result.add(new FluidInfo((IFluidTank)((TileEntityPersonalTank)te).tank));
        }
        if (te instanceof TileEntityLiquidFuelGenerator) {
            result.add(new FluidInfo((IFluidTank)((TileEntityLiquidFuelGenerator)te).tank));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }
}

