/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.IC2ReactorHelper;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.ItemAFB;
import com.zuxelus.energycontrol.items.ItemAFSUUpgradeKit;
import com.zuxelus.energycontrol.utils.FluidInfo;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.Fluids;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityConversionGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityKineticGenerator;
import ic2.core.block.generator.tileentity.TileEntityRTGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityStirlingGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityElectricHeatGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityElectricKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityManualKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntitySteamKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityStirlingKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWaterKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWindKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityCondenser;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.machine.tileentity.TileEntitySteamGenerator;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorAccessHatch;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorFluidPort;
import ic2.core.block.reactor.tileentity.TileEntityReactorRedstonePort;
import ic2.core.block.state.IIdProvider;
import ic2.core.block.type.ResourceBlock;
import ic2.core.init.MainConfig;
import ic2.core.item.reactor.ItemReactorLithiumCell;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.profile.ProfileManager;
import ic2.core.profile.Version;
import ic2.core.ref.BlockName;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class CrossIC2Exp
extends CrossModBase {
    @Override
    public int getProfile() {
        return ProfileManager.selected.style == Version.OLD ? 1 : 0;
    }

    @Override
    public Item getItem(String name) {
        switch (name) {
            case "afb": {
                return new ItemAFB();
            }
            case "afsu_upgrade_kit": {
                return new ItemAFSUUpgradeKit();
            }
            case "seed": {
                return IC2Items.getItem((String)"crop_seed_bag").func_77973_b();
            }
        }
        return null;
    }

    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem((String)"upgrade", (String)"transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem((String)"upgrade", (String)"energy_storage");
            }
            case "machine": {
                return IC2Items.getItem((String)"resource", (String)"machine");
            }
            case "mfsu": {
                return IC2Items.getItem((String)"te", (String)"mfsu");
            }
            case "circuit": {
                return IC2Items.getItem((String)"crafting", (String)"circuit");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public boolean isElectricItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IElectricItem;
    }

    @Override
    public double dischargeItem(ItemStack stack, double needed) {
        IElectricItem ielectricitem = (IElectricItem)stack.func_77973_b();
        if (ielectricitem.canProvideEnergy(stack)) {
            return ElectricItem.manager.discharge(stack, needed, 1, false, false, false);
        }
        return 0.0;
    }

    @Override
    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUranium || item instanceof ItemReactorLithiumCell) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        if (item.getClass().getName().equals("com.sm.FirstMod.items.ItemCoaxiumRod") || item.getClass().getName().equals("com.sm.FirstMod.items.ItemCesiumRod")) {
            return stack.func_77958_k() - this.getCoaxiumDamage(stack);
        }
        return 0;
    }

    private int getCoaxiumDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("fuelRodDamage");
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyStorage) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = (IEnergyStorage)te;
            tag.func_74778_a("euType", "EU");
            tag.func_74780_a("storage", (double)storage.getStored());
            tag.func_74780_a("maxStorage", (double)storage.getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(TileEntity te) {
        if (te instanceof TileEntityBaseGenerator || te instanceof TileEntityConversionGenerator || te instanceof TileEntitySteamGenerator || te instanceof TileEntityCondenser) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        if (te instanceof TileEntityElectricKineticGenerator || te instanceof TileEntityManualKineticGenerator || te instanceof TileEntitySteamKineticGenerator || te instanceof TileEntityStirlingKineticGenerator || te instanceof TileEntityWaterKineticGenerator || te instanceof TileEntityWindKineticGenerator) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 5);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        if (te instanceof TileEntityHeatSourceInventory) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 6);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            boolean active = this.isActive(te);
            tag.func_74757_a("active", active);
            tag.func_74778_a("euType", "EU");
            if (te instanceof TileEntityBaseGenerator) {
                tag.func_74768_a("type", 1);
                Energy energy = (Energy)((TileEntityBaseGenerator)te).getComponent(Energy.class);
                tag.func_74780_a("storage", energy.getEnergy());
                tag.func_74780_a("maxStorage", energy.getCapacity());
                if (te instanceof TileEntitySolarGenerator) {
                    float light = ((TileEntitySolarGenerator)te).skyLight;
                    active = light > 0.0f && energy.getEnergy() < energy.getCapacity();
                    tag.func_74757_a("active", active);
                    if (active) {
                        tag.func_74780_a("production", (double)light);
                    } else {
                        tag.func_74780_a("production", 0.0);
                    }
                    return tag;
                }
                if (te instanceof TileEntityRTGenerator) {
                    tag.func_74768_a("type", 4);
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityRTGenerator)te).fuelSlot.size(); ++i) {
                        if (((TileEntityRTGenerator)te).fuelSlot.isEmpty(i)) continue;
                        ++counter;
                    }
                    tag.func_74768_a("items", counter);
                    if (counter == 0 || energy.getEnergy() >= energy.getCapacity()) {
                        tag.func_74757_a("active", false);
                        tag.func_74780_a("production", 0.0);
                        return tag;
                    }
                    tag.func_74757_a("active", true);
                    Field field = TileEntityRTGenerator.class.getDeclaredField("efficiency");
                    field.setAccessible(true);
                    tag.func_74780_a("multiplier", (double)((Float)field.get(te)).floatValue());
                    tag.func_74780_a("production", Math.pow(2.0, counter - 1) * (double)((Float)field.get(te)).floatValue());
                    return tag;
                }
                if (te instanceof TileEntityWaterGenerator) {
                    active = ((TileEntityWaterGenerator)te).water > 0 || ((TileEntityWaterGenerator)te).fuel > 0;
                    tag.func_74757_a("active", active);
                    if (((TileEntityWaterGenerator)te).fuel <= 0) {
                        Field field = TileEntityWaterGenerator.class.getDeclaredField("energyMultiplier");
                        field.setAccessible(true);
                        tag.func_74780_a("production", (Double)field.get(te) * (double)((TileEntityWaterGenerator)te).water / 100.0);
                        return tag;
                    }
                }
                if (active) {
                    Field field = TileEntityBaseGenerator.class.getDeclaredField("production");
                    field.setAccessible(true);
                    tag.func_74780_a("production", ((Double)field.get(te)).doubleValue());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
            if (te instanceof TileEntityConversionGenerator) {
                Field field;
                if (active) {
                    field = TileEntityConversionGenerator.class.getDeclaredField("lastProduction");
                    field.setAccessible(true);
                    tag.func_74780_a("production", ((Double)field.get(te)).doubleValue());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                if (te instanceof TileEntityStirlingGenerator) {
                    tag.func_74768_a("type", 2);
                    field = TileEntityStirlingGenerator.class.getDeclaredField("productionpeerheat");
                    field.setAccessible(true);
                    tag.func_74780_a("multiplier", ((Double)field.get(te)).doubleValue());
                }
                if (te instanceof TileEntityKineticGenerator) {
                    tag.func_74768_a("type", 2);
                    field = TileEntityKineticGenerator.class.getDeclaredField("euPerKu");
                    field.setAccessible(true);
                    tag.func_74780_a("multiplier", ((Double)field.get(te)).doubleValue());
                }
                return tag;
            }
            if (te instanceof TileEntitySteamGenerator) {
                tag.func_74768_a("type", 7);
                tag.func_74757_a("active", ((TileEntitySteamGenerator)te).getHeatInput() > 0);
                tag.func_74780_a("heat", (double)((TileEntitySteamGenerator)te).getSystemHeat());
                tag.func_74768_a("production", ((TileEntitySteamGenerator)te).getOutputMB());
                tag.func_74768_a("consumption", ((TileEntitySteamGenerator)te).getInputMB());
                tag.func_74768_a("heatChange", ((TileEntitySteamGenerator)te).getHeatInput());
                tag.func_74768_a("water", ((TileEntitySteamGenerator)te).waterTank.getFluidAmount());
                tag.func_74780_a("calcification", (double)((TileEntitySteamGenerator)te).getCalcification());
                tag.func_74768_a("pressure", ((TileEntitySteamGenerator)te).getPressure());
                return tag;
            }
            if (te instanceof TileEntityCondenser) {
                tag.func_74768_a("type", 8);
                tag.func_74757_a("active", true);
                Energy energy = (Energy)((TileEntityCondenser)te).getComponent(Energy.class);
                tag.func_74780_a("storage", energy.getEnergy());
                tag.func_74780_a("maxStorage", energy.getCapacity());
                double d = (double)((TileEntityCondenser)te).progress * 100.0;
                ((TileEntityCondenser)te).getClass();
                tag.func_74780_a("progress", d / 10000.0);
                tag.func_74768_a("steam", ((TileEntityCondenser)te).getInputTank().getFluidAmount());
                tag.func_74768_a("water", ((TileEntityCondenser)te).getOutputTank().getFluidAmount());
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public NBTTagCompound getGeneratorKineticData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            if (te instanceof TileEntityManualKineticGenerator) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", (double)((TileEntityManualKineticGenerator)te).currentKU);
                ((TileEntityManualKineticGenerator)te).getClass();
                tag.func_74780_a("maxStorage", 1000.0);
                return tag;
            }
            Boolean active = ((TileEntityBlock)te).getActive();
            if (te instanceof TileEntityWindKineticGenerator) {
                TileEntityWindKineticGenerator entity = (TileEntityWindKineticGenerator)te;
                tag.func_74768_a("type", 5);
                tag.func_74780_a("output", (double)entity.getKuOutput());
                Field field = TileEntityWindKineticGenerator.class.getDeclaredField("windStrength");
                field.setAccessible(true);
                tag.func_74780_a("wind", ((Double)field.get(te)).doubleValue());
                tag.func_74780_a("multiplier", (double)(entity.getEfficiency() * TileEntityWindKineticGenerator.outputModifier));
                tag.func_74768_a("height", entity.func_174877_v().func_177956_o());
                if (entity.rotorSlot.isEmpty()) {
                    tag.func_74768_a("health", -1);
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)entity.rotorSlot.get().func_77952_i() * 100.0f / (float)entity.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (te instanceof TileEntityWaterKineticGenerator) {
                TileEntityWaterKineticGenerator entity = (TileEntityWaterKineticGenerator)te;
                tag.func_74768_a("type", 6);
                tag.func_74780_a("output", (double)entity.getKuOutput());
                Field field = TileEntityWaterKineticGenerator.class.getDeclaredField("waterFlow");
                field.setAccessible(true);
                tag.func_74780_a("wind", (double)((Integer)field.get(te)).intValue());
                field = TileEntityWaterKineticGenerator.class.getDeclaredField("outputModifier");
                field.setAccessible(true);
                tag.func_74780_a("multiplier", (double)((Float)field.get(te)).floatValue());
                tag.func_74768_a("height", entity.func_174877_v().func_177956_o());
                if (entity.rotorSlot.isEmpty()) {
                    tag.func_74768_a("health", -1);
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)entity.rotorSlot.get().func_77952_i() * 100.0f / (float)entity.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (te instanceof TileEntityStirlingKineticGenerator) {
                // empty if block
            }
            if (te instanceof TileEntitySteamKineticGenerator) {
                TileEntitySteamKineticGenerator entity = (TileEntitySteamKineticGenerator)te;
                tag.func_74768_a("type", 7);
                if (!entity.hasTurbine()) {
                    tag.func_74778_a("status", "ic2.SteamKineticGenerator.gui.error.noturbine");
                } else if (entity.isTurbineBlockedByWater()) {
                    tag.func_74778_a("status", "ic2.SteamKineticGenerator.gui.error.filledupwithwater");
                } else if (entity.getActive()) {
                    tag.func_74778_a("status", "ic2.SteamKineticGenerator.gui.aktive");
                } else {
                    tag.func_74778_a("status", "ic2.SteamKineticGenerator.gui.waiting");
                }
                tag.func_74780_a("output", (double)entity.getKUoutput());
                Field field = TileEntitySteamKineticGenerator.class.getDeclaredField("outputModifier");
                field.setAccessible(true);
                tag.func_74780_a("multiplier", (double)((Float)field.get(te)).floatValue() * (double)(1.0f - (float)entity.getDistilledWaterTank().getFluidAmount() / (float)entity.getDistilledWaterTank().getCapacity()));
                field = TileEntitySteamKineticGenerator.class.getDeclaredField("condensationProgress");
                field.setAccessible(true);
                tag.func_74768_a("condProgress", ((Integer)field.get(te)).intValue());
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public NBTTagCompound getGeneratorHeatData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            boolean active = ((TileEntityBlock)te).getActive();
            tag.func_74757_a("active", active);
            if (te instanceof TileEntityHeatSourceInventory) {
                tag.func_74768_a("type", 1);
                if (active) {
                    tag.func_74768_a("output", ((TileEntityHeatSourceInventory)te).gettransmitHeat());
                } else {
                    tag.func_74768_a("output", 0);
                }
                if (te instanceof TileEntityElectricHeatGenerator) {
                    Energy energy = (Energy)((TileEntityHeatSourceInventory)te).getComponent(Energy.class);
                    tag.func_74780_a("storage", energy.getEnergy());
                    tag.func_74780_a("maxStorage", energy.getCapacity());
                    int count = 0;
                    for (ItemStack stack : ((TileEntityElectricHeatGenerator)te).coilSlot) {
                        if (stack.func_190926_b()) continue;
                        ++count;
                    }
                    tag.func_74768_a("coils", count);
                }
                if (te instanceof TileEntityLiquidHeatExchanger) {
                    Fluids fluid = (Fluids)((TileEntityLiquidHeatExchanger)te).getComponent(Fluids.class);
                    Iterable tanks = fluid.getAllTanks();
                    Fluids.InternalFluidTank tank = (Fluids.InternalFluidTank)tanks.iterator().next();
                    tag.func_74780_a("storage", (double)tank.getFluidAmount());
                    tag.func_74780_a("maxStorage", (double)tank.getCapacity());
                    int count = 0;
                    for (ItemStack stack : ((TileEntityLiquidHeatExchanger)te).heatexchangerslots) {
                        if (stack.func_190926_b()) continue;
                        ++count;
                    }
                    tag.func_74768_a("coils", count);
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean isActive(TileEntity te) {
        if (te instanceof TileEntityGeoGenerator || te instanceof TileEntityConversionGenerator || te instanceof TileEntitySolarGenerator) {
            return ((TileEntityBlock)te).getActive();
        }
        if (te instanceof TileEntityBaseGenerator) {
            return ((TileEntityBaseGenerator)te).isConverting();
        }
        return false;
    }

    @Override
    public ItemStack getReactorCard(World world, BlockPos pos) {
        BlockPos position;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockTileEntity)) {
            return ItemStack.field_190927_a;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNuclearReactorElectric || te instanceof TileEntityReactorChamberElectric) {
            BlockPos position2 = IC2ReactorHelper.getTargetCoordinates(world, pos);
            if (position2 != null) {
                ItemStack card = new ItemStack(ModItems.itemCard, 1, 7);
                ItemStackHelper.setCoordinates(card, position2);
                return card;
            }
        } else if ((te instanceof TileEntityReactorFluidPort || te instanceof TileEntityReactorRedstonePort || te instanceof TileEntityReactorAccessHatch) && (position = IC2ReactorHelper.get5x5TargetCoordinates(world, pos)) != null) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 8);
            ItemStackHelper.setCoordinates(card, position);
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getReactorData(TileEntity te) {
        if (!(te instanceof TileEntityNuclearReactorElectric)) {
            return null;
        }
        IReactor reactor = (IReactor)te;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("reactorPoweredB", reactor.produceEnergy());
        tag.func_74768_a("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
        tag.func_74757_a("isSteam", false);
        IInventory inventory = (IInventory)reactor;
        int slotCount = inventory.func_70302_i_();
        int dmgLeft = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            dmgLeft = Math.max(dmgLeft, IC2ReactorHelper.getNuclearCellTimeLeft(stack));
        }
        tag.func_74768_a("timeLeft", dmgLeft * reactor.getTickRate() / 20);
        return tag;
    }

    @Override
    public NBTTagCompound getReactor5x5Data(TileEntity te) {
        if (!(te instanceof TileEntityNuclearReactorElectric)) {
            return null;
        }
        IReactor reactor = (IReactor)te;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("reactorPoweredB", reactor.produceEnergy());
        tag.func_74768_a("output", ((TileEntityNuclearReactorElectric)reactor).EmitHeat);
        IInventory inventory = (IInventory)reactor;
        int slotCount = inventory.func_70302_i_();
        int dmgLeft = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            dmgLeft = Math.max(dmgLeft, IC2ReactorHelper.getNuclearCellTimeLeft(stack));
        }
        int timeLeft = dmgLeft * reactor.getTickRate() / 20;
        tag.func_74768_a("timeLeft", timeLeft);
        return tag;
    }

    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactorAround(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        reactor = IC2ReactorHelper.getReactor3x3(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (!(te instanceof TileEntityBlock)) {
            return null;
        }
        if (!((TileEntityBlock)te).hasComponent(Fluids.class)) {
            return null;
        }
        Fluids fluid = (Fluids)((TileEntityBlock)te).getComponent(Fluids.class);
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        for (FluidTank tank : fluid.getAllTanks()) {
            result.add(new FluidInfo((IFluidTank)tank));
        }
        return result;
    }

    @Override
    public void loadOreInfo() {
        Config config = MainConfig.get().getSub("worldgen");
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.copper_ore).func_177230_c(), 1, config.getSub("copper"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.lead_ore).func_177230_c(), 2, config.getSub("lead"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.tin_ore).func_177230_c(), 3, config.getSub("tin"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.uranium_ore).func_177230_c(), 4, config.getSub("uranium"));
    }

    private void loadOre(Block block, int meta, Config config) {
        EnergyControl.oreHelper.put(OreHelper.getId(block, meta), new OreHelper(ConfigUtil.getInt((Config)config, (String)"minHeight"), ConfigUtil.getInt((Config)config, (String)"maxHeight"), ConfigUtil.getInt((Config)config, (String)"size"), ConfigUtil.getInt((Config)config, (String)"count")));
    }
}

