/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossAppEng;
import com.zuxelus.energycontrol.crossmod.CrossBigReactors;
import com.zuxelus.energycontrol.crossmod.CrossBuildCraft;
import com.zuxelus.energycontrol.crossmod.CrossDraconicEvolution;
import com.zuxelus.energycontrol.crossmod.CrossEnderIO;
import com.zuxelus.energycontrol.crossmod.CrossGalacticraft;
import com.zuxelus.energycontrol.crossmod.CrossHBM;
import com.zuxelus.energycontrol.crossmod.CrossIC2Classic;
import com.zuxelus.energycontrol.crossmod.CrossIC2Exp;
import com.zuxelus.energycontrol.crossmod.CrossMekanism;
import com.zuxelus.energycontrol.crossmod.CrossMekanismGenerators;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.CrossNuclearCraft;
import com.zuxelus.energycontrol.crossmod.CrossNuclearCraftOverhauled;
import com.zuxelus.energycontrol.crossmod.CrossPneumaticCraft;
import com.zuxelus.energycontrol.crossmod.CrossTechReborn;
import com.zuxelus.energycontrol.crossmod.CrossThermalExpansion;
import com.zuxelus.energycontrol.crossmod.computercraft.CrossComputerCraft;
import com.zuxelus.energycontrol.crossmod.opencomputers.CrossOpenComputers;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CrossModLoader {
    private static final Map<String, CrossModBase> CROSS_MODS = new HashMap<String, CrossModBase>();

    public static void preInit() {
        CROSS_MODS.put("ic2", Loader.isModLoaded((String)"ic2-classic-spmod") ? new CrossIC2Classic() : (Loader.isModLoaded((String)"ic2") ? new CrossIC2Exp() : new CrossModBase()));
        CrossModLoader.loadCrossMod("techreborn", CrossTechReborn::new);
        CrossModLoader.loadCrossMod("appliedenergistics2", CrossAppEng::new);
        CrossModLoader.loadCrossMod("bigreactors", CrossBigReactors::new);
        CrossModLoader.loadCrossMod("buildcraftcore", CrossBuildCraft::new);
        CrossModLoader.loadCrossMod("draconicevolution", CrossDraconicEvolution::new);
        CrossModLoader.loadCrossModSafely("enderio", () -> CrossEnderIO::new);
        CrossModLoader.loadCrossMod("galacticraftplanets", CrossGalacticraft::new);
        CrossModLoader.loadCrossMod("hbm", CrossHBM::new);
        CrossModLoader.loadCrossMod("mekanism", CrossMekanism::new);
        CrossModLoader.loadCrossMod("mekanismgenerators", CrossMekanismGenerators::new);
        ModContainer nc = (ModContainer)Loader.instance().getIndexedModList().get("nuclearcraft");
        if (nc != null) {
            if (nc.getVersion().contains("2o")) {
                CrossModLoader.loadCrossMod("nuclearcraft", CrossNuclearCraftOverhauled::new);
            } else {
                CrossModLoader.loadCrossMod("nuclearcraft", CrossNuclearCraft::new);
            }
        }
        CrossModLoader.loadCrossModSafely("computercraft", () -> CrossComputerCraft::new);
        CrossModLoader.loadCrossMod("pneumaticcraft", CrossPneumaticCraft::new);
        CrossModLoader.loadCrossMod("thermalexpansion", CrossThermalExpansion::new);
    }

    private static void loadCrossMod(String modid, Supplier<? extends CrossModBase> factory) {
        CROSS_MODS.put(modid, Loader.isModLoaded((String)modid) ? factory.get() : new CrossModBase());
    }

    private static void loadCrossModSafely(String modid, Supplier<Supplier<? extends CrossModBase>> factory) {
        CROSS_MODS.put(modid, Loader.isModLoaded((String)modid) ? factory.get().get() : new CrossModBase());
    }

    public static void init() {
        CrossModLoader.loadCrossMod("opencomputers", CrossOpenComputers::new);
    }

    public static CrossModBase getCrossMod(String modid) {
        return CROSS_MODS.get(modid);
    }

    public static ItemStack getEnergyCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound data = CrossModLoader.getEnergyData(te);
        if (data != null) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 0);
            ItemStackHelper.setCoordinates(card, pos);
            return card;
        }
        return ItemStack.field_190927_a;
    }

    public static NBTTagCompound getEnergyData(TileEntity te) {
        for (CrossModBase crossMod : CROSS_MODS.values()) {
            NBTTagCompound tag = crossMod.getEnergyData(te);
            if (tag == null) continue;
            return tag;
        }
        IEnergyStorage storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "FE");
            tag.func_74780_a("storage", (double)storage.getEnergyStored());
            tag.func_74780_a("maxStorage", (double)storage.getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    public static ItemStack getGeneratorCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            for (CrossModBase crossMod : CROSS_MODS.values()) {
                ItemStack card = crossMod.getGeneratorCard(te);
                if (card.func_190926_b()) continue;
                return card;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static List<FluidInfo> getAllTanks(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        for (CrossModBase crossMod : CROSS_MODS.values()) {
            List<FluidInfo> list = crossMod.getAllTanks(te);
            if (list == null) continue;
            return list;
        }
        IFluidHandler fluid = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluid != null) {
            IFluidTankProperties[] tanks = fluid.getTankProperties();
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            for (IFluidTankProperties tank : tanks) {
                result.add(new FluidInfo(tank.getContents(), tank.getCapacity()));
            }
            return result;
        }
        return null;
    }

    public static FluidInfo getTankAt(World world, BlockPos pos) {
        List<FluidInfo> tanks = CrossModLoader.getAllTanks(world, pos);
        return tanks != null && tanks.size() > 0 ? tanks.get(0) : null;
    }

    public static int getReactorHeat(World world, BlockPos pos) {
        for (CrossModBase crossMod : CROSS_MODS.values()) {
            int heat = crossMod.getReactorHeat(world, pos);
            if (heat == -1) continue;
            return heat;
        }
        return -1;
    }

    public static NBTTagCompound getInventoryData(TileEntity te) {
        for (CrossModBase crossMod : CROSS_MODS.values()) {
            NBTTagCompound tag = crossMod.getInventoryData(te);
            if (tag == null) continue;
            return tag;
        }
        IItemHandler storage = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (storage == null && !(te instanceof IInventory)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (storage != null) {
            int inUse = 0;
            int items = 0;
            tag.func_74768_a("size", storage.getSlots());
            for (int i = 0; i < Math.min(6, storage.getSlots()); ++i) {
                if (storage.getStackInSlot(i) != ItemStack.field_190927_a) {
                    ++inUse;
                    items += storage.getStackInSlot(i).func_190916_E();
                }
                tag.func_74782_a("slot" + Integer.toString(i), (NBTBase)storage.getStackInSlot(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74768_a("used", inUse);
            tag.func_74768_a("items", items);
        }
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            tag.func_74778_a("name", inv.func_70005_c_());
            tag.func_74757_a("sided", inv instanceof ISidedInventory);
            if (storage == null) {
                int inUse = 0;
                int items = 0;
                tag.func_74768_a("size", inv.func_70302_i_());
                for (int i = 0; i < Math.min(6, inv.func_70302_i_()); ++i) {
                    if (inv.func_70301_a(i) != ItemStack.field_190927_a) {
                        ++inUse;
                        items += inv.func_70301_a(i).func_190916_E();
                    }
                    tag.func_74782_a("slot" + Integer.toString(i), (NBTBase)inv.func_70301_a(i).func_77955_b(new NBTTagCompound()));
                }
                tag.func_74768_a("used", inUse);
                tag.func_74768_a("items", items);
            }
        }
        return tag;
    }

    public static void loadOreInfo() {
        for (CrossModBase crossMod : CROSS_MODS.values()) {
            crossMod.loadOreInfo();
        }
    }
}

