/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.multiblock.battery.tile.TileBattery;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.salt.MoltenSaltFissionLogic;
import nc.multiblock.fission.salt.tile.TileSaltFissionController;
import nc.multiblock.fission.solid.SolidFuelFissionLogic;
import nc.multiblock.fission.solid.tile.TileSolidFissionController;
import nc.tile.energyFluid.TileEnergyFluid;
import nc.tile.generator.TileDecayGenerator;
import nc.tile.generator.TileSolarPanel;
import nc.tile.internal.fluid.Tank;
import nc.tile.processor.TileFluidProcessor;
import nc.tile.processor.TileItemProcessor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class CrossNuclearCraftOverhauled
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TileBattery) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "RF");
            tag.func_74780_a("storage", (double)((TileBattery)te).getEnergyStored());
            tag.func_74780_a("maxStorage", (double)((TileBattery)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        for (int xoffset = -1; xoffset < 2; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -1; zoffset < 2; ++zoffset) {
                    TileEntity te = world.func_175625_s(pos.func_177965_g(xoffset).func_177981_b(yoffset).func_177970_e(zoffset));
                }
            }
        }
        return -1;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof TileEnergyFluid) {
            List tanks = ((TileEnergyFluid)te).getTanks();
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            for (Tank tank : tanks) {
                result.add(new FluidInfo((IFluidTank)tank));
            }
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(TileEntity te) {
        if (te instanceof TileDecayGenerator) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 1);
            tag.func_74768_a("stored", ((TileDecayGenerator)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileDecayGenerator)te).getMaxEnergyStored());
            tag.func_74768_a("output", ((TileDecayGenerator)te).getGenerated());
            tag.func_74780_a("radiation", ((TileDecayGenerator)te).getRadiation());
            return tag;
        }
        if (te instanceof TileItemProcessor) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74768_a("stored", ((TileItemProcessor)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileItemProcessor)te).getMaxEnergyStored());
            tag.func_74768_a("power", ((TileItemProcessor)te).getProcessPower());
            tag.func_74780_a("speedM", ((TileItemProcessor)te).getSpeedMultiplier());
            tag.func_74780_a("powerM", ((TileItemProcessor)te).getPowerMultiplier());
            tag.func_74768_a("time", ((TileItemProcessor)te).getProcessTime());
            return tag;
        }
        if (te instanceof TileFluidProcessor) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74768_a("stored", ((TileFluidProcessor)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileFluidProcessor)te).getMaxEnergyStored());
            tag.func_74768_a("power", ((TileFluidProcessor)te).getProcessPower());
            tag.func_74780_a("speedM", ((TileFluidProcessor)te).getSpeedMultiplier());
            tag.func_74780_a("powerM", ((TileFluidProcessor)te).getPowerMultiplier());
            tag.func_74768_a("time", ((TileFluidProcessor)te).getProcessTime());
            return tag;
        }
        if (te instanceof TileSolarPanel) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("stored", ((TileSolarPanel)te).getEnergyStored());
            tag.func_74768_a("capacity", ((TileSolarPanel)te).getMaxEnergyStored());
            tag.func_74768_a("output", ((TileSolarPanel)te).getGenerated());
            return tag;
        }
        if (te instanceof TileSolidFissionController) {
            FissionReactor reactor = (FissionReactor)((TileSolidFissionController)te).getMultiblock();
            SolidFuelFissionLogic logic = (SolidFuelFissionLogic)reactor.getLogic();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 8);
            tag.func_74757_a("active", reactor.isReactorOn);
            tag.func_74778_a("size", reactor.getInteriorLengthX() + "*" + reactor.getInteriorLengthY() + "*" + reactor.getInteriorLengthZ());
            tag.func_74768_a("clusterCount", reactor.clusterCount);
            tag.func_74780_a("meanEfficiency", reactor.meanEfficiency * 100.0);
            tag.func_74780_a("outputRate", logic.heatingOutputRateFP);
            tag.func_74780_a("sparsityEfficiencyMult", reactor.sparsityEfficiencyMult);
            tag.func_74768_a("temp", logic.getTemperature());
            tag.func_74772_a("rawHeating", reactor.rawHeating);
            tag.func_74772_a("heat", logic.getNetClusterHeating());
            tag.func_74778_a("level", String.format("%s / %s H", logic.heatBuffer.getHeatStored(), logic.heatBuffer.getHeatCapacity()));
            tag.func_74772_a("cooling", -reactor.cooling);
            return tag;
        }
        if (te instanceof TileSaltFissionController) {
            FissionReactor reactor = (FissionReactor)((TileSaltFissionController)te).getMultiblock();
            MoltenSaltFissionLogic logic = (MoltenSaltFissionLogic)reactor.getLogic();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 9);
            tag.func_74757_a("active", reactor.isReactorOn);
            tag.func_74778_a("size", reactor.getInteriorLengthX() + "*" + reactor.getInteriorLengthY() + "*" + reactor.getInteriorLengthZ());
            tag.func_74768_a("clusterCount", reactor.clusterCount);
            tag.func_74780_a("meanEfficiency", reactor.meanEfficiency * 100.0);
            tag.func_74780_a("sparsityEfficiencyMult", reactor.sparsityEfficiencyMult);
            tag.func_74768_a("temp", logic.getTemperature());
            tag.func_74772_a("rawHeating", reactor.rawHeating);
            tag.func_74772_a("heat", logic.getNetClusterHeating());
            tag.func_74778_a("level", String.format("%s / %s H", logic.heatBuffer.getHeatStored(), logic.heatBuffer.getHeatCapacity()));
            tag.func_74772_a("cooling", -reactor.cooling);
            return tag;
        }
        return null;
    }

    @Override
    public void loadOreInfo() {
        for (int i = 0; i < 8; ++i) {
            if (!NCConfig.ore_gen[i]) continue;
            EnergyControl.oreHelper.put(OreHelper.getId(NCBlocks.ore, i), new OreHelper(NCConfig.ore_min_height[i], NCConfig.ore_max_height[i], NCConfig.ore_size[i] + 2, NCConfig.ore_rate[i]));
        }
    }
}

