/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Loader;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.api.TechRebornAPI;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.tiles.fusionReactor.TileFusionControlComputer;
import techreborn.tiles.generator.TileCreativeSolarPanel;
import techreborn.tiles.generator.TileSolarPanel;
import techreborn.tiles.generator.TileSolidFuelGenerator;
import techreborn.tiles.generator.TileWaterMill;
import techreborn.tiles.generator.TileWindMill;
import techreborn.tiles.generator.fluid.TileFluidGenerator;

public class CrossTechReborn
extends CrossModBase {
    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "glassfiber": {
                return new ItemStack(TechRebornAPI.getBlock((String)"CABLE"), 1, 4);
            }
            case "carbon_plate": {
                return new ItemStack(TechRebornAPI.getItem((String)"PLATES"), 1, 2);
            }
            case "energy_crystal": {
                return new ItemStack(TechRebornAPI.getItem((String)"ENERGY_CRYSTAL"));
            }
            case "circuit": {
                return new ItemStack(TechRebornAPI.getItem((String)"PARTS"), 1, 29);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        return stack;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack) {
        if (Loader.isModLoaded((String)"ic2")) {
            return null;
        }
        return new PoweredItemContainerProvider(stack);
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyInterfaceTile) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyInterfaceTile storage = (IEnergyInterfaceTile)te;
            tag.func_74768_a("type", 12);
            tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
            if (PowerSystem.getDisplayPower() == PowerSystem.EnergySystem.EU) {
                tag.func_74780_a("storage", storage.getEnergy());
                tag.func_74780_a("maxStorage", storage.getMaxPower());
            } else {
                tag.func_74780_a("storage", storage.getEnergy() * (double)RebornCoreConfig.euPerFU);
                tag.func_74780_a("maxStorage", storage.getMaxPower() * (double)RebornCoreConfig.euPerFU);
            }
            return tag;
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(TileEntity te) {
        if (te instanceof TileFluidGenerator || te instanceof TileSolidFuelGenerator || te instanceof TileSolarPanel || te instanceof TileCreativeSolarPanel || te instanceof TileWaterMill || te instanceof TileWindMill || te instanceof TileFusionControlComputer) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            if (te instanceof TileFluidGenerator) {
                boolean active = ((TileFluidGenerator)te).isActive();
                tag.func_74768_a("type", 1);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                tag.func_74757_a("active", active);
                tag.func_74780_a("storage", ((TileFluidGenerator)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileFluidGenerator)te).getMaxPower());
                if (active) {
                    FluidStack stack = ((TileFluidGenerator)te).tank.getFluid();
                    if (stack == null) {
                        tag.func_74768_a("production", 0);
                    } else {
                        Fuel fuel = ((TileFluidGenerator)te).fuelHandler.findAndApply2(((TileFluidGenerator)te).tank.getFluid(), true);
                        double output = fuel.getEnergyOutput() / fuel.getEnergyPerTick() / (Math.ceil(fuel.getEnergyOutput() / fuel.getEnergyPerTick()) + 1.0);
                        tag.func_74780_a("production", fuel.getEnergyPerTick() * output);
                    }
                } else {
                    tag.func_74768_a("production", 0);
                }
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileSolidFuelGenerator) {
                boolean active = ((TileSolidFuelGenerator)te).isActive();
                tag.func_74768_a("type", 5);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                tag.func_74757_a("active", active);
                tag.func_74780_a("storage", ((TileSolidFuelGenerator)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileSolidFuelGenerator)te).getMaxPower());
                if (active) {
                    tag.func_74780_a("production", (double)TileSolidFuelGenerator.outputAmount);
                } else {
                    tag.func_74768_a("production", 0);
                }
                tag.func_74780_a("burnTime", (double)((TileSolidFuelGenerator)te).getBurnTime());
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileSolarPanel) {
                Field field = TileSolarPanel.class.getDeclaredField("powerToAdd");
                field.setAccessible(true);
                boolean active = (Integer)field.get(te) != 0;
                tag.func_74768_a("type", 1);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                tag.func_74757_a("active", active);
                tag.func_74780_a("storage", ((TileSolarPanel)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileSolarPanel)te).getMaxPower());
                if (active) {
                    tag.func_74780_a("production", ((TileSolarPanel)te).getMaxOutput());
                } else {
                    tag.func_74768_a("production", 0);
                }
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileCreativeSolarPanel) {
                tag.func_74768_a("type", 1);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                tag.func_74757_a("active", true);
                tag.func_74780_a("storage", ((TileCreativeSolarPanel)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileCreativeSolarPanel)te).getMaxPower());
                tag.func_74780_a("production", ((TileCreativeSolarPanel)te).getMaxOutput());
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileWaterMill) {
                tag.func_74768_a("type", 1);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                Field field = TileWaterMill.class.getDeclaredField("waterblocks");
                field.setAccessible(true);
                int water = (Integer)field.get(te);
                tag.func_74757_a("active", water != 0);
                tag.func_74780_a("storage", ((TileWaterMill)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileWaterMill)te).getMaxPower());
                tag.func_74780_a("production", (double)water * TileWaterMill.energyMultiplier);
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileWindMill) {
                tag.func_74768_a("type", 1);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                boolean active = te.func_174877_v().func_177956_o() > 64;
                tag.func_74757_a("active", active);
                tag.func_74780_a("storage", ((TileWindMill)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileWindMill)te).getMaxPower());
                if (!active) {
                    tag.func_74780_a("production", 0.0);
                } else if (te.func_145831_w().func_72911_I()) {
                    tag.func_74780_a("production", (double)TileWindMill.baseEnergy * TileWindMill.thunderMultiplier);
                } else {
                    tag.func_74780_a("production", (double)TileWindMill.baseEnergy);
                }
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
            if (te instanceof TileFusionControlComputer) {
                tag.func_74768_a("type", 6);
                tag.func_74778_a("euType", PowerSystem.getDisplayPower().abbreviation);
                tag.func_74757_a("active", ((TileFusionControlComputer)te).getState() == 2);
                switch (((TileFusionControlComputer)te).getState()) {
                    case -1: {
                        tag.func_74778_a("status", "");
                        break;
                    }
                    case 0: {
                        tag.func_74778_a("status", "No recipe");
                        break;
                    }
                    case 1: {
                        tag.func_74778_a("status", "Charging");
                        break;
                    }
                    case 2: {
                        tag.func_74778_a("status", "Crafting");
                    }
                }
                tag.func_74780_a("storage", ((TileFusionControlComputer)te).getEnergy());
                tag.func_74780_a("maxStorage", ((TileFusionControlComputer)te).getMaxPower());
                Field field = TileFusionControlComputer.class.getDeclaredField("currentRecipe");
                field.setAccessible(true);
                FusionReactorRecipe recipe = (FusionReactorRecipe)field.get(te);
                if (recipe == null) {
                    tag.func_74780_a("production", 0.0);
                } else {
                    tag.func_74780_a("production", recipe.getEuTick() * ((TileFusionControlComputer)te).getPowerMultiplier());
                }
                if (((TileFusionControlComputer)te).finalTickTime == 0) {
                    tag.func_74768_a("progress", 0);
                } else {
                    tag.func_74768_a("progress", (int)((double)((TileFusionControlComputer)te).crafingTickTime * 100.0 / (double)((TileFusionControlComputer)te).finalTickTime));
                }
                tag.func_74780_a("multiplier", ((TileFusionControlComputer)te).getPowerMultiplier());
                tag.func_74768_a("coilCount", ((TileFusionControlComputer)te).coilCount);
                if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                    tag.func_74780_a("storage", tag.func_74769_h("storage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("maxStorage", tag.func_74769_h("maxStorage") * (double)RebornCoreConfig.euPerFU);
                    tag.func_74780_a("production", tag.func_74769_h("production") * (double)RebornCoreConfig.euPerFU);
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof TileFluidGenerator) {
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            result.add(new FluidInfo((IFluidTank)((TileFluidGenerator)te).tank));
            return result;
        }
        return null;
    }
}

