/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import cofh.core.block.TileNameable;
import cofh.core.block.TilePowered;
import cofh.core.fluid.FluidTankCore;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyStorage;
import cofh.thermalexpansion.block.device.TileFluidBuffer;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.machine.TileBrewer;
import cofh.thermalexpansion.block.machine.TileInsolator;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.block.machine.TileSmelter;
import cofh.thermalexpansion.item.ItemAugment;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;

public class CrossThermalExpansion
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TilePowered) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = ((TilePowered)te).getEnergyStorage();
            if (storage != null) {
                tag.func_74778_a("euType", "RF");
                tag.func_74780_a("storage", (double)storage.getEnergyStored());
                tag.func_74780_a("maxStorage", (double)storage.getMaxEnergyStored());
                return tag;
            }
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(TileEntity te) {
        if (te instanceof TileDynamoBase) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "RF");
            if (te instanceof TileDynamoBase) {
                tag.func_74768_a("type", 1);
                IEnergyStorage storage = ((TileDynamoBase)te).getEnergyStorage();
                tag.func_74780_a("storage", (double)storage.getEnergyStored());
                tag.func_74780_a("maxStorage", (double)storage.getMaxEnergyStored());
                int production = ((TileDynamoBase)te).getInfoEnergyPerTick();
                tag.func_74757_a("active", ((TileDynamoBase)te).isActive);
                tag.func_74780_a("production", (double)production);
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        FluidTankCore tank;
        FluidTankCore tank1;
        FluidTankCore tank0;
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileDynamoCompression) {
            tank0 = ((TileDynamoCompression)te).getTank(0);
            tank1 = ((TileDynamoCompression)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileDynamoMagmatic) {
            tank0 = ((TileDynamoMagmatic)te).getTank(0);
            tank1 = ((TileDynamoMagmatic)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileRefinery) {
            tank0 = ((TileRefinery)te).getTank(0);
            tank1 = ((TileRefinery)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileBrewer) {
            tank0 = ((TileBrewer)te).getTank(0);
            tank1 = ((TileBrewer)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                return result;
            }
        }
        if (te instanceof TileFluidBuffer) {
            tank0 = ((TileFluidBuffer)te).getTank(0);
            tank1 = ((TileFluidBuffer)te).getTank(1);
            FluidTankCore tank2 = ((TileFluidBuffer)te).getTank(2);
            if (tank0 != null && tank1 != null && tank2 != null) {
                result.add(new FluidInfo((IFluidTank)tank0));
                result.add(new FluidInfo((IFluidTank)tank1));
                result.add(new FluidInfo((IFluidTank)tank2));
                return result;
            }
        }
        if (te instanceof TileNameable && (tank = ((TileNameable)te).getTank()) != null) {
            result.add(new FluidInfo((IFluidTank)tank));
            return result;
        }
        if (te instanceof TileDynamoBase && (tank = ((TileDynamoBase)te).getTank(0)) != null) {
            result.add(new FluidInfo((IFluidTank)tank));
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(TileEntity te) {
        try {
            if (te instanceof TileMachineBase) {
                NBTTagCompound tag = new NBTTagCompound();
                TileMachineBase machine = (TileMachineBase)te;
                tag.func_74768_a("type", 1);
                tag.func_74757_a("active", machine.isActive);
                tag.func_74768_a("usage", machine.getInfoEnergyPerTick());
                tag.func_74778_a("rsmode", machine.getControl().name());
                IEnergyStorage storage = machine.getEnergyStorage();
                if (storage != null) {
                    tag.func_74768_a("storage", storage.getEnergyStored());
                    tag.func_74768_a("maxStorage", storage.getMaxEnergyStored());
                }
                Field field = TileMachineBase.class.getDeclaredField("energyConfig");
                field.setAccessible(true);
                EnergyConfig energyConfig = (EnergyConfig)field.get(machine);
                tag.func_74778_a("power", String.format("%s-%s RF/t", energyConfig.minPower, energyConfig.maxPower));
                String augmentation = "";
                if (machine.getAugmentSlots().length == 0) {
                    augmentation = StringHelper.localize((String)"info.cofh.upgradeRequired");
                } else {
                    for (int i = 0; i < machine.getAugmentSlots().length; ++i) {
                        ItemStack stack = machine.getAugmentSlots()[i];
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAugment)) continue;
                        ItemAugment item = (ItemAugment)stack.func_77973_b();
                        augmentation = augmentation.equals("") ? StringHelper.localize((String)String.format("item.thermalexpansion.augment.%s.name", item.getAugmentIdentifier(stack))) : augmentation + "," + StringHelper.localize((String)String.format("item.thermalexpansion.augment.%s.name", item.getAugmentIdentifier(stack)));
                    }
                }
                tag.func_74778_a("augmentation", augmentation);
                if (te instanceof TileSmelter) {
                    tag.func_74768_a("type", 2);
                    if (((TileSmelter)machine).lockPrimary) {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.smelter.modeLocked"));
                    } else {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.smelter.modeUnlocked"));
                    }
                }
                if (te instanceof TileInsolator) {
                    tag.func_74768_a("type", 3);
                    if (((TileInsolator)machine).lockPrimary) {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.insolator.modeLocked"));
                    } else {
                        tag.func_74778_a("lock", StringHelper.localize((String)"gui.thermalexpansion.machine.insolator.modeUnlocked"));
                    }
                    FluidTankCore tank = ((TileInsolator)machine).getTank();
                    tag.func_74778_a("water", String.format("%s / %s mB", tank.getFluidAmount(), tank.getCapacity()));
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

