/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class IC2ReactorHelper {
    private static final double STEAM_PER_EU = 3.2;

    public static IReactor getReactorAround(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        IReactor reactor = IC2ReactorHelper.getReactorAt(world, pos);
        if (reactor != null) {
            return reactor;
        }
        return IC2ReactorHelper.getReactorNextBlock(world, pos);
    }

    private static IReactor getReactorNextBlock(World world, BlockPos pos) {
        EnumFacing dir;
        if (world == null) {
            return null;
        }
        IReactor reactor = null;
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        for (int i = 0; i < n && (reactor = IC2ReactorHelper.getReactorAt(world, pos.func_177972_a(dir = enumFacingArray[i]))) == null; ++i) {
        }
        return reactor;
    }

    public static IReactor getReactorAt(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof IReactor) {
            return (IReactor)entity;
        }
        if (entity instanceof IReactorChamber) {
            return ((IReactorChamber)entity).getReactorInstance();
        }
        return null;
    }

    public static IReactor getReactor3x3(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        for (int xoffset = -1; xoffset < 2; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -1; zoffset < 2; ++zoffset) {
                    TileEntity te = world.func_175625_s(pos.func_177965_g(xoffset).func_177981_b(yoffset).func_177970_e(zoffset));
                    if (te instanceof IReactor) {
                        return (IReactor)te;
                    }
                    if (!(te instanceof IReactorChamber)) continue;
                    return ((IReactorChamber)te).getReactorInstance();
                }
            }
        }
        return null;
    }

    public static BlockPos getTargetCoordinates(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactorAt(world, pos);
        if (reactor != null) {
            return reactor.getPosition();
        }
        return null;
    }

    public static BlockPos get5x5TargetCoordinates(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactor3x3(world, pos);
        if (reactor != null) {
            return reactor.getPosition();
        }
        return null;
    }

    public static int euToSteam(int eu) {
        return (int)Math.floor((double)eu * 3.2);
    }

    public static boolean isSteam(IReactor reactor) {
        return CrossModLoader.getCrossMod("ic2").isSteamReactor((TileEntity)reactor);
    }

    public static int getNuclearCellTimeLeft(ItemStack rStack) {
        return CrossModLoader.getCrossMod("ic2").getNuclearCellTimeLeft(rStack);
    }
}

