/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.gui.GuiPanelBase;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.gui.GuiBase;
import com.zuxelus.zlib.gui.controls.GuiTextArea;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCardText
extends GuiBase {
    private ICardReader reader;
    private ItemStack stack;
    private TileEntityInfoPanel panel;
    private GuiPanelBase parentGui;
    private int slot;
    private GuiTextArea textArea;
    private static final int lineCount = 10;

    public GuiCardText(ItemStack card, TileEntityInfoPanel panel, GuiPanelBase gui, int slot) {
        super("", 226, 146, "energycontrol:textures/gui/gui_text_card.png");
        this.reader = new ItemCardReader(card);
        this.stack = card;
        this.panel = panel;
        this.parentGui = gui;
        this.slot = slot;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiButton(1, this.guiLeft + this.xSize - 60 - 8, this.guiTop + 120, 60, 20, "Ok"));
        this.func_189646_b(new GuiButton(2, this.guiLeft + 8, this.guiTop + 120, 60, 20, "Style"));
        this.textArea = new GuiTextArea(this.field_146289_q, this.guiLeft + 8, this.guiTop + 5, this.xSize - 16, this.ySize - 35, 10);
        this.textArea.setFocused(true);
        String[] data = this.textArea.getText();
        for (int i = 0; i < 10; ++i) {
            data[i] = this.reader.getString("line_" + i);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        if (this.textArea != null) {
            this.textArea.drawTextBox();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textArea != null) {
            this.textArea.updateCursorCounter();
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                this.updateTextArea();
                break;
            }
            case 2: {
                this.textArea.writeText("@");
            }
        }
    }

    private void updateTextArea() {
        String[] lines;
        if (this.textArea != null && (lines = this.textArea.getText()) != null) {
            for (int i = 0; i < lines.length; ++i) {
                this.reader.setString("line_" + i, lines[i]);
            }
        }
        this.reader.updateServer(this.stack, this.panel, this.slot);
        this.field_146297_k.func_147108_a((GuiScreen)this.parentGui);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.textArea != null) {
            this.textArea.mouseClicked(mouseX, mouseY, mouseButton);
            this.textArea.setFocused(true);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && (this.textArea == null || !this.textArea.isFocused())) {
            this.updateTextArea();
        } else if (this.textArea != null && this.textArea.isFocused()) {
            this.textArea.textAreaKeyTyped(typedChar, keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

