/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.google.common.collect.Lists;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.containers.ContainerKitAssembler;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityKitAssembler;
import com.zuxelus.zlib.gui.GuiContainerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiKitAssembler
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_kit_assembler.png");
    private ContainerKitAssembler container;

    public GuiKitAssembler(ContainerKitAssembler container) {
        super(container, "tile.kit_assembler.name", TEXTURE);
        this.container = container;
        this.field_147000_g = 182;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Slot slot = this.container.func_75139_a(0);
        if (this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY) && slot.func_111238_b()) {
            this.renderInfoToolTip(slot, mouseX, mouseY);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
        if (this.func_146978_c(165, 16, 4, 52, mouseX, mouseY)) {
            this.func_146279_a(String.format("%d EU/%d EU", (int)((TileEntityKitAssembler)this.container.te).getEnergy(), 2000), mouseX, mouseY);
        }
    }

    private void renderInfoToolTip(Slot slot, int x, int y) {
        List<PanelString> data;
        ItemStack stack = slot.func_75211_c();
        if (!ItemCardMain.isCard(stack)) {
            return;
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List stackList = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list = Lists.newArrayList();
        if (stackList.size() > 0) {
            list.add(stackList.get(0));
        }
        if ((data = new ItemCardReader(stack).getAllData()) != null) {
            for (PanelString panelString : data) {
                if (panelString.textLeft == null) continue;
                list.add(TextFormatting.GRAY + panelString.textLeft);
            }
        }
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int productionWidth;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int energyHeight = ((TileEntityKitAssembler)this.container.te).getEnergyFactor();
        if (energyHeight > 0) {
            this.func_73729_b(this.field_147003_i + 165, this.field_147009_r + 16 + (52 - energyHeight), 176, 69 - energyHeight, 4, energyHeight);
        }
        if ((productionWidth = ((TileEntityKitAssembler)this.container.te).getProductionFactor()) > 0) {
            this.func_73729_b(this.field_147003_i + 86, this.field_147009_r + 35, 176, 0, productionWidth, 17);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
    }
}

