/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IReadOnlyCollection;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MEMonitorHandler;
import appeng.parts.CableBusContainer;
import appeng.parts.reporting.PartStorageMonitor;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileChest;
import appeng.tile.storage.TileDrive;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ITouchAction;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardAppEngInv
extends ItemCardBase
implements ITouchAction {
    public ItemCardAppEngInv() {
        super(27, "card_app_eng_inv");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        CableBusContainer cb;
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        ArrayList<ItemStack> stacks = reader.getItemStackList(true);
        if (stacks.size() < 1) {
            return CardState.OK;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof TileCableBus && (cb = ((TileCableBus)te).getCableBus()) != null) {
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IReadOnlyCollection gridList;
                IPart part = cb.getPart(side);
                if (!(part instanceof PartStorageMonitor)) continue;
                PartStorageMonitor monitor = (PartStorageMonitor)part;
                AENetworkProxy proxy = monitor.getProxy();
                if (proxy != null && proxy.getNode() != null && proxy.getNode().getGrid() != null && (gridList = proxy.getNode().getGrid().getNodes()) != null) {
                    for (IGridNode node : gridList) {
                        IGridHost host = node.getMachine();
                        if (host instanceof TileChest) {
                            ItemStack stack = ((TileChest)host).getCell();
                            this.updateValues(stack, stacks);
                            continue;
                        }
                        if (!(host instanceof TileDrive)) continue;
                        for (int i = 0; i < ((TileDrive)host).getInternalInventory().getSlots(); ++i) {
                            ItemStack stack = ((TileDrive)host).getInternalInventory().getStackInSlot(i);
                            this.updateValues(stack, stacks);
                        }
                    }
                }
                reader.setItemStackList(stacks);
                return CardState.OK;
            }
        }
        reader.setItemStackList(stacks);
        return CardState.NO_TARGET;
    }

    private void updateValues(ItemStack cell, ArrayList<ItemStack> stacks) {
        for (IStorageChannel channel : AEApi.instance().storage().storageChannels()) {
            ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(cell, null, channel);
            if (handler == null) continue;
            MEMonitorHandler monitor = new MEMonitorHandler((IMEInventoryHandler)handler);
            for (IAEStack st : monitor.getStorageList()) {
                if (st == null || !st.isItem()) continue;
                for (ItemStack stack : stacks) {
                    if (!st.asItemStackRepresentation().func_77969_a(stack)) continue;
                    stack.func_190920_e(stack.func_190916_E() + (int)st.getStackSize());
                }
            }
        }
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        NBTTagList list = reader.getTagList("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(stackTag);
            result.add(new PanelString(String.format("%s %d", StringUtils.getItemName(stack), stack.func_190916_E() - 1)));
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }

    @Override
    public boolean enableTouch(ItemStack stack) {
        return true;
    }

    @Override
    public boolean runTouchAction(World world, ICardReader reader, ItemStack current) {
        NBTTagList list = reader.getTagList("Items", 10);
        if (current.func_190926_b()) {
            if (list.func_74745_c() > 0) {
                list.func_74744_a(list.func_74745_c() - 1);
                reader.setTag("Items", (NBTBase)list);
                return true;
            }
            return false;
        }
        ArrayList<ItemStack> stacks = reader.getItemStackList(true);
        for (ItemStack stack : stacks) {
            if (!stack.func_77969_a(current)) continue;
            return false;
        }
        ItemStack item = current.func_77946_l();
        item.func_190920_e(1);
        list.func_74742_a((NBTBase)item.func_77955_b(new NBTTagCompound()));
        reader.setTag("Items", (NBTBase)list);
        return true;
    }

    @Override
    public void renderImage(TextureManager manager, ICardReader reader) {
    }
}

