/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardBigReactors
extends ItemCardBase {
    private static final DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardBigReactors() {
        super(24, "card_big_reactors");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.getCrossMod("bigreactors").getCardData(te);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        switch (reader.getInt("type")) {
            case 1: {
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCoreHeat", reader.getInt("heat").intValue(), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelCasingHeat", reader.getDouble("coreHeat"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelPassiveCooling", reader.getBoolean("cooling").toString(), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergyFE", reader.getString("storage"), showLabels));
                }
                if ((settings & 0x10) > 0) {
                    if (reader.getBoolean("cooling").booleanValue()) {
                        result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "FE/t", showLabels));
                    } else {
                        result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "mB/t", showLabels));
                    }
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelFuelmb", reader.getString("fuel"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelWastemb", reader.getDouble("waste"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelBurnupRatemb", reader.getDouble("consumption"), showLabels));
                }
                if ((settings & 0x40) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelFuelRods", reader.getDouble("rods"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
                break;
            }
            case 2: {
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelRotorSpeed", df.format(reader.getDouble("speed")), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelMaxSpeed", reader.getDouble("speedMax"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelRotorEfficiency", reader.getDouble("efficiency"), "%", showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getString("storage"), showLabels));
                }
                if ((settings & 0x10) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getDouble("output"), "FE/t", showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelBurnupRatemb", reader.getDouble("consumption"), showLabels));
                }
                if ((settings & 0x40) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelBlades", reader.getInt("blades").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelRotorMass", reader.getInt("mass").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
            }
        }
        if ((settings & 1) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("reactorPoweredB"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbFuel", (Object[])new Object[0]), 32));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOther", (Object[])new Object[0]), 64));
        return result;
    }
}

