/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardEngine
extends ItemCardBase {
    public ItemCardEngine() {
        super(9, "card_engine");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.getCrossMod("buildcraftcore").getCardData(te);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (reader.getInt("type") == 1) {
            result.add(new PanelString("msg.ec.InfoPanelOutputMJ", reader.getDouble("output"), showLabels));
            if ((settings & 1) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelHeat", reader.getDouble("heat"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelHeatPercentage", reader.getDouble("heatLevel"), showLabels));
            }
            if ((settings & 2) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelStorageMJ", reader.getDouble("power"), showLabels));
            }
            if ((settings & 4) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelPercentage", reader.getDouble("powerLevel"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelMaxStorageMJ", reader.getDouble("maxPower"), showLabels));
            }
            if ((settings & 8) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelSpeed", reader.getDouble("speed"), showLabels));
            }
        }
        if ((settings & 0x10) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMaxStorage", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelSpeed", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 16));
        return result;
    }
}

