/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.GalacticraftHelper;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemCardGalacticraft
extends ItemCardBase {
    private static DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardGalacticraft() {
        super(23, "card_galacticraft");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof TileEntityOxygenCollector) {
            reader.setInt("type", 1);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntityOxygenCollector)te));
            reader.setDouble("oxygenPerTick", (double)((TileEntityOxygenCollector)te).lastOxygenCollected * 20.0);
            reader.setInt("oxygenStored", ((TileEntityOxygenCollector)te).getOxygenStored());
            reader.setInt("oxygenCapacity", ((TileEntityOxygenCollector)te).getMaxOxygenStored());
            reader.setDouble("stored", Double.valueOf(((TileEntityOxygenCollector)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntityOxygenCollector)te).storage.getCapacityGC()));
            return CardState.OK;
        }
        if (te instanceof TileEntityOxygenSealer) {
            reader.setInt("type", 2);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntityOxygenSealer)te));
            reader.setDouble("oxygenPerTick", (double)((TileEntityOxygenSealer)te).oxygenPerTick * 20.0);
            reader.setString("thermalStatus", GalacticraftHelper.getThermalStatus((TileEntityOxygenSealer)te));
            reader.setInt("oxygenStored", ((TileEntityOxygenSealer)te).getOxygenStored());
            reader.setInt("oxygenCapacity", ((TileEntityOxygenSealer)te).getMaxOxygenStored());
            reader.setDouble("stored", Double.valueOf(((TileEntityOxygenSealer)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntityOxygenSealer)te).storage.getCapacityGC()));
            return CardState.OK;
        }
        if (te instanceof TileEntityOxygenDetector) {
            reader.setInt("type", 3);
            IBlockState state = world.func_180495_p(target);
            if (state != null && state.func_177230_c() instanceof BlockOxygenDetector) {
                reader.setBoolean("active", (Boolean)state.func_177229_b((IProperty)BlockOxygenDetector.ACTIVE));
                return CardState.OK;
            }
            return CardState.NO_TARGET;
        }
        if (te instanceof TileEntityRefinery) {
            TileEntityRefinery ref = (TileEntityRefinery)te;
            reader.setInt("type", 4);
            reader.setString("status", GalacticraftHelper.getStatus(ref));
            reader.setDouble("stored", Double.valueOf(ref.storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(ref.storage.getCapacityGC()));
            reader.setString("oilTank", String.format("%s / %s mB", ref.oilTank.getFluidAmount(), ref.oilTank.getCapacity()));
            reader.setString("fuelTank", String.format("%s / %s mB", ref.fuelTank.getFluidAmount(), ref.fuelTank.getCapacity()));
            return CardState.OK;
        }
        if (te instanceof TileEntityElectrolyzer) {
            TileEntityElectrolyzer el = (TileEntityElectrolyzer)te;
            reader.setInt("type", 5);
            reader.setString("status", GalacticraftHelper.getStatus(el));
            reader.setDouble("stored", Double.valueOf(el.storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(el.storage.getCapacityGC()));
            reader.setString("waterTank", String.format("%s / %s mB", el.waterTank.getFluidAmount(), el.waterTank.getCapacity()));
            reader.setString("gasTank1", String.format("%s / %s mB", el.liquidTank.getFluidAmount(), el.liquidTank.getCapacity()));
            reader.setString("gasTank2", String.format("%s / %s mB", el.liquidTank2.getFluidAmount(), el.liquidTank2.getCapacity()));
            return CardState.OK;
        }
        if (te instanceof TileEntityMethaneSynthesizer) {
            TileEntityMethaneSynthesizer meth = (TileEntityMethaneSynthesizer)te;
            reader.setInt("type", 6);
            reader.setString("status", GalacticraftHelper.getStatus(meth));
            reader.setDouble("stored", Double.valueOf(meth.storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(meth.storage.getCapacityGC()));
            reader.setString("methaneTank", String.format("%s / %s mB", meth.liquidTank.getFluidAmount(), meth.liquidTank.getCapacity()));
            reader.setString("gasTank1", String.format("%s / %s mB", meth.gasTank.getFluidAmount(), meth.gasTank.getCapacity()));
            reader.setString("gasTank2", String.format("%s / %s mB", meth.gasTank2.getFluidAmount(), meth.gasTank2.getCapacity()));
            int counter = 0;
            ItemStack stack = (ItemStack)meth.inventory.get(2);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAtmosphericValve) {
                counter = stack.func_190916_E();
            }
            reader.setInt("valve", counter);
            counter = 0;
            stack = (ItemStack)meth.inventory.get(3);
            if (!stack.func_190926_b()) {
                counter = stack.func_190916_E();
            }
            reader.setInt("items", counter);
            return CardState.OK;
        }
        if (te instanceof TileEntityGasLiquefier) {
            TileEntityGasLiquefier gas = (TileEntityGasLiquefier)te;
            reader.setInt("type", 7);
            reader.setString("status", GalacticraftHelper.getStatus(gas));
            reader.setDouble("stored", Double.valueOf(gas.storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(gas.storage.getCapacityGC()));
            reader.setString("gasTank", String.format("%s / %s mB", gas.gasTank.getFluidAmount(), gas.gasTank.getCapacity()));
            FluidStack liquid = gas.gasTank.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                reader.setString("gasTankName", liquid.getFluid().getUnlocalizedName());
            } else {
                reader.setString("gasTankName", "");
            }
            reader.setString("liquidTank", String.format("%s / %s mB", gas.liquidTank.getFluidAmount(), gas.liquidTank.getCapacity()));
            liquid = gas.liquidTank.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                reader.setString("liquidTankName", liquid.getFluid().getUnlocalizedName());
            } else {
                reader.setString("liquidTankName", "");
            }
            reader.setString("liquidTank2", String.format("%s / %s mB", gas.liquidTank2.getFluidAmount(), gas.liquidTank2.getCapacity()));
            liquid = gas.liquidTank2.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                reader.setString("liquidTank2Name", liquid.getFluid().getUnlocalizedName());
            } else {
                reader.setString("liquidTank2Name", "");
            }
            int counter = 0;
            ItemStack stack = (ItemStack)gas.inventory.get(1);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAtmosphericValve) {
                counter = stack.func_190916_E();
            }
            reader.setInt("valve", counter);
            return CardState.OK;
        }
        if (te instanceof TileEntityOxygenStorageModule) {
            reader.setInt("type", 8);
            reader.setInt("oxygenStored", ((TileEntityOxygenStorageModule)te).getOxygenStored());
            reader.setInt("oxygenCapacity", ((TileEntityOxygenStorageModule)te).getMaxOxygenStored());
            return CardState.OK;
        }
        if (te instanceof TileEntityEnergyStorageModule) {
            reader.setInt("type", 9);
            reader.setDouble("stored", Double.valueOf(((TileEntityEnergyStorageModule)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntityEnergyStorageModule)te).storage.getCapacityGC()));
            return CardState.OK;
        }
        if (te instanceof TileEntitySolar) {
            reader.setInt("type", 10);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntitySolar)te));
            reader.setDouble("stored", Double.valueOf(((TileEntitySolar)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntitySolar)te).storage.getCapacityGC()));
            reader.setInt("production", ((TileEntitySolar)te).generateWatts);
            reader.setDouble("boost", (double)Math.round((((TileEntitySolar)te).getSolarBoost() - 1.0f) * 1000.0f) / 10.0);
            reader.setDouble("sunVisible", (double)Math.round((float)((TileEntitySolar)te).solarStrength / 9.0f * 1000.0f) / 10.0);
            return CardState.OK;
        }
        if (te instanceof TileEntityLaunchController) {
            reader.setInt("type", 11);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntityLaunchController)te));
            reader.setDouble("stored", Double.valueOf(((TileEntityLaunchController)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntityLaunchController)te).storage.getCapacityGC()));
            reader.setInt("frequency", ((TileEntityLaunchController)te).frequency);
            reader.setInt("target", ((TileEntityLaunchController)te).destFrequency);
            return CardState.OK;
        }
        if (te instanceof TileEntitySolarArrayController) {
            reader.setInt("type", 12);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntitySolarArrayController)te));
            reader.setDouble("stored", Double.valueOf(((TileEntitySolarArrayController)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntitySolarArrayController)te).storage.getCapacityGC()));
            reader.setInt("production", ((TileEntitySolarArrayController)te).generateWatts);
            reader.setDouble("boost", (double)Math.round((((TileEntitySolarArrayController)te).getSolarBoost() - 1.0f) * 1000.0f) / 10.0);
            return CardState.OK;
        }
        if (te instanceof TileEntityOxygenDistributor) {
            reader.setInt("type", 13);
            reader.setString("status", GalacticraftHelper.getStatus((TileEntityOxygenDistributor)te));
            reader.setDouble("stored", Double.valueOf(((TileEntityOxygenDistributor)te).storage.getEnergyStoredGC()));
            reader.setDouble("capacity", Double.valueOf(((TileEntityOxygenDistributor)te).storage.getCapacityGC()));
            reader.setDouble("oxygenPerTick", (double)((TileEntityOxygenDistributor)te).oxygenPerTick * 20.0);
            reader.setInt("oxygenStored", ((TileEntityOxygenDistributor)te).getOxygenStored());
            reader.setInt("oxygenCapacity", ((TileEntityOxygenDistributor)te).getMaxOxygenStored());
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (!reader.hasField("type")) {
            return result;
        }
        int type = reader.getInt("type");
        if (type == 3) {
            if (reader.getBoolean("active").booleanValue()) {
                result.add(new PanelString("msg.ec.InfoPanelOxygenDetected", TextFormatting.GREEN + I18n.func_135052_a((String)"msg.ec.InfoPanelTrue", (Object[])new Object[0]), showLabels));
            } else {
                result.add(new PanelString("msg.ec.InfoPanelOxygenDetected", TextFormatting.RED + I18n.func_135052_a((String)"msg.ec.InfoPanelFalse", (Object[])new Object[0]), showLabels));
            }
            return result;
        }
        if (type == 8) {
            result.add(new PanelString("msg.ec.InfoPanelOxygen", String.format("%s / %s mB", reader.getInt("oxygenStored"), reader.getInt("oxygenCapacity")), showLabels));
            return result;
        }
        if (type < 8 || type > 9 && (settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelStatus", reader.getString("status"), showLabels));
        }
        if ((settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy", String.format("%s / %s gJ", df.format(reader.getDouble("stored")), df.format(reader.getDouble("capacity"))), showLabels));
        }
        switch (type) {
            case 1: {
                result.add(new PanelString("msg.ec.InfoPanelCollecting", reader.getDouble("oxygenPerTick"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOxygen", String.format("%s / %s mB", reader.getInt("oxygenStored"), reader.getInt("oxygenCapacity")), showLabels));
                break;
            }
            case 2: {
                result.add(new PanelString("msg.ec.InfoPanelOxygenUse", reader.getDouble("oxygenPerTick"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelThermalControl", reader.getString("thermalStatus"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOxygen", String.format("%s / %s mB", reader.getInt("oxygenStored"), reader.getInt("oxygenCapacity")), showLabels));
                break;
            }
            case 4: {
                result.add(new PanelString("msg.ec.InfoPanelOilTank", reader.getString("oilTank"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getString("fuelTank"), showLabels));
                break;
            }
            case 5: {
                result.add(new PanelString("msg.ec.InfoPanelWater", reader.getString("waterTank"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOxygen", reader.getString("gasTank1"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelHydrogen", reader.getString("gasTank2"), showLabels));
                break;
            }
            case 6: {
                result.add(new PanelString("msg.ec.InfoPanelAtmosphericValve", reader.getInt("valve").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelHydrogen", reader.getString("gasTank1"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCarbonDioxide", reader.getString("gasTank2"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelMethane", reader.getString("methaneTank"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelFragmentedCarbon", reader.getInt("items").intValue(), showLabels));
                break;
            }
            case 7: {
                if (!reader.getString("gasTankName").equals("")) {
                    result.add(new PanelString(I18n.func_135052_a((String)reader.getString("gasTankName"), (Object[])new Object[0]) + ": " + reader.getString("gasTank")));
                }
                result.add(new PanelString("msg.ec.InfoPanelAtmosphericValve", reader.getInt("valve").intValue(), showLabels));
                if (!reader.getString("liquidTankName").equals("")) {
                    result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTankName"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank")));
                }
                if (reader.getString("liquidTank2Name").equals("")) break;
                result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTank2Name"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank2")));
                break;
            }
            case 10: {
                result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getInt("production").intValue(), "gJ", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelEnvironmentalBoost", reader.getDouble("boost"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSunVisible", reader.getDouble("sunVisible"), showLabels));
                break;
            }
            case 11: {
                result.add(new PanelString("msg.ec.InfoPanelFrequency", reader.getInt("frequency").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelTarget", reader.getInt("target").intValue(), showLabels));
                break;
            }
            case 12: {
                result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getInt("production").intValue(), "gJ", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelEnvironmentalBoost", reader.getDouble("boost"), showLabels));
                break;
            }
            case 13: {
                result.add(new PanelString("msg.ec.InfoPanelOxygenUse", reader.getDouble("oxygenPerTick"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOxygen", String.format("%s / %s mB", reader.getInt("oxygenStored"), reader.getInt("oxygenCapacity")), showLabels));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(2);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbStatus", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        return result;
    }
}

