/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardGeneratorArray
extends ItemCardBase {
    private static final double STATUS_NOT_FOUND = -2.147483648E9;
    private static final double STATUS_OUT_OF_RANGE = -2.147483647E9;

    public ItemCardGeneratorArray() {
        super(12, "card_generator_array");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        int cardCount = reader.getCardCount();
        if (cardCount == 0) {
            return CardState.INVALID_CARD;
        }
        boolean foundAny = false;
        boolean outOfRange = false;
        for (int i = 0; i < cardCount; ++i) {
            BlockPos target = this.getCoordinates(reader, i);
            int dx = target.func_177958_n() - pos.func_177958_n();
            int dy = target.func_177956_o() - pos.func_177956_o();
            int dz = target.func_177952_p() - pos.func_177952_p();
            if (Math.abs(dx) <= range && Math.abs(dy) <= range && Math.abs(dz) <= range) {
                TileEntity entity = world.func_175625_s(target);
                NBTTagCompound tag = CrossModLoader.getCrossMod("ic2").getGeneratorData(entity);
                if (tag != null && tag.func_74764_b("type")) {
                    int type = tag.func_74762_e("type");
                    reader.setInt(String.format("_%dtype", i), type);
                    switch (type) {
                        case 1: {
                            reader.setDouble(String.format("_%dstorage", i), tag.func_74769_h("storage"));
                            reader.setDouble(String.format("_%dmaxStorage", i), tag.func_74769_h("maxStorage"));
                            reader.setDouble(String.format("_%dproduction", i), tag.func_74769_h("production"));
                            break;
                        }
                        case 2: {
                            reader.setDouble(String.format("_%dproduction", i), tag.func_74769_h("production"));
                        }
                    }
                    foundAny = true;
                    continue;
                }
                reader.setDouble(String.format("_%dproduction", i), -2.147483648E9);
                continue;
            }
            reader.setDouble(String.format("_%dproduction", i), -2.147483647E9);
            outOfRange = true;
        }
        if (!foundAny) {
            if (outOfRange) {
                return CardState.OUT_OF_RANGE;
            }
            return CardState.NO_TARGET;
        }
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double totalEnergy = 0.0;
        double totalStorage = 0.0;
        double totalOutput = 0.0;
        boolean showSummary = (displaySettings & 0x40) > 0;
        for (int i = 0; i < reader.getCardCount(); ++i) {
            boolean isNotFound;
            if (!reader.hasField(String.format("_%dtype", i))) continue;
            int type = reader.getInt(String.format("_%dtype", i));
            double energy = 0.0;
            double storage = 0.0;
            double output = 0.0;
            switch (type) {
                case 1: {
                    energy = reader.getDouble(String.format("_%dstorage", i));
                    storage = reader.getDouble(String.format("_%dmaxStorage", i));
                    output = reader.getDouble(String.format("_%dproduction", i));
                }
                case 2: {
                    output = reader.getDouble(String.format("_%dproduction", i));
                }
            }
            boolean isOutOfRange = output == -2.147483647E9;
            boolean bl = isNotFound = output == -2.147483648E9;
            if (showSummary && !isOutOfRange && !isNotFound) {
                totalEnergy += energy;
                totalStorage += storage;
                totalOutput += output;
            }
            if ((displaySettings & 0x20) <= 0) continue;
            if (isOutOfRange) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelOutOfRangeN", i + 1)));
                continue;
            }
            if (isNotFound) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelNotFoundN", i + 1)));
                continue;
            }
            if ((displaySettings & 1) > 0 && type == 1) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelStorageN", i + 1, StringUtils.getFormatted("", energy, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", energy, false)));
                }
            }
            if ((displaySettings & 2) > 0 && type == 1) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelMaxStorageN", i + 1, StringUtils.getFormatted("", storage, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", storage, false)));
                }
            }
            if ((displaySettings & 8) <= 0) continue;
            if (showLabels) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelOutputN", i + 1, StringUtils.getFormatted("", output, false))));
                continue;
            }
            result.add(new PanelString(StringUtils.getFormatted("", output, false)));
        }
        if (showSummary) {
            if ((displaySettings & 1) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelStorage", totalEnergy, showLabels));
            }
            if ((displaySettings & 2) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelMaxStorage", totalStorage, showLabels));
            }
            if ((displaySettings & 8) > 0) {
                result.add(new PanelString("msg.ec.InfoPanelOutput", totalOutput, showLabels));
            }
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMaxStorage", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEachCard", (Object[])new Object[0]), 32));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTotal", (Object[])new Object[0]), 64));
        return result;
    }

    @Override
    public boolean isRemoteCard() {
        return false;
    }
}

