/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardInventory
extends ItemCardBase {
    public ItemCardInventory() {
        super(15, "card_inventory");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.getInventoryData(te);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (isServer) {
            result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
        } else {
            result.add(new PanelString("msg.ec.InfoPanelName", I18n.func_135052_a((String)reader.getString("name"), (Object[])new Object[0]), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSidedInventory", reader.getBoolean("sided").toString(), showLabels));
            for (int i = 0; i < 6; ++i) {
                if (!reader.hasField("slot" + Integer.toString(i))) continue;
                ItemStack stack = new ItemStack(reader.getTag("slot" + Integer.toString(i)));
                result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", i + 1), StringUtils.getItemName(stack) + " x" + Integer.toString(stack.func_190916_E()), showLabels));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }
}

