/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.tileentities.TileEntityEnergyStorage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityEnergyCounter
extends TileEntityEnergyStorage {
    private static final int BASE_PACKET_SIZE = 32;
    private boolean init;
    protected int updateTicker;
    protected int tickRate;
    public double counter = 0.0;

    public TileEntityEnergyCounter() {
        super("tile.energy_counter.name", 1, 32, 64);
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        if (tag.func_74762_e("type") == 1 && tag.func_74764_b("value")) {
            this.counter = tag.func_74762_e("value");
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        if (tag.func_74762_e("type") == 1 && tag.func_74764_b("value")) {
            this.counter = tag.func_74769_h("value");
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.counter = tag.func_74769_h("counter");
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("counter", this.counter);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.init) {
            this.init = true;
            this.refreshData();
        }
    }

    @Override
    public void drawEnergy(double amount) {
        super.drawEnergy(amount);
        this.counter += amount;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.refreshData();
    }

    private void refreshData() {
        int upgradeCountTransormer = 0;
        ItemStack itemStack = this.func_70301_a(0);
        if (!itemStack.func_190926_b() && itemStack.func_77969_a(CrossModLoader.getCrossMod("ic2").getItemStack("transformer"))) {
            upgradeCountTransormer = itemStack.func_190916_E();
        }
        upgradeCountTransormer = Math.min(upgradeCountTransormer, 4);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.output = 32 * (int)Math.pow(4.0, upgradeCountTransormer);
            this.capacity = this.output * 2;
            this.tier = upgradeCountTransormer + 1;
            if (Info.isIc2Available()) {
                EnergyTileUnloadEvent event;
                if (this.addedToEnet) {
                    event = new EnergyTileUnloadEvent((IEnergyTile)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                }
                this.addedToEnet = false;
                event = new EnergyTileLoadEvent((IEnergyTile)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnet = true;
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack stack) {
        return stack.func_77969_a(CrossModLoader.getCrossMod("ic2").getItemStack("transformer"));
    }

    @Override
    public double getOfferedEnergy() {
        return this.allowEmit ? (this.energy >= (double)this.output ? (double)this.output : this.energy) : 0.0;
    }
}

