/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.blocks.RangeTrigger;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityRangeTrigger
extends TileEntityInventory
implements ITickable,
ISlotItemFilter,
ITilePacketHandler {
    public static final int SLOT_CARD = 0;
    public static final int SLOT_UPGRADE = 1;
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_PASSIVE = 1;
    private static final int STATE_ACTIVE = 2;
    protected int updateTicker = this.tickRate = EnergyControlConfig.rangeTriggerRefreshPeriod;
    protected int tickRate;
    protected boolean init = false;
    private int status = -1;
    private boolean poweredBlock;
    private boolean invertRedstone = false;
    public double levelStart = 0.0;
    public double levelEnd = 40000.0;

    public TileEntityRangeTrigger() {
        super("tile.range_trigger.name");
    }

    public boolean getInvertRedstone() {
        return this.invertRedstone;
    }

    public void setInvertRedstone(boolean value) {
        boolean old = this.invertRedstone;
        this.invertRedstone = value;
        if (!this.field_145850_b.field_72995_K && this.invertRedstone != old) {
            this.notifyBlockUpdate();
        }
    }

    public void setStatus(int value) {
        int old = this.status;
        this.status = value;
        if (!this.field_145850_b.field_72995_K && this.status != old) {
            IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            Block block = iblockstate.func_177230_c();
            if (block instanceof RangeTrigger) {
                IBlockState newState = block.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, iblockstate.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_177226_a(RangeTrigger.STATE, (Comparable)((Object)RangeTrigger.EnumState.getState(this.status)));
                this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            }
            this.notifyBlockUpdate();
        }
    }

    public void setLevelStart(double start) {
        if (!this.field_145850_b.field_72995_K && this.levelStart != start) {
            this.notifyBlockUpdate();
        }
        this.levelStart = start;
    }

    public void setLevelEnd(double end) {
        if (!this.field_145850_b.field_72995_K && this.levelEnd != end) {
            this.notifyBlockUpdate();
        }
        this.levelEnd = end;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean getPowered() {
        return this.poweredBlock;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.func_70296_d();
        }
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.setLevelStart(tag.func_74769_h("value"));
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.setInvertRedstone(tag.func_74762_e("value") == 1);
                break;
            }
            case 3: {
                if (!tag.func_74764_b("value")) break;
                this.setLevelEnd(tag.func_74769_h("value"));
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        tag.func_74757_a("poweredBlock", this.poweredBlock);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.invertRedstone = tag.func_74767_n("invert");
        this.levelStart = tag.func_74769_h("levelStart");
        this.levelEnd = tag.func_74769_h("levelEnd");
        if (tag.func_74764_b("poweredBlock")) {
            this.poweredBlock = tag.func_74767_n("poweredBlock");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74757_a("invert", this.invertRedstone);
        tag.func_74780_a("levelStart", this.levelStart);
        tag.func_74780_a("levelEnd", this.levelEnd);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        int status = 0;
        ItemStack card = this.func_70301_a(0);
        if (ItemCardMain.isCard(card)) {
            double cur;
            ItemCardReader reader = new ItemCardReader(card);
            CardState state = ItemCardMain.updateCardNBT(card, this.field_145850_b, this.field_174879_c, reader, this.func_70301_a(1));
            status = state == CardState.OK ? ((cur = reader.getDouble("storage").doubleValue()) > Math.max(this.levelStart, this.levelEnd) || cur < Math.min(this.levelStart, this.levelEnd) ? 2 : 1) : 0;
        }
        this.setStatus(status);
    }

    @Override
    public void notifyBlockUpdate() {
        boolean newValue;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof RangeTrigger)) {
            return;
        }
        boolean bl = this.status >= 1 && this.status == 1 != this.invertRedstone ? true : (newValue = false);
        if (this.poweredBlock != newValue) {
            this.poweredBlock = newValue;
            this.field_145850_b.func_175685_c(this.field_174879_c, block, false);
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack stack) {
        if (slotIndex == 0) {
            return stack.func_77973_b() instanceof ItemCardMain && (stack.func_77952_i() == 0 || stack.func_77952_i() == 10);
        }
        return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0;
    }
}

