/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.blocks.SeedAnalyzer;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import ic2.api.crops.ICropSeed;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntitySeedAnalyzer
extends TileEntityInventory
implements ITickable,
ITilePacketHandler,
ISlotItemFilter,
IEnergySink {
    public static final byte SLOT_IN = 0;
    public static final byte SLOT_OUT = 1;
    public static final byte SLOT_DISCHARGER = 2;
    private static final double CONSUMPTION = 5.0;
    public static final int TIER = 1;
    public static final int CAPACITY = 10000;
    public static final int[] COST_TO_UPGRADE = new int[]{10, 90, 900, 9000};
    private double energy = 0.0;
    private double production = 0.0;
    private int productionMax = 0;
    private boolean addedToEnet = false;
    private boolean active = false;

    public TileEntitySeedAnalyzer() {
        super("tile.seed_analyzer.name");
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getEnergyFactor() {
        return (int)Math.round(this.energy / 10000.0 * 14.0);
    }

    public double getProduction() {
        return this.production;
    }

    public int getProductionMax() {
        return this.productionMax;
    }

    public int getProductionFactor() {
        return (int)Math.round(this.production / (double)this.productionMax * 24.0);
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        if (tag.func_74762_e("type") == 1 && tag.func_74764_b("energy") && tag.func_74764_b("production") && tag.func_74764_b("productionMax")) {
            this.energy = tag.func_74769_h("energy");
            this.production = tag.func_74769_h("production");
            this.productionMax = tag.func_74762_e("productionMax");
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        tag.func_74757_a("active", this.active);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.updateActive();
        tag.func_74757_a("active", this.active);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("energy")) {
            this.energy = tag.func_74769_h("energy");
        }
        if (tag.func_74764_b("production")) {
            this.production = tag.func_74769_h("production");
        }
        if (tag.func_74764_b("productionMax")) {
            this.productionMax = tag.func_74762_e("productionMax");
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("energy", this.energy);
        tag.func_74780_a("production", this.production);
        tag.func_74768_a("productionMax", this.productionMax);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void onLoad() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    public void func_73660_a() {
        if (!this.addedToEnet) {
            this.onLoad();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.func_70301_a(2);
        if (!stack.func_190926_b() && this.energy < 10000.0 && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem ielectricitem = (IElectricItem)stack.func_77973_b();
            double old = this.energy;
            if (ielectricitem.canProvideEnergy(stack)) {
                this.energy += ElectricItem.manager.discharge(stack, 10000.0 - this.energy, 1, false, false, false);
            }
            if (old == 0.0 && this.energy >= 5.0) {
                this.updateState();
            }
        }
        if (!this.active) {
            return;
        }
        if (this.energy < 5.0) {
            this.energy = 0.0;
            this.production = 0.0;
            this.updateState();
            return;
        }
        if (this.productionMax > 0) {
            this.energy -= 5.0;
            this.production += 5.0;
            if (this.production >= (double)this.productionMax) {
                ItemStack seed = this.func_70301_a(0);
                ((ICropSeed)seed.func_77973_b()).incrementScannedFromStack(seed);
                this.func_70299_a(1, seed);
                this.func_70299_a(0, ItemStack.field_190927_a);
                this.production = 0.0;
                this.productionMax = 0;
                this.updateState();
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateState();
    }

    private void updateActive() {
        this.active = false;
        this.productionMax = 0;
        if (this.energy < 5.0) {
            return;
        }
        ItemStack out = this.func_70301_a(1);
        if (!out.func_190926_b()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b() || stack.func_77973_b() != CrossModLoader.getCrossMod("ic2").getItem("seed")) {
            return;
        }
        int level = ((ICropSeed)stack.func_77973_b()).getScannedFromStack(stack);
        if (level == 4) {
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, ItemStack.field_190927_a);
            IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
            return;
        }
        this.productionMax = COST_TO_UPGRADE[level];
        this.active = true;
    }

    private void updateState() {
        boolean old = this.active;
        this.updateActive();
        if (this.active == old) {
            return;
        }
        this.production = 0.0;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof SeedAnalyzer) || (Boolean)iblockstate.func_177229_b((IProperty)SeedAnalyzer.ACTIVE) == this.active) {
            return;
        }
        IBlockState newState = block.func_176223_P().func_177226_a((IProperty)SeedAnalyzer.field_185512_D, iblockstate.func_177229_b((IProperty)SeedAnalyzer.field_185512_D)).func_177226_a((IProperty)SeedAnalyzer.ACTIVE, (Comparable)Boolean.valueOf(this.active));
        this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return stack.func_77973_b() == CrossModLoader.getCrossMod("ic2").getItem("seed");
            }
            case 2: {
                return stack.func_77973_b() instanceof IElectricItem && ((IElectricItem)stack.func_77973_b()).getTier(stack) <= 1;
            }
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (slot != 0 || side != EnumFacing.UP) {
            return false;
        }
        return stack.func_77973_b() == CrossModLoader.getCrossMod("ic2").getItem("seed");
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (slot != 1 || side == EnumFacing.UP) {
            return false;
        }
        ItemStack crop = this.func_70301_a(slot);
        if (crop.func_190926_b() || crop.func_77973_b() != CrossModLoader.getCrossMod("ic2").getItem("seed")) {
            return false;
        }
        ICropSeed seed = (ICropSeed)crop.func_77973_b();
        if (side == EnumFacing.DOWN) {
            return seed.getScannedFromStack(crop) == 4;
        }
        return seed.getScannedFromStack(crop) < 4;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    public double getDemandedEnergy() {
        return Math.max(0.0, 10000.0 - this.energy);
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double old = this.energy;
        this.energy += amount;
        double left = 0.0;
        if (this.energy > 10000.0) {
            left = this.energy - 10000.0;
            this.energy = 10000.0;
        }
        if (this.energy >= 5.0 && old < 5.0 && !this.field_145850_b.field_72995_K) {
            this.updateState();
        }
        return left;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

