/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.blocks.RemoteThermo;
import com.zuxelus.energycontrol.blocks.ThermalMonitor;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityThermo
extends TileEntityInventory
implements ITickable,
ITilePacketHandler {
    private int heatLevel = 500;
    private boolean invertRedstone = false;
    protected int status = -1;
    private boolean poweredBlock;
    protected int updateTicker = 0;
    protected int tickRate = EnergyControlConfig.thermalMonitorRefreshPeriod;

    public TileEntityThermo() {
        super("tile.thermal_monitor.name");
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    public void setHeatLevel(int value) {
        int old = this.heatLevel;
        this.heatLevel = value;
        if (!this.field_145850_b.field_72995_K && this.heatLevel != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getInvertRedstone() {
        return this.invertRedstone;
    }

    public void setInvertRedstone(boolean value) {
        boolean old = this.invertRedstone;
        this.invertRedstone = value;
        if (!this.field_145850_b.field_72995_K && this.invertRedstone != old) {
            this.notifyBlockUpdate();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public boolean getPowered() {
        return this.poweredBlock;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.setHeatLevel(tag.func_74762_e("value"));
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.setInvertRedstone(tag.func_74762_e("value") == 1);
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        tag.func_74768_a("status", this.status);
        tag.func_74757_a("poweredBlock", this.poweredBlock);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("heatLevel")) {
            this.heatLevel = tag.func_74762_e("heatLevel");
        }
        if (tag.func_74764_b("invert")) {
            this.invertRedstone = tag.func_74767_n("invert");
        }
        if (tag.func_74764_b("status")) {
            this.setStatus(tag.func_74762_e("status"));
        }
        if (tag.func_74764_b("poweredBlock")) {
            this.poweredBlock = tag.func_74767_n("poweredBlock");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("heatLevel", this.heatLevel);
        tag.func_74757_a("invert", this.invertRedstone);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void func_145843_s() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateTicker-- > 0) {
            return;
        }
        this.updateTicker = this.tickRate;
        this.checkStatus();
    }

    protected void checkStatus() {
        int newStatus;
        int heat = CrossModLoader.getReactorHeat(this.field_145850_b, this.field_174879_c);
        int n = heat == -1 ? -2 : (newStatus = heat >= this.heatLevel ? 1 : 0);
        if (newStatus != this.status) {
            this.status = newStatus;
            this.notifyBlockUpdate();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        }
    }

    @Override
    public void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (block instanceof ThermalMonitor || block instanceof RemoteThermo) {
            boolean newValue;
            boolean bl = this.status < 0 ? false : (this.status == 1 ? !this.invertRedstone : (newValue = this.invertRedstone));
            if (this.poweredBlock != newValue) {
                this.poweredBlock = newValue;
                this.field_145850_b.func_175685_c(this.field_174879_c, block, false);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
        }
    }

    @Override
    protected boolean hasRotation() {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

