/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.OreberriesMod;
import josephcsible.oreberries.config.OreberryConfig;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenOreberryBush
extends WorldGenerator {
    public final OreberryConfig oreberryConfig;
    private final IBlockState newState;
    private final Set<Block> replaceBlocks = new HashSet<Block>();

    public WorldGenOreberryBush(BlockOreberryBush block) {
        this.newState = block.func_176223_P().func_177226_a((IProperty)BlockOreberryBush.AGE, (Comparable)Integer.valueOf(3));
        this.oreberryConfig = block.config;
        for (String blockName : block.config.replaceBlocks) {
            Block replaceBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
            if (replaceBlock == Blocks.field_150350_a) {
                OreberriesMod.logger.warn("Oreberry bush {} has unknown replacement block {}", (Object)this.oreberryConfig.name, (Object)blockName);
                continue;
            }
            this.replaceBlocks.add(replaceBlock);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int type = random.nextInt(this.oreberryConfig.sizeChance);
        if (type == 11) {
            this.generateMediumNode(world, random, pos);
        } else if (type >= 5) {
            this.generateSmallNode(world, random, pos);
        } else {
            this.generateTinyNode(world, random, pos);
        }
        return true;
    }

    public void generateMediumNode(World world, Random random, BlockPos pos) {
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int yPos = -1; yPos <= 1; ++yPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (random.nextInt(4) != 0) continue;
                    this.generateBerryBlock(world, pos.func_177982_a(xPos, yPos, zPos));
                }
            }
        }
        this.generateSmallNode(world, random, pos);
    }

    public void generateSmallNode(World world, Random random, BlockPos pos) {
        this.generateBerryBlock(world, pos);
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, pos.func_177974_f());
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, pos.func_177976_e());
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, pos.func_177968_d());
        }
        if (random.nextBoolean()) {
            this.generateBerryBlock(world, pos.func_177978_c());
        }
        if (random.nextInt(4) != 0) {
            this.generateBerryBlock(world, pos.func_177984_a());
        }
    }

    public void generateTinyNode(World world, Random random, BlockPos pos) {
        this.generateBerryBlock(world, pos);
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, pos.func_177974_f());
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, pos.func_177976_e());
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, pos.func_177968_d());
        }
        if (random.nextInt(4) == 0) {
            this.generateBerryBlock(world, pos.func_177978_c());
        }
        if (random.nextInt(16) < 7) {
            this.generateBerryBlock(world, pos.func_177984_a());
        }
    }

    void generateBerryBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (world.func_175623_d(pos) || state.func_185887_b(world, pos) >= 0.0f && !state.func_185913_b() || state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, s -> this.replaceBlocks.contains(s.func_177230_c()))) {
            world.func_180501_a(pos, this.newState, 2);
        }
    }
}

