/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTurkey
extends Block {
    public static final PropertyInteger BITES = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)3);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB[] X_AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.1875, 0.875, 0.4375, 0.8125), new AxisAlignedBB(0.125, 0.0, 0.1875, 0.875, 0.4375, 0.8125), new AxisAlignedBB(0.125, 0.0, 0.1875, 0.875, 0.4375, 0.8125), new AxisAlignedBB(0.125, 0.0, 0.1875, 0.875, 0.4375, 0.75), new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 0.4375, 0.75), new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 0.3125, 0.75), new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 0.1875, 0.75), new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 0.125, 0.75)};
    protected static final AxisAlignedBB[] Y_AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.125, 0.8125, 0.4375, 0.875), new AxisAlignedBB(0.1875, 0.0, 0.125, 0.8125, 0.4375, 0.875), new AxisAlignedBB(0.1875, 0.0, 0.125, 0.8125, 0.4375, 0.875), new AxisAlignedBB(0.25, 0.0, 0.125, 0.8125, 0.4375, 0.875), new AxisAlignedBB(0.25, 0.0, 0.125, 0.75, 0.4375, 0.875), new AxisAlignedBB(0.25, 0.0, 0.125, 0.75, 0.3125, 0.875), new AxisAlignedBB(0.25, 0.0, 0.125, 0.75, 0.1875, 0.875), new AxisAlignedBB(0.25, 0.0, 0.125, 0.75, 0.125, 0.875)};
    protected BlockTurkey secondPart;

    public BlockTurkey(String name) {
        super(Material.field_151583_m);
        this.setRegistryName("betteranimalsplus", name);
        this.func_149663_c("betteranimalsplus." + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockTurkey(String name, BlockTurkey secondPart) {
        this(name);
        this.secondPart = secondPart;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? X_AABBS[(Integer)state.func_177229_b((IProperty)BITES) + (this.secondPart == null ? 4 : 0)] : Y_AABBS[(Integer)state.func_177229_b((IProperty)BITES) + (this.secondPart == null ? 4 : 0)];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return this.eat(worldIn, pos, state, playerIn);
        }
        ItemStack itemstack = playerIn.func_184586_b(hand);
        return this.eat(worldIn, pos, state, playerIn) || itemstack.func_190926_b();
    }

    protected boolean eat(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_71043_e(false)) {
            return false;
        }
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (this.secondPart != null && i < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            if (i < 2) {
                player.func_71024_bL().func_75122_a(2, 0.3f);
            } else {
                player.func_71024_bL().func_75122_a(4, 0.3f);
            }
        } else if (this.secondPart != null && i == 3) {
            worldIn.func_175656_a(pos, this.secondPart.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
            player.func_71024_bL().func_75122_a(4, 0.3f);
        } else if (this.secondPart == null && i < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            player.func_71024_bL().func_75122_a(4, 0.3f);
        } else {
            worldIn.func_175698_g(pos);
            player.func_71024_bL().func_75122_a(4, 0.3f);
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? BlockTurkey.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!BlockTurkey.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private static boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)((meta >> 2 & 3) + 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() - 2 << 2 | (Integer)state.func_177229_b((IProperty)BITES);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BITES, FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)BITES) == 0 && this.secondPart != null) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }
}

