/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicate;
import its_meow.betteranimalsplus.common.entity.EntityWaterCreatureWithTypes;
import its_meow.betteranimalsplus.common.entity.ai.EntityAIWanderWaterEntity;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityEelBase
extends EntityWaterCreatureWithTypes {
    private static final Predicate<EntityItem> ITEM_SELECTOR = item -> !item.func_174874_s() && !item.field_70128_L && item.func_92059_d().func_77973_b() instanceof ItemFood;
    private int collideWithItemTicks = 0;
    private EntityItem collidedItem = null;

    public EntityEelBase(World worldIn) {
        super(worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee(this, 0.8, false){

            public boolean func_75253_b() {
                if (EntityEelBase.this.shouldCheckTarget() && EntityEelBase.this.func_70638_az() != null && !EntityEelBase.isHoldingFood(EntityEelBase.this.func_70638_az())) {
                    EntityEelBase.this.func_70624_b(null);
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MoveToFoodItemsGoal());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderWaterEntity((EntityLiving)this, 0.5, 1));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, EntityEelBase::isHoldingFood));
    }

    protected boolean shouldCheckTarget() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List items = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ().func_186662_g(0.4), ITEM_SELECTOR);
        if (items.size() > 0 && (this.collidedItem == null || items.contains(this.collidedItem))) {
            if (this.collidedItem == null) {
                this.collidedItem = (EntityItem)items.get(this.func_70681_au().nextInt(items.size()));
            }
            ++this.collideWithItemTicks;
            if (this.collideWithItemTicks > 35) {
                if (this.func_70681_au().nextFloat() < 0.1f) {
                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
                if (this.collideWithItemTicks > 40 && this.func_70681_au().nextInt(20) == 0) {
                    this.collideWithItemTicks = 0;
                    EntityItem item = this.collidedItem;
                    ItemStack stack = item.func_92059_d();
                    if (stack.func_77973_b() instanceof ItemFood) {
                        this.func_70691_i(((ItemFood)stack.func_77973_b()).func_150906_h(stack));
                        item.func_70106_y();
                        this.collidedItem = null;
                        this.collideWithItemTicks = 0;
                    }
                }
            }
        } else {
            this.collideWithItemTicks = 0;
            this.collidedItem = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack stack;
            if (this.collidedItem != null && !(stack = this.collidedItem.func_92059_d()).func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    if (stack.func_77981_g()) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + this.func_70040_Z().field_72450_a / 2.0, this.field_70163_u, this.field_70161_v + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
                        continue;
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + this.func_70040_Z().field_72450_a / 2.0, this.field_70163_u, this.field_70161_v + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    protected static boolean isHoldingFood(EntityLivingBase entity) {
        return entity.func_184614_ca().func_77973_b() instanceof ItemFood || entity.func_184592_cb().func_77973_b() instanceof ItemFood;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.EELY;
    }

    public class MoveToFoodItemsGoal
    extends EntityAIBase {
        public MoveToFoodItemsGoal() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityEelBase.this.func_70638_az() == null && EntityEelBase.this.func_70643_av() == null) {
                if (EntityEelBase.this.func_70681_au().nextInt(2) != 0) {
                    return false;
                }
                List list = EntityEelBase.this.field_70170_p.func_175647_a(EntityItem.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty();
            }
            return false;
        }

        public void func_75246_d() {
            List list = EntityEelBase.this.field_70170_p.func_175647_a(EntityItem.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = EntityEelBase.this.field_70170_p.func_175647_a(EntityItem.class, EntityEelBase.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

