/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import its_meow.betteranimalsplus.common.entity.ai.BreatheAirGoal;
import its_meow.betteranimalsplus.common.entity.ai.WalkAndSwimNodeProcessor;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWalrus
extends EntityAnimal {
    private static final DataParameter<BlockPos> HOME_POS = EntityDataManager.func_187226_a(EntityWalrus.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> TRAVEL_POS = EntityDataManager.func_187226_a(EntityWalrus.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> GOING_HOME = EntityDataManager.func_187226_a(EntityWalrus.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TRAVELLING = EntityDataManager.func_187226_a(EntityWalrus.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean hasGivenDisc = false;

    public EntityWalrus(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 1.25f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && !this.hasGivenDisc && stack.func_77973_b() == ModItems.FRIED_EGG) {
            this.func_175505_a(player, stack);
            this.field_70170_p.func_72960_a((Entity)this, (byte)90);
            this.hasGivenDisc = true;
            this.func_70099_a(new ItemStack((Item)ModItems.RECORD_WALRUS), 0.5f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 90) {
            for (int i = 0; i < 7; ++i) {
                double x = this.field_70146_Z.nextGaussian() * 0.02;
                double y = this.field_70146_Z.nextGaussian() * 0.02;
                double z = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.NOTE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, x, y, z, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(this.func_70681_au().nextInt(3) == 0 ? DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h() : DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b());
        if (flag) {
            Vec3d pos = this.func_174791_d();
            Vec3d targetPos = entityIn.func_174791_d();
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 0.5f, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
        }
        return flag;
    }

    public void setHome(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POS, (Object)position);
    }

    private BlockPos getHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POS);
    }

    private void setTravelPos(BlockPos position) {
        this.field_70180_af.func_187227_b(TRAVEL_POS, (Object)position);
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TRAVEL_POS);
    }

    private boolean isGoingHome() {
        return (Boolean)this.field_70180_af.func_187225_a(GOING_HOME);
    }

    private void setGoingHome(boolean isGoingHome) {
        this.field_70180_af.func_187227_b(GOING_HOME, (Object)isGoingHome);
    }

    private boolean isTravelling() {
        return (Boolean)this.field_70180_af.func_187225_a(TRAVELLING);
    }

    private void setTravelling(boolean isTravelling) {
        this.field_70180_af.func_187227_b(TRAVELLING, (Object)isTravelling);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOME_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(TRAVEL_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(GOING_HOME, (Object)false);
        this.field_70180_af.func_187214_a(TRAVELLING, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("HomePosX", this.getHome().func_177958_n());
        compound.func_74768_a("HomePosY", this.getHome().func_177956_o());
        compound.func_74768_a("HomePosZ", this.getHome().func_177952_p());
        compound.func_74768_a("TravelPosX", this.getTravelPos().func_177958_n());
        compound.func_74768_a("TravelPosY", this.getTravelPos().func_177956_o());
        compound.func_74768_a("TravelPosZ", this.getTravelPos().func_177952_p());
        compound.func_74757_a("DiscGiven", this.hasGivenDisc);
    }

    public void func_70037_a(NBTTagCompound compound) {
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        this.setHome(new BlockPos(i, j, k));
        super.func_70037_a(compound);
        int l = compound.func_74762_e("TravelPosX");
        int i1 = compound.func_74762_e("TravelPosY");
        int j1 = compound.func_74762_e("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
        this.hasGivenDisc = compound.func_74767_n("DiscGiven");
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setHome(new BlockPos((Entity)this));
        this.setTravelPos(BlockPos.field_177992_a);
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_70601_bi() {
        return this.func_180425_c().func_177956_o() < this.field_70170_p.func_181545_F() + 4 && this.field_70170_p.func_175721_c(this.func_180425_c(), true) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new BreatheAirGoal((EntityCreature)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GoHomeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new TravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false){

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + attackTarget.field_70130_N;
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new WanderGoal(this, 1.0, 100));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return false;
    }

    public void func_70050_g(int air) {
        if (air == 300 && this.field_70170_p != null && this.isAddedToWorld() && this.field_70170_p.field_72996_f.contains((Object)this) && !this.func_70055_a(Material.field_151586_h)) {
            super.func_70050_g(6000);
        } else {
            super.func_70050_g(air);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 0.6f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new Navigator(this, worldIn);
    }

    public float func_184643_a(PathNodeType nodeType) {
        if (!this.isGoingHome() && nodeType == PathNodeType.WATER) {
            return 10.0f;
        }
        return super.func_184643_a(nodeType);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
            if (!(this.func_70638_az() != null || this.isGoingHome() && this.withinDistanceFromHome(20.0))) {
                this.field_70181_x -= 0.05;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.WALRUS;
    }

    public boolean withinDistanceFromHome(double distance) {
        return Math.sqrt(this.getHome().func_177951_i((Vec3i)this.func_180425_c())) <= distance;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected boolean func_70692_ba() {
        return ModEntities.entityMap.containsKey("walrus") ? ModEntities.entityMap.get((Object)"walrus").despawn && !this.func_145818_k_() : false;
    }

    public static class WanderGoal
    extends EntityAIWander {
        private final EntityWalrus walrus;

        public WanderGoal(EntityWalrus walrus, double speed, int chance) {
            super((EntityCreature)walrus, speed, chance);
            this.walrus = walrus;
        }

        public boolean func_75250_a() {
            return !this.walrus.func_70090_H() && !this.walrus.isGoingHome() && super.func_75250_a();
        }
    }

    public static class TravelGoal
    extends EntityAIBase {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;

        public TravelGoal(EntityWalrus walrus, double speed) {
            this.walrus = walrus;
            this.speed = speed;
        }

        public boolean func_75250_a() {
            return !this.walrus.isGoingHome() && this.walrus.func_70090_H();
        }

        public void func_75249_e() {
            int xzRange = 512;
            int yRange = 4;
            Random random = this.walrus.field_70146_Z;
            int xOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            int yOff = random.nextInt(yRange * 2 + 1) - yRange;
            int zOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            if ((double)yOff + this.walrus.field_70163_u > (double)(this.walrus.field_70170_p.func_181545_F() - 1)) {
                yOff = 0;
            }
            BlockPos blockpos = new BlockPos((double)xOff + this.walrus.field_70165_t, (double)yOff + this.walrus.field_70163_u, (double)zOff + this.walrus.field_70161_v);
            this.walrus.setTravelPos(blockpos);
            this.walrus.setTravelling(true);
            this.noPosition = false;
        }

        public void func_75246_d() {
            if (this.walrus.func_70661_as().func_75500_f()) {
                int z;
                int range;
                int x;
                BlockPos blockpos = this.walrus.getTravelPos();
                Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.walrus, (int)16, (int)3, (Vec3d)new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.walrus, (int)8, (int)7, (Vec3d)new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (vec3d != null && !this.walrus.field_70170_p.func_175706_a(new BlockPos((x = MathHelper.func_76128_c((double)vec3d.field_72450_a)) - (range = 34), 0, (z = MathHelper.func_76128_c((double)vec3d.field_72449_c)) - range), new BlockPos(x + range, 0, z + range), true)) {
                    vec3d = null;
                }
                if (vec3d == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
            }
        }

        public boolean func_75253_b() {
            return !this.walrus.func_70661_as().func_75500_f() && !this.noPosition && !this.walrus.isGoingHome();
        }

        public void func_75251_c() {
            this.walrus.setTravelling(false);
            super.func_75251_c();
        }
    }

    public static class Navigator
    extends PathNavigateSwimmer {
        public Navigator(EntityWalrus walrus, World world) {
            super((EntityLiving)walrus, world);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a() {
            return new PathFinder((NodeProcessor)new WalkAndSwimNodeProcessor());
        }

        public boolean func_188555_b(BlockPos pos) {
            EntityWalrus walrus;
            if (this.field_75515_a instanceof EntityWalrus && (walrus = (EntityWalrus)this.field_75515_a).isTravelling()) {
                return this.field_75513_b.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
            }
            return !this.field_75513_b.func_175623_d(pos.func_177977_b());
        }
    }

    static class MoveHelperController
    extends EntityMoveHelper {
        private final EntityWalrus walrus;

        MoveHelperController(EntityWalrus walrus) {
            super((EntityLiving)walrus);
            this.walrus = walrus;
        }

        private void updateSpeed() {
            if (this.walrus.func_70090_H()) {
                this.walrus.field_70181_x += 0.05;
                if (!this.walrus.withinDistanceFromHome(16.0)) {
                    this.walrus.func_70659_e(Math.max(this.walrus.func_70689_ay() / 2.0f, 0.2f));
                }
            } else if (this.walrus.field_70122_E) {
                this.walrus.func_70659_e(Math.max(this.walrus.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.walrus.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.walrus.field_70165_t;
                double d1 = this.field_75647_c - this.walrus.field_70163_u;
                double d2 = this.field_75644_d - this.walrus.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.walrus.field_70761_aq = this.walrus.field_70177_z = this.func_75639_a(this.walrus.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.walrus.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.walrus.func_70659_e(MoveHelperController.lerp(0.125f, this.walrus.func_70689_ay(), f1));
                this.walrus.field_70181_x += (double)this.walrus.func_70689_ay() * (d1 /= d3) * 0.1;
            } else {
                this.walrus.func_70659_e(0.0f);
            }
        }

        public static float lerp(float pct, float start, float end) {
            return start + pct * (end - start);
        }
    }

    public static class GoToWaterGoal
    extends EntityAIMoveToBlock {
        private final EntityWalrus walrus;
        private boolean isAboveDestination2;
        private int timeoutCounter2;
        private double speed;

        public GoToWaterGoal(EntityWalrus walrus, double speed) {
            super((EntityCreature)walrus, speed, 24);
            this.walrus = walrus;
            this.speed = speed;
        }

        public boolean func_75253_b() {
            return !this.walrus.func_70090_H() && this.timeoutCounter2 <= 1200 && this.func_179488_a(this.walrus.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.walrus.func_70631_g_() && !this.walrus.func_70090_H()) {
                return this.shouldExecute2();
            }
            return !this.walrus.isGoingHome() && !this.walrus.func_70090_H() && this.shouldExecute2();
        }

        public boolean shouldExecute2() {
            if (this.field_179496_a > 0) {
                --this.field_179496_a;
                return false;
            }
            this.field_179496_a = 200 + this.walrus.func_70681_au().nextInt(200);
            return this.searchForDestination2();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.timeoutCounter2 = 0;
        }

        private boolean searchForDestination2() {
            int i = 24;
            BlockPos blockpos = new BlockPos((Entity)this.walrus);
            int k = -1;
            while (k <= 1) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                            if (this.walrus.func_180485_d(blockpos1) && this.func_179488_a(this.walrus.field_70170_p, blockpos1)) {
                                this.field_179494_b = blockpos1;
                                return true;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.walrus.func_174831_c(this.field_179494_b.func_177984_a()) > 1.0) {
                this.isAboveDestination2 = false;
                ++this.timeoutCounter2;
                if (this.timeoutCounter2 % 160 == 0) {
                    this.walrus.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.speed);
                }
            } else {
                this.isAboveDestination2 = true;
                --this.timeoutCounter2;
            }
        }

        protected boolean func_179487_f() {
            return this.isAboveDestination2;
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_150355_j;
        }
    }

    public static class GoHomeGoal
    extends EntityAIBase {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;
        private int ticksRan;

        public GoHomeGoal(EntityWalrus walrus, double speedIn) {
            this.walrus = walrus;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            if (this.walrus.func_70631_g_()) {
                return false;
            }
            if (this.walrus.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return !this.walrus.withinDistanceFromHome(64.0);
        }

        public void func_75249_e() {
            this.walrus.setGoingHome(true);
            this.noPosition = false;
            this.ticksRan = 0;
        }

        public void func_75251_c() {
            this.walrus.setGoingHome(false);
        }

        public boolean func_75253_b() {
            return !this.walrus.withinDistanceFromHome(7.0) && !this.noPosition && this.ticksRan <= 600;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.walrus.getHome();
            boolean nearHome = this.walrus.withinDistanceFromHome(16.0);
            if (nearHome) {
                ++this.ticksRan;
            }
            if (this.walrus.func_70661_as().func_75500_f()) {
                Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.walrus, (int)16, (int)3, (Vec3d)new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.walrus, (int)8, (int)7, (Vec3d)new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (vec3d != null && !nearHome && this.walrus.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_177230_c() != Blocks.field_150355_j) {
                    vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.walrus, (int)16, (int)5, (Vec3d)new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()));
                }
                if (vec3d == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
            }
        }
    }
}

