/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.fixers;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;

public class HeadTileDataFixer
implements IFixableData {
    private static Map<String, HeadTypes> headIDs = new HashMap<String, HeadTypes>();

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String id = compound.func_74779_i("id");
        if (headIDs.keySet().contains(id)) {
            HeadTypes type = headIDs.get(id);
            BetterAnimalsPlusMod.logger.debug("Fixed head tile entity {} to betteranimalsplus:head with type of {}", (Object)id, (Object)type.name());
            compound.func_74778_a("id", "betteranimalsplus:head");
            compound.func_74778_a("GENERIC_TYPE", type.name());
            if (compound.func_74764_b("SkullType")) {
                compound.func_82580_o("SkullType");
            }
            if (compound.func_74764_b("Rot")) {
                byte rotB = compound.func_74771_c("Rot");
                float rot = rotB;
                int newRot = Math.round(rot * 22.5f);
                compound.func_82580_o("Rot");
                compound.func_74768_a("rotation", newRot);
                BetterAnimalsPlusMod.logger.debug("Fixed rotation on skull above from {} to {}", (Object)Float.valueOf(rot), (Object)newRot);
            }
        }
        return compound;
    }

    static {
        headIDs.put("betteranimalsplus:foxheadtileentity", HeadTypes.FOXHEAD);
        headIDs.put("betteranimalsplus:boarheadtileentity", HeadTypes.BOARHEAD);
        headIDs.put("betteranimalsplus:deerheadtileentity", HeadTypes.DEERHEAD);
        headIDs.put("betteranimalsplus:hirschgeistskulltileentity", HeadTypes.HIRSCHGEIST);
        headIDs.put("betteranimalsplus:wolfheadtileentity", HeadTypes.WOLFHEAD);
        headIDs.put("betteranimalsplus:reindeerheadtileentity", HeadTypes.REINDEERHEAD);
    }
}

