/*
 * Decompiled with CFR 0.152.
 */
package com.thesledgehammer.retrobees.bees;

import com.thesledgehammer.retrobees.bees.alleles.AlleleEffectRegister;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;

public enum BeeBranches implements IBranchDefinition
{
    EMC("Energy-Matter-Convertis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }
    }
    ,
    TRANSMUTATED("Transmutatinis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            if (Loader.isModLoaded((String)"projecte")) {
                AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffectRegister.effectPhilosophersStone);
            }
        }
    }
    ,
    IRRADIATED("Irradiatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectRadioactive);
        }
    }
    ,
    LUMINESCE("Luminescis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    PHOSPHORESCE("Phosphorescis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    CORUSCATE("Coruscatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    SCINTILLATED("Scintillatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        }
    }
    ,
    OSCILLATED("Oscillatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    FULGURATED("Fulguratis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    PLATITUDINOUS("Platitudinousis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    OBFUSCATED("Obfuscatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    MONOTONOUS("Monotonis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectMisanthrope);
        }
    }
    ,
    ACHROMATIC("Achromaticis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    CADAVEROUSNESS("Cadaverousnessis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    RADIATE("Radiatis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
        }
    }
    ,
    ANEMIC("Anemicis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    SEPULCHRAL("Sepulcharalis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
        }
    }
    ,
    INCANDESCE("Incandescis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
        }
    }
    ,
    ADUMBRATE("Adumbratis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
        }
    };

    private final IClassification branch;
    @Nullable
    private static IAllele[] defaultTemplate;

    private BeeBranches(String scientific) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(Locale.ENGLISH), scientific);
    }

    protected void setBranchProperties(IAllele[] template) {
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = BeeBranches.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }
}

